/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.concurrent.atomic.AtomicReference;

public class ApplicationNameInfo {
    private static final Module kModule = new Module("ApplicationNameInfo");
    public static final ThreadLocal<String> ApplicationName = new ThreadLocal();
    private static volatile AtomicReference<String> globalApplicationName = new AtomicReference();
    private static volatile boolean isGlobalNameSet = false;
    private static volatile boolean canSetGlobalName = true;
    private static String fUserConfiguredAppName;
    private static IAgent sAgent;

    @Deprecated
    public static synchronized void setGlobalApplicationName(String applicationName) {
        ApplicationNameInfo.setGlobalApplicationName(applicationName, null);
    }

    public static synchronized void setGlobalApplicationName(String applicationName, String extensionName) {
        if (canSetGlobalName) {
            IAgent agent = sAgent;
            try {
                if (agent != null) {
                    if (extensionName != null) {
                        agent.IAgent_getModuleFeedback().info(kModule, "The Global application name had been set to '" + applicationName + "' by '" + extensionName + "' extension. If you have multiple applications deployed on your web server they all will assume this global name. If this behavior is not desirable please consider removing '" + extensionName + "' extension.");
                    } else {
                        agent.IAgent_getModuleFeedback().info(kModule, "The Global application name had been set to '" + applicationName + ". If you have multiple applications deployed on your web server they all will assume this global name.");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            globalApplicationName.set(applicationName);
            isGlobalNameSet = true;
        }
    }

    public static synchronized void turnOffGlobalApplicationNaming() {
        canSetGlobalName = false;
    }

    public static boolean isGlobalApplicationNameSet() {
        return isGlobalNameSet;
    }

    public static void initializeParameterLoader(IAgent agent) {
        sAgent = agent;
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new ConfigurationProperty("introscope.agent.application.name", "", "Hot_Property_Configuration_Property", null, true, false, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                String appName = (String)value;
                if (appName != null && (appName = appName.trim()).length() > 0) {
                    fUserConfiguredAppName = appName;
                }
            }
        });
    }

    public static String resolveApplicationName(String tracerAppName) {
        if (fUserConfiguredAppName != null && fUserConfiguredAppName.length() > 0) {
            return fUserConfiguredAppName;
        }
        String derivedAppName = ApplicationName.get();
        if (derivedAppName != null && derivedAppName.length() > 0) {
            return derivedAppName;
        }
        String globalAppName = globalApplicationName.get();
        if (globalAppName != null && globalAppName.length() > 0) {
            return globalAppName;
        }
        if (tracerAppName != null && tracerAppName.length() > 0 && !tracerAppName.equals("rootContext")) {
            return tracerAppName;
        }
        return "rootContext";
    }
}

