/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator;

import com.wily.introscope.agent.servletheaderdecorator.common.TomcatUtil;
import com.wily.org.apache.commons.codec.binary.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class TranInfoPayload {
    private static final String kstEncrypt1Parameters = "AES/CBC/PKCS5Padding";
    public static final int kiName_guid = 0;
    public static final int kiName_appServerIp = 1;
    public static final int kiName_agentName = 2;
    public static final int kiName_servletName = 3;
    public static final int kiName_servletRespTime = 4;
    public static final int kiName_hasGuidInfo = 5;
    public static final int kiName_hasTranTrace = 6;
    public static final int kiName_hasErrorTrace = 7;
    public static final int kiName_backendIpList = 8;
    public static final int kiName_agentHost = 9;
    public static final int kiName_agentProcess = 10;
    public static final String[] payloadNames = new String[]{"guid", "appServerIp", "agentName", "servletName", "servletResponseTime", "hasGuidInfo", "hasTranTrace", "hasErrorTrace", "backendIpList", "agentHost", "agentProcess"};
    public static final int kiEncoding_Clear = 0;
    public static final int kiEncoding_Obfuscated = 1;
    public static final int kiEncoding_SymEncrypt = 2;
    public static final int kiEncoding_Base64 = 3;
    public static final String[] payloadEncodings = new String[]{"Clear", "Obfuscated", "Encrypt1", "Base64"};
    public static final char kchPayloadEncodingSeparator = ' ';
    private String[] m_aValues;
    private int m_iEncoding = 0;
    private static byte[] shdRijndaelIv = new byte[]{18, -82, -103, -19, 33, -103, 120, 60, -110, -125, -3, 91, -45, 78, -8, -45};
    private static byte[] shdRijndaelKey128 = new byte[]{80, -57, 67, 114, -46, -81, -117, -12, 126, -31, -127, 83, -16, 104, 5, 7};

    public void addParameter(int name, String value) {
        if (this.m_aValues == null) {
            this.m_aValues = new String[payloadNames.length];
        }
        this.m_aValues[name] = value;
    }

    public String getParameter(int name) {
        return this.m_aValues[name];
    }

    public void setEncoding(int encoding) {
        this.m_iEncoding = encoding;
    }

    public String toPayloadString() throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        StringBuffer result = new StringBuffer();
        result.append(payloadEncodings[this.m_iEncoding]);
        result.append(' ');
        this.appendPayloadBody(result);
        return result.toString();
    }

    public String toClearPayloadBody() {
        StringBuffer result = new StringBuffer();
        this.appendClearPayloadBody(result);
        return result.toString();
    }

    private void appendPayloadBody(StringBuffer result) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        StringBuffer clearBody = new StringBuffer();
        this.appendClearPayloadBody(clearBody);
        byte[] clearBodyBytes = clearBody.toString().getBytes("UTF-8");
        switch (this.m_iEncoding) {
            case 0: {
                result.append(clearBody);
                return;
            }
            case 1: 
            case 2: {
                byte[] encryptedBytes = TranInfoPayload.encrypt(clearBodyBytes, clearBodyBytes.length);
                byte[] encodedBytes = TranInfoPayload.base64Encode(encryptedBytes);
                result.append(new String(encodedBytes, "UTF-8"));
                return;
            }
            case 3: {
                byte[] encodedBytes = TranInfoPayload.base64Encode(clearBodyBytes);
                result.append(new String(encodedBytes, "UTF-8"));
                return;
            }
        }
    }

    public static TranInfoPayload decodePayload(String payloadString) throws UnsupportedEncodingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        TranInfoPayload result = new TranInfoPayload();
        int separatorIndex = payloadString.indexOf(32);
        String encoding = payloadString.substring(0, separatorIndex);
        int encodingType = TranInfoPayload.parseEncodingType(encoding);
        String payloadBody = payloadString.substring(separatorIndex + 1);
        byte[] payloadBodyBytes = payloadBody.getBytes("UTF-8");
        switch (encodingType) {
            case 0: {
                result.addClearBody(payloadBody);
                return result;
            }
            case 1: 
            case 2: {
                byte[] decodedBody = TranInfoPayload.base64Decode(payloadBodyBytes);
                byte[] decryptedBody = TranInfoPayload.decrypt(decodedBody, decodedBody.length);
                result.addClearBody(new String(decryptedBody, "UTF-8"));
                return result;
            }
            case 3: {
                byte[] decodedBody = TranInfoPayload.base64Decode(payloadBodyBytes);
                result.addClearBody(new String(decodedBody, "UTF-8"));
                return result;
            }
        }
        return null;
    }

    private void addClearBody(String source) {
        HashMap paramMap = new HashMap();
        try {
            TomcatUtil.parseParameters(paramMap, source, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (String curKey : paramMap.keySet()) {
            int paramId = TranInfoPayload.parseParamName(curKey);
            String[] curParamValues = (String[])paramMap.get(curKey);
            this.addParameter(paramId, curParamValues[0]);
        }
    }

    private static int parseParamName(String source) {
        for (int i = 0; i < payloadNames.length; ++i) {
            if (!payloadNames[i].equals(source)) continue;
            return i;
        }
        return -1;
    }

    private static int parseEncodingType(String source) {
        for (int i = 0; i < payloadEncodings.length; ++i) {
            if (!payloadEncodings[i].equals(source)) continue;
            return i;
        }
        return -1;
    }

    private static byte[] base64Encode(byte[] clearBodyBytes) {
        Base64 encoder = new Base64();
        byte[] encodedBytes = encoder.encode(clearBodyBytes);
        return encodedBytes;
    }

    private static byte[] base64Decode(byte[] encodedBytes) {
        Base64 decoder = new Base64();
        byte[] decodedBytes = decoder.decode(encodedBytes);
        return decodedBytes;
    }

    private void appendClearPayloadBody(StringBuffer result) {
        boolean firstItem = true;
        for (int i = 0; i < payloadNames.length; ++i) {
            if (this.m_aValues[i] == null || this.m_aValues[i].length() <= 0) continue;
            if (!firstItem) {
                result.append('&');
            } else {
                firstItem = false;
            }
            result.append(URLEncoder.encode(payloadNames[i]));
            result.append('=');
            result.append(URLEncoder.encode(this.m_aValues[i]));
        }
    }

    private static byte[] encrypt(byte[] plainText, int inputLength) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(kstEncrypt1Parameters);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(shdRijndaelIv);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("AES");
        algorithmParameters.init(ivParameterSpec);
        SecretKeySpec skeySpec = new SecretKeySpec(shdRijndaelKey128, "AES");
        cipher.init(1, (Key)skeySpec, algorithmParameters);
        byte[] cipherText = cipher.doFinal(plainText, 0, inputLength);
        return cipherText;
    }

    private static byte[] decrypt(byte[] cypherText, int inputLength) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidParameterSpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(kstEncrypt1Parameters);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(shdRijndaelIv);
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("AES");
        algorithmParameters.init(ivParameterSpec);
        SecretKeySpec skeySpec = new SecretKeySpec(shdRijndaelKey128, "AES");
        cipher.init(2, (Key)skeySpec, algorithmParameters);
        byte[] plainText = cipher.doFinal(cypherText, 0, inputLength);
        return plainText;
    }
}

