/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postofficehub.ARoutingMessage;
import com.wily.isengard.postofficehub.IRouteTransport;
import com.wily.isengard.postofficehub.Route;

public class LoopbackTransport
implements IRouteTransport {
    private PostOffice fPostOffice;

    public LoopbackTransport(PostOffice postOffice) {
        this.fPostOffice = postOffice;
    }

    @Override
    public void sendMessage(AMessage message, Address address) {
        if (!(message instanceof ARoutingMessage)) {
            this.fPostOffice.deliverFromHub(message, address);
        }
    }

    @Override
    public void routeUp(Route route) {
        this.fPostOffice.postOfficeAdded(route.getPostOffice());
    }

    @Override
    public void routeDown(Route route) {
        this.fPostOffice.postOfficeRemoved(route.getPostOffice());
    }

    @Override
    public boolean isClosed() {
        return this.fPostOffice.isClosed();
    }

    @Override
    public void close() {
        this.fPostOffice.close();
    }

    @Override
    public String getRouteConnectionInfo() {
        return "Loopback connection";
    }

    public Address getCanonicalAddress(Address destination) {
        return this.fPostOffice.getCanonicalAddress(destination);
    }

    @Override
    public String getType() {
        return "loopback";
    }

    public String toString() {
        return "Loopback PO: " + this.fPostOffice;
    }
}

