/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.diagnos.personality.java.classfile.attributes.DGExceptionsAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGSourceFile;
import com.wily.diagnos.personality.java.classfile.attributes.DGWilyAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.IAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class DGAttributes {
    private static final int kDefaultAttributeCount = 3;
    private DGConstantPool fConstantPool;
    private Vector fAttributes;
    private String fInstrumentationInfo;
    private int fWilyIndex = -1;
    private int fCodeIndex = -1;
    private int fSourceFileIndex = -1;
    private int fExceptionsIndex = -1;
    private boolean fContainsAnnotations;

    public DGAttributes(DGConstantPool constantPool) {
        this.fConstantPool = constantPool;
        this.fAttributes = new Vector(3);
        this.fInstrumentationInfo = null;
    }

    public DGAttributes(DGConstantPool constantPool, DataInputStream input, ICompilerLog log) throws DGClassLoadingException, IOException {
        this(constantPool);
        int attributeCount = input.readUnsignedShort();
        for (int i = 0; i < attributeCount; ++i) {
            DGAttribute attribute = DGAttribute.createAttribute(constantPool, input, log);
            this.addAttribute(attribute);
        }
    }

    public List getAttributes() {
        return this.fAttributes;
    }

    public boolean hasAttributeNamed(String name) {
        for (int i = 0; i < this.fAttributes.size(); ++i) {
            DGAttribute att = (DGAttribute)this.fAttributes.elementAt(i);
            if (!att.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addAttribute(DGAttribute attribute) {
        this.fAttributes.addElement(attribute);
        if (attribute.getName().equals("com.wilytech.WilyAttribute")) {
            this.fWilyIndex = this.fAttributes.size() - 1;
        } else if (attribute.getName().equals("Code")) {
            this.fCodeIndex = this.fAttributes.size() - 1;
        } else if (attribute.getName().equals("Exceptions")) {
            this.fExceptionsIndex = this.fAttributes.size() - 1;
        } else if (attribute.getName().equals("SourceFile")) {
            this.fSourceFileIndex = this.fAttributes.size() - 1;
        } else if (!this.fContainsAnnotations && (attribute.getName().equals("RuntimeVisibleAnnotations") || attribute.getName().equals("RuntimeInvisibleAnnotations") || attribute.getName().equals("RuntimeVisibleParameterAnnotations") || attribute.getName().equals("RuntimeInvisibleParameterAnnotations") || attribute.getName().equals("AnnotationDefault"))) {
            this.fContainsAnnotations = true;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        int count = this.fAttributes.size();
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            DGAttribute attribute = (DGAttribute)this.fAttributes.elementAt(i);
            attribute.write(out);
        }
    }

    public boolean hasWilyAttribute() {
        return this.fWilyIndex >= 0;
    }

    public void setInstrumentationInfo(String instrumentationInfo) {
        this.fInstrumentationInfo = instrumentationInfo;
    }

    public void addWilyAttribute() throws DGClassModificationException, IOException {
        if (this.fWilyIndex < 0) {
            DGWilyAttribute attribute = new DGWilyAttribute(this.fConstantPool, this.fInstrumentationInfo);
            this.fWilyIndex = this.fAttributes.size();
            this.fAttributes.addElement(attribute);
        }
    }

    public DGWilyAttribute getWilyAttribute() {
        if (this.fWilyIndex >= 0) {
            return (DGWilyAttribute)this.fAttributes.elementAt(this.fWilyIndex);
        }
        return null;
    }

    public boolean hasCodeAttribute() {
        return this.fCodeIndex >= 0;
    }

    public DGCode getCodeAttribute() {
        if (this.fCodeIndex >= 0) {
            return (DGCode)this.fAttributes.elementAt(this.fCodeIndex);
        }
        return null;
    }

    public boolean hasSourceFileAttribute() {
        return this.fSourceFileIndex >= 0;
    }

    public DGSourceFile getSourceFileAttribute() {
        if (this.fSourceFileIndex >= 0) {
            return (DGSourceFile)this.fAttributes.elementAt(this.fSourceFileIndex);
        }
        return null;
    }

    public boolean hasExceptionsAttribute() {
        return this.fExceptionsIndex >= 0;
    }

    public boolean hasAnnotations() {
        return this.fContainsAnnotations;
    }

    public DGExceptionsAttribute getExceptionsAttribute() {
        if (this.fExceptionsIndex >= 0) {
            return (DGExceptionsAttribute)this.fAttributes.elementAt(this.fExceptionsIndex);
        }
        return null;
    }

    public String[] getPossibleKeys() {
        if (this.hasAnnotations()) {
            for (DGAttribute attribute : this.getAttributes()) {
                if (!(attribute instanceof IAnnotationAttribute)) continue;
                IAnnotationAttribute annotationAttribute = (IAnnotationAttribute)((Object)attribute);
                return annotationAttribute.getPossibleKeys();
            }
        }
        return new String[0];
    }
}

