/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.jdbc;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.trace.jdbc.IGenericDBNameFormatter;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.List;

final class DBNameFormatterLoader {
    private static final String kDBNameFormatterPluginType = "dbnameformatter";
    private static final int kCurrentDBNameFormatterPluginVersion = 1;
    private IAgent fAgent;
    private IValidationFeedbackChannel fValidationFeedbackChannel;

    public DBNameFormatterLoader(IAgent agent) {
        this.fAgent = agent;
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
    }

    public List<IGenericDBNameFormatter> getDatabaseNameFormatterPlugins() {
        ExtensionAdministrator extensionAdministrator = this.fAgent.IAgent_getExtensionAdministrator();
        Assertion.wilyAssert((boolean)false);
        ArrayList<IGenericDBNameFormatter> dbNameFormatters = new ArrayList<IGenericDBNameFormatter>();
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kDBNameFormatterPluginType);
        for (int i = 0; i < plugins.length; ++i) {
            IGenericDBNameFormatter dbNameFormmaterInstance = this.getDatabaseNameFormatterInstance(plugins[i]);
            if (dbNameFormmaterInstance == null) continue;
            dbNameFormatters.add(dbNameFormmaterInstance);
        }
        return dbNameFormatters;
    }

    private IGenericDBNameFormatter getDatabaseNameFormatterInstance(IPlugin plugin) {
        IModuleFeedbackChannel feedback = this.fAgent.IAgent_getModuleFeedback();
        IStringLocalizer strLocalizer = this.fAgent.IAgent_getStringLocalizer();
        IGenericDBNameFormatter instance = null;
        Class dbNameFormatterClass = ExtensionUtilities.loadEntryPointClass((IModuleFeedbackChannel)feedback, (IStringLocalizer)strLocalizer, (IPlugin)plugin, (int)1, IGenericDBNameFormatter.class, (IValidationFeedbackChannel)this.fValidationFeedbackChannel);
        if (dbNameFormatterClass != null) {
            try {
                instance = (IGenericDBNameFormatter)dbNameFormatterClass.newInstance();
            }
            catch (InstantiationException e) {
                feedback.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                feedback.error(e.getMessage());
            }
        }
        return instance;
    }
}

