/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.sap;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.jmx.JNDIMBeanServerLocator;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;

public class JMXCustomizer
implements IJMXCustomizer {
    private String fClusterName = null;
    private String fClusterNodeName = null;
    private IMBeanServerLocator[] fMBeanServerLocators = null;
    private final AccessControlContext fAccessControlContext;
    private static final Module sModule = new Module("JMXCustomizer");
    private static final String CLUSTER = "{CLUSTER}";
    private static final String CLUSTERNODE = "{CLUSTERNODE}";

    public JMXCustomizer(AccessControlContext acc) {
        this.fAccessControlContext = acc;
    }

    @Override
    public IMBeanServerLocator[] getMBeanServerLocators(IAgent agent) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        feedback.trace(sModule, "getMBeanServerLocators");
        if (this.fMBeanServerLocators == null) {
            this.fMBeanServerLocators = new IMBeanServerLocator[]{new JNDIMBeanServerLocator(agent)};
        }
        return this.fMBeanServerLocators;
    }

    @Override
    public String[] modifyFilters(IAgent agent, String[] filterKeys) {
        final IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        feedback.trace(sModule, "modifyFilters");
        if (filterKeys == null || filterKeys.length == 0) {
            return filterKeys;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                JMXCustomizer.this.resolveClusterProperties(feedback);
                return null;
            }
        }, this.fAccessControlContext);
        String[] replKeys = (String[])filterKeys.clone();
        String repl = null;
        for (int i = 0; i < filterKeys.length; ++i) {
            repl = null;
            if (this.fClusterName != null && replKeys[i].indexOf(CLUSTER) > -1) {
                replKeys[i] = repl = StringUtils.replace((String)replKeys[i], (String)CLUSTER, (String)this.fClusterName);
            }
            if (this.fClusterNodeName != null && replKeys[i].indexOf(CLUSTERNODE) > -1) {
                replKeys[i] = repl = StringUtils.replace((String)replKeys[i], (String)CLUSTERNODE, (String)this.fClusterNodeName);
            }
            if (repl == null || !feedback.isDebugEnabled(sModule)) continue;
            feedback.debug(sModule, "Modified JMX filter, " + filterKeys[i] + ", the new value is: " + repl);
        }
        return replKeys;
    }

    public void resolveClusterProperties(IModuleFeedbackChannel feedback) {
        block5: {
            this.fClusterName = null;
            this.fClusterNodeName = null;
            try {
                InitialContext initCtx = new InitialContext();
                MBeanServer beanServer = (MBeanServer)initCtx.lookup("jmx");
                Object[] clusterNodeMBeans = beanServer.queryMBeans(new ObjectName("*:j2eeType=SAP_J2EEClusterNode,*"), null).toArray();
                for (int i = 0; i < clusterNodeMBeans.length; ++i) {
                    ObjectInstance clusterNode = (ObjectInstance)clusterNodeMBeans[i];
                    MBeanInfo beanInfo = beanServer.getMBeanInfo(clusterNode.getObjectName());
                    MBeanAttributeInfo[] attributeInfo = beanInfo.getAttributes();
                    for (int j = 0; j < attributeInfo.length; ++j) {
                        String prop2;
                        Properties props;
                        String prop1;
                        String name = attributeInfo[j].getName();
                        if (!"SystemProperties".equals(name) || (prop1 = (props = (Properties)beanServer.getAttribute(clusterNode.getObjectName(), name)).getProperty("jstartup.ownProcessId")) == null || !prop1.equals(prop2 = System.getProperty("jstartup.ownProcessId"))) continue;
                        this.fClusterName = clusterNode.getObjectName().getKeyProperty("SAP_J2EECluster");
                        if (this.fClusterName != null && feedback.isDebugEnabled(sModule)) {
                            feedback.debug(sModule, "Resolved cluster name: " + this.fClusterName);
                        }
                        this.fClusterNodeName = clusterNode.getObjectName().getKeyProperty("name");
                        if (this.fClusterNodeName == null || !feedback.isDebugEnabled(sModule)) continue;
                        feedback.debug(sModule, "Resolved cluster node name: " + this.fClusterNodeName);
                    }
                }
            }
            catch (Exception ex) {
                if (!feedback.isDebugEnabled(sModule)) break block5;
                feedback.debug(sModule, "Unable to resolve cluster properties", (Throwable)ex);
            }
        }
    }
}

