/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.isengard.data.IIsengardCachedData;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.util.adt.LongHashtable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public final class Frequency
implements Externalizable,
IIsengardReadResolve,
IIsengardCachedData {
    private static final long serialVersionUID = -4575905918559765771L;
    public static final int kDefaultSystemFrequencyInSeconds = 15;
    public static final long kDefaultSystemFrequencyInMillis = 15000L;
    public static final long kDefaultAgentFrequencyInMillis = 7500L;
    private long fMilliseconds;
    private static final LongHashtable sFrequencyCache = new LongHashtable();
    public static final Frequency[] kZeroLengthESEFrequencyArray = new Frequency[0];
    public static final Frequency kDefaultSystemFrequency = Frequency.addESEFrequencyToCache(15000L);
    public static final Frequency kDefaultAgentFrequency = Frequency.addESEFrequencyToCache(7500L);

    private static Frequency lookupESEFrequencyFromCache(long millis) {
        return (Frequency)sFrequencyCache.get(millis);
    }

    private static Frequency getESEFrequencyFromCache(long millis) {
        if (millis == 15000L) {
            return kDefaultSystemFrequency;
        }
        if (millis == 7500L) {
            return kDefaultAgentFrequency;
        }
        Frequency result = Frequency.lookupESEFrequencyFromCache(millis);
        if (result == null) {
            result = Frequency.addESEFrequencyToCache(millis);
        }
        return result;
    }

    private static synchronized Frequency addESEFrequencyToCache(long millis) {
        Frequency result = Frequency.lookupESEFrequencyFromCache(millis);
        if (result == null) {
            result = new Frequency(millis);
            sFrequencyCache.put(millis, result);
        }
        return result;
    }

    private Frequency(long millis) {
        this.fMilliseconds = millis;
    }

    public Frequency() {
    }

    public static Frequency getFrequencyInSeconds(int seconds) {
        return Frequency.getFrequencyInMillis((long)seconds * 1000L);
    }

    public static Frequency getFrequencyInSeconds(long seconds) {
        return Frequency.getFrequencyInMillis(seconds * 1000L);
    }

    public static Frequency getFrequencyInMillis(long millis) {
        if (millis > Integer.MAX_VALUE) {
            millis = 2147475000L;
        }
        return Frequency.getESEFrequencyFromCache(millis);
    }

    public static Frequency getFrequencyInMillis(int millis) {
        return Frequency.getFrequencyInMillis((long)millis);
    }

    public int getPeriodInSeconds() {
        return (int)(this.getPeriodInMilliseconds() / 1000L);
    }

    public long getPeriodInMilliseconds() {
        return this.fMilliseconds;
    }

    public String toString() {
        return "Frequency: " + this.getPeriodInSeconds() + " (s) ";
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return Frequency.getFrequencyInMillis(this.fMilliseconds);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int hiOrder = (int)(this.fMilliseconds >> 32);
        if (hiOrder != 0) {
            out.writeInt(hiOrder | Integer.MIN_VALUE);
        }
        out.writeInt((int)(this.fMilliseconds & 0xFFFFFFFFL));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int hiOrder = in.readInt();
        if ((hiOrder & Integer.MIN_VALUE) == 0) {
            this.fMilliseconds = hiOrder;
            return;
        }
        this.fMilliseconds = (long)(hiOrder &= Integer.MAX_VALUE) << 32 | (long)in.readInt() & 0xFFFFFFFFL;
    }

    public static Frequency computeFrequencyForTimeRange(long startTime, long endTime, long dataPointCount) {
        long frequencyInSeconds = (endTime - startTime) / (dataPointCount * 1000L);
        frequencyInSeconds = (int)Math.ceil((float)frequencyInSeconds / 15.0f);
        if ((frequencyInSeconds *= 15L) > 0L) {
            return Frequency.getFrequencyInSeconds(frequencyInSeconds);
        }
        return kDefaultSystemFrequency;
    }
}

