/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalemetric;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stalemetric.ApmStaleMetricManager;
import com.wily.introscope.agent.stalemetric.StaleMetricLogger;
import com.wily.util.thread.IThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StaleMetricCleanScheduler
implements Runnable {
    private static final String STALEMETRIC_SCHEDULE_INTERVAL_MINUTES = "introscope.agent.stalemetrics.schedule.interval.minutes";
    private static final int DEFAULT_STALEMETRIC_SCHEDULE_INTERVAL_MINUTES = 5;
    private static final String THREAD_FACTORY_PREFIX_STR = "StaleMetric Clean Schedular-";

    public static void initSchedular(IAgent agent) {
        try {
            int scheduleInterval = agent.IAgent_getIndexedProperties().getIntProperty(STALEMETRIC_SCHEDULE_INTERVAL_MINUTES, 5);
            ScheduledThreadPoolExecutor cleanStaleMetricScheduler = new ScheduledThreadPoolExecutor(1, new CleanStaleMetricThreadFactory(agent));
            cleanStaleMetricScheduler.scheduleAtFixedRate(new StaleMetricCleanScheduler(), 0L, scheduleInterval, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            StaleMetricLogger.getLogger().warn("Exception in initSchedular method, default schedule interval (minutes) set to :5");
            int scheduleInterval = 5;
            ScheduledThreadPoolExecutor cleanStaleMetricScheduler = new ScheduledThreadPoolExecutor(1);
            cleanStaleMetricScheduler.scheduleAtFixedRate(new StaleMetricCleanScheduler(), 0L, scheduleInterval, TimeUnit.MINUTES);
        }
    }

    @Override
    public void run() {
        ApmStaleMetricManager.getInstance().cleanStaleMetricMapOnEntryExpire();
    }

    static class CleanStaleMetricThreadFactory
    implements ThreadFactory {
        final IThreadFactory agentFactory;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        CleanStaleMetricThreadFactory(IAgent agent) {
            this.agentFactory = agent.IAgent_getAgentThreadFactory();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.agentFactory.IThreadFactory_createNewThread("StaleMetric Clean Schedular--" + this.threadNumber.getAndIncrement(), r);
            return t;
        }
    }
}

