/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.personality.java.tracer.DGIntelligentInstrumentationStreamMethodTracerInstance;
import com.wily.introscope.agent.intelligent.detection.IPersistenceService;
import com.wily.introscope.agent.intelligent.entrypoint.AnomalyDetector;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceHelper;
import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceService;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EntryPointPersistenceService
implements IPersistenceService,
AnomalyDetector {
    private final Map<Integer, AtomicInteger[]> probeReqCountMap = new ConcurrentHashMap<Integer, AtomicInteger[]>();
    private final Set<EntryPointAnomaly> anomalies = new HashSet<EntryPointAnomaly>(5);

    private EntryPointPersistenceService() {
        this.anomalies.add(new RedundantRequestsAnomaly());
        this.anomalies.add(new EPClampHitAnomaly());
        this.anomalies.add(new BlacklistClampHitAnomaly());
    }

    @Override
    public boolean persistSkip(String className, String methodName, String signature) {
        short probeIndex = AnalysedClassesMapInitializer.getSequentialProbeIndexForMethod((String)className, (String)methodName, (String)signature);
        this.recordSkipPersistRequest(probeIndex);
        return FilePersistenceService.persistInstrumentation(className, methodName, signature, FilePersistenceService.TracingType.SKIP);
    }

    @Override
    public boolean persistSkip(int probeIndex) {
        this.recordSkipPersistRequest(probeIndex);
        List<String[]> probeInfo = DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo;
        String className = probeInfo.get(probeIndex)[0];
        String methodName = probeInfo.get(probeIndex)[1];
        String signature = probeInfo.get(probeIndex)[2];
        return FilePersistenceService.persistInstrumentation(className, methodName, signature, FilePersistenceService.TracingType.SKIP);
    }

    @Override
    public boolean persistTracing(String className, String methodName, String signature) {
        short probeIndex = AnalysedClassesMapInitializer.getSequentialProbeIndexForMethod((String)className, (String)methodName, (String)signature);
        this.recordEPPersistRequest(probeIndex);
        return FilePersistenceService.persistInstrumentation(className, methodName, signature, FilePersistenceService.ENTRY_POINT_TRACINGS);
    }

    @Override
    public boolean persistTracing(int probeIndex) {
        this.recordEPPersistRequest(probeIndex);
        List<String[]> probeInfo = DGIntelligentInstrumentationStreamMethodTracerInstance.kAllIntelligentProbeInfo;
        String className = probeInfo.get(probeIndex)[0];
        String methodName = probeInfo.get(probeIndex)[1];
        String signature = probeInfo.get(probeIndex)[2];
        return FilePersistenceService.persistInstrumentation(className, methodName, signature, FilePersistenceService.ENTRY_POINT_TRACINGS);
    }

    private AtomicInteger getCounter(int probeIndex, int counterIndex) {
        AtomicInteger[] ar = this.probeReqCountMap.get(probeIndex);
        if (ar == null) {
            ar = new AtomicInteger[]{new AtomicInteger(0), new AtomicInteger(0)};
            this.probeReqCountMap.put(probeIndex, ar);
        }
        return ar[counterIndex];
    }

    private void recordEPPersistRequest(int probeIndex) {
        this.getCounter(probeIndex, 0).getAndIncrement();
    }

    private void recordSkipPersistRequest(int probeIndex) {
        this.getCounter(probeIndex, 1).getAndIncrement();
    }

    public void run() {
        Logger.logTraceMessage((String)"EntryPoint Anomaly Detector task started");
        if (this.hasNoticedAnomaly()) {
            this.takeAction();
        }
    }

    public boolean hasNoticedAnomaly() {
        for (EntryPointAnomaly anomaly : this.anomalies) {
            if (!anomaly.isPresent()) continue;
            Logger.logInfoMessage((String)("EntryPoint Anomaly Detector - Detected abnormal behavior: " + anomaly.describe()));
            return true;
        }
        return false;
    }

    public void takeAction() {
        this.clearCache();
        EntryPointDetectionConfiguration.shutdown();
    }

    void clearCache() {
        this.probeReqCountMap.clear();
    }

    public static EntryPointPersistenceService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class BlacklistClampHitAnomaly
    implements EntryPointAnomaly {
        private BlacklistClampHitAnomaly() {
        }

        @Override
        public boolean isPresent() {
            return FilePersistenceHelper.getSkippedMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceBlacklistClampSize();
        }

        @Override
        public String describe() {
            return "Reached the limit of Skip entries in AutoPersist.pbd";
        }
    }

    private static class EPClampHitAnomaly
    implements EntryPointAnomaly {
        private EPClampHitAnomaly() {
        }

        @Override
        public boolean isPresent() {
            return FilePersistenceHelper.getEntryPointMethodsCountInPbd() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize();
        }

        @Override
        public String describe() {
            return "Reached the limit of Entry Point entries in AutoPersist.pbd";
        }
    }

    private class RedundantRequestsAnomaly
    implements EntryPointAnomaly {
        private RedundantRequestsAnomaly() {
        }

        @Override
        public boolean isPresent() {
            int anomalyThreshold = EntryPointDetectionConfiguration.getAnomalyDetectorRequestsMax();
            for (Map.Entry entry : EntryPointPersistenceService.this.probeReqCountMap.entrySet()) {
                AtomicInteger[] counters = (AtomicInteger[])entry.getValue();
                if (((Integer)entry.getKey() == -1 || counters[0] == null || counters[0].get() <= anomalyThreshold) && (counters[1] == null || counters[1].get() <= anomalyThreshold)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String describe() {
            return "Redundant requests to persist directives";
        }
    }

    private static interface EntryPointAnomaly {
        public boolean isPresent();

        public String describe();
    }

    private static class SingletonHolder {
        private static final EntryPointPersistenceService INSTANCE = new EntryPointPersistenceService();

        private SingletonHolder() {
        }
    }
}

