/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.PropertyDefinerBase;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.feedback.backend.logback.LogbackBackend;
import com.wily.util.INameChangeListener;
import com.wily.util.StringUtils;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.IndexedProperties;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;

public class AgentNamePropertyDefiner
extends PropertyDefinerBase {
    private static final int kSendEnvironmentCycleTime = 30000;
    private final IAgent agent = this.getAgent();
    private final boolean isLogAutonamingEnabled;
    String agentName = null;
    private static final String kTimestampFormatString = "yyyyMMdd-HHmmss";
    private static final SimpleDateFormat kTimestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public AgentNamePropertyDefiner() {
        if (this.agent != null) {
            this.isLogAutonamingEnabled = this.agent.IAgent_isLogFileAutoNamingEnabled();
            if (this.isLogAutonamingEnabled) {
                IsengardServerConnectionManager serverConnection = this.agent.IAgent_getIsengardServerConnection();
                if (serverConnection != null) {
                    this.agentName = serverConnection.getActualAgentName();
                }
                final INameChangeListener listener = new INameChangeListener(){

                    public void INameChangeListener_nameChanged(String newName) {
                        if (!newName.equals(AgentNamePropertyDefiner.this.agentName)) {
                            AgentNamePropertyDefiner.this.agentName = newName;
                            LoggerContext ctx = (LoggerContext)AgentNamePropertyDefiner.this.context;
                            IndexedProperties props = AgentNamePropertyDefiner.this.agent.IAgent_getIndexedProperties();
                            LogbackBackend.getInstance().reloadLoggerConfiguration((Properties)props);
                        }
                    }
                };
                new WaitAndExecuteBehavior(this.agent.IAgent_getCommonHeartbeat(), 30000L, "Check Connection for setup Agent log negotiated name listener"){

                    protected boolean execute() {
                        IsengardServerConnectionManager m = AgentNamePropertyDefiner.this.agent.IAgent_getIsengardServerConnection();
                        if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
                            AgentNamePropertyDefiner.this.agent.IAgent_addNameChangeListener(listener);
                            AgentNamePropertyDefiner.this.agent.IAgent_addNegotiatedNameChangeListener(listener);
                            return true;
                        }
                        return false;
                    }
                };
                if (this.agentName == null) {
                    String timestamp;
                    Calendar rightNow = Calendar.getInstance();
                    this.agentName = timestamp = kTimestampFormat.format(rightNow.getTime());
                }
            }
        } else {
            this.isLogAutonamingEnabled = false;
        }
    }

    private IAgent getAgent() {
        try {
            return AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    @Override
    public String getPropertyValue() {
        if (!this.isLogAutonamingEnabled) {
            return "";
        }
        if (!StringUtils.isEmpty((String)this.agentName)) {
            String safeAgentName = StringUtils.replaceNonAlphaNumericCharacters((String)this.agentName, (char)'_');
            return "." + safeAgentName;
        }
        return "";
    }
}

