/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.AgentMessageServiceRegistration;
import com.wily.introscope.agent.connection.ClientInfo;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.isengard.container.IMessageServiceReference;
import com.wily.isengard.container.MessageServiceRegistration;
import com.wily.isengard.container.MessageServiceRegistry;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class AgentMessageServiceRegistry
extends MessageServiceRegistry
implements IServerConnectionNotification,
INameChangeListener {
    private final IsengardServerConnectionManager fConnectionManager;
    private final List fAgentRegistrations = new ArrayList();

    public AgentMessageServiceRegistry(IModuleFeedbackChannel feedback, IsengardServerConnectionManager manager) {
        super(feedback, null);
        this.fConnectionManager = manager;
    }

    @Override
    public synchronized IMessageServiceReference addMessageServiceRegistration(MessageServiceRegistration registration) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        AgentMessageServiceRegistration reg;
        if (registration instanceof AgentMessageServiceRegistration && (reg = (AgentMessageServiceRegistration)registration).isPrependAgentNameToRelativeServiceName()) {
            return this.addAgentMessageServiceRegistration(reg);
        }
        return super.addMessageServiceRegistration(registration);
    }

    private synchronized IMessageServiceReference addAgentMessageServiceRegistration(AgentMessageServiceRegistration registration) throws EntryAlreadyExistsException, ConnectionException, InvalidIsengardInterface, InvalidPathException {
        MessageServiceRegistration namedRegistration = this.getNamedMessageServiceRegistration(registration);
        IMessageServiceReference ref = super.addMessageServiceRegistration(namedRegistration);
        AgentMessageServiceReference agentServiceRef = new AgentMessageServiceReference(registration, ref);
        this.fAgentRegistrations.add(agentServiceRef);
        return agentServiceRef;
    }

    private MessageServiceRegistration getNamedMessageServiceRegistration(AgentMessageServiceRegistration registration) {
        String fullAgentName = this.getFullAgentName(this.fConnectionManager.getClientInfo());
        String relativeServiceName = registration.getRelativeServiceName();
        relativeServiceName = relativeServiceName == null || relativeServiceName.length() == 0 ? fullAgentName : fullAgentName + '/' + relativeServiceName;
        MessageServiceRegistration namedRegistration = new MessageServiceRegistration(registration.getHandler(), registration.getInterfaceClass(), relativeServiceName, registration.getSecurityGroups(), registration.isGrouped());
        namedRegistration.setPrependHubNameToRelativeServiceName(registration.isPrependHubNameToRelativeServiceName());
        return namedRegistration;
    }

    private String getFullAgentName(ClientInfo clientInfo) {
        return MessageFormat.format("{0}|{1}|{2}", clientInfo.getHostName(), clientInfo.getProcessName(), this.fConnectionManager.getActualAgentName());
    }

    @Override
    public void connectionDown() {
        this.noticeDisconnected();
    }

    @Override
    public void connectionUp() {
        this.noticeConnected(this.fConnectionManager.getConnectedServer().getPostOffice());
    }

    @Override
    public synchronized void INameChangeListener_nameChanged(String newName) {
        for (AgentMessageServiceReference ref : this.fAgentRegistrations) {
            ref.unregisterActualReference();
            MessageServiceRegistration namedServiceRegistration = this.getNamedMessageServiceRegistration(ref.fOriginalServiceRegistration);
            try {
                ref.fActualServiceReference = super.addMessageServiceRegistration(namedServiceRegistration);
            }
            catch (Exception e) {
                this.getModuleFeedback().debug(e);
            }
        }
    }

    public synchronized boolean removeAgentServiceReference(AgentMessageServiceReference reference) {
        return this.fAgentRegistrations.remove(reference);
    }

    private class AgentMessageServiceReference
    implements IMessageServiceReference {
        IMessageServiceReference fActualServiceReference;
        AgentMessageServiceRegistration fOriginalServiceRegistration;

        public AgentMessageServiceReference(AgentMessageServiceRegistration originalServiceRegistration, IMessageServiceReference actualServiceReference) {
            this.fOriginalServiceRegistration = originalServiceRegistration;
            this.fActualServiceReference = actualServiceReference;
        }

        @Override
        public void unregister() {
            AgentMessageServiceRegistry.this.removeAgentServiceReference(this);
            this.unregisterActualReference();
        }

        void unregisterActualReference() {
            if (this.fActualServiceReference != null) {
                this.fActualServiceReference.unregister();
                this.fActualServiceReference = null;
            }
        }
    }
}

