/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.osgi.bootdelegation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class EquinoxOsgiBootdelegationHelper
extends ASingleInstanceTracerFactory {
    private final IModuleFeedbackChannel logger;
    private static String bootdelegationFieldName = "bootDelegationStems";
    private static String wilybootdelegationValue = "com.wily.";
    public static boolean shouldTurnOffTracer = false;
    private static AtomicInteger shouldLog = new AtomicInteger(0);

    public EquinoxOsgiBootdelegationHelper(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (data.getInvocationParameterCount() == 1 && data.getInvocationParameterAsObject(0) instanceof String) {
            try {
                shouldTurnOffTracer = true;
                Object obj = data.getInvocationObject();
                Class<?> clazz = obj.getClass();
                Field bootDelegationStems = clazz.getDeclaredField(bootdelegationFieldName);
                Object[] oldValue = (String[])ReflectionUtils.getFinalField(obj, bootDelegationStems);
                if (Arrays.asList(oldValue).contains(wilybootdelegationValue)) {
                    if (shouldLog.getAndIncrement() == 0) {
                        this.logger.info("Found " + wilybootdelegationValue + " in osgi bootdelegation configuration " + Arrays.toString(oldValue));
                    }
                    return;
                }
                Object[] newValue = new String[oldValue.length + 1];
                System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
                newValue[newValue.length - 1] = wilybootdelegationValue;
                ReflectionUtils.setFinalField(obj, bootDelegationStems, newValue);
                if (shouldLog.getAndIncrement() == 0) {
                    this.logger.info("Adding " + wilybootdelegationValue + " to osgi bootdelegation configuration, set to " + Arrays.toString(newValue));
                }
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Failed to set equinox osgi bootdelegation: " + e.getMessage());
                this.logger.debug("Caught exception:", e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("Failed to set equinox osgi bootdelegation: " + e.getMessage());
                this.logger.debug("Caught exception:", e);
            }
            catch (SecurityException e) {
                this.logger.error("Failed to set equinox osgi bootdelegation: " + e.getMessage());
                this.logger.debug("Caught exception:", e);
            }
            catch (NoSuchFieldException e) {
                this.logger.error("Failed to set equinox osgi bootdelegation: " + e.getMessage());
                this.logger.debug("Caught exception:", e);
            }
            catch (Exception e) {
                this.logger.error("Failed to set equinox osgi bootdelegation: " + e.getMessage());
                this.logger.debug("Caught exception:", e);
            }
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return shouldTurnOffTracer;
    }
}

