/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.ArfDataConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class TcpArfDataConnection
extends ArfDataConnection {
    private PrintWriter fOut;
    private BufferedReader fIn;
    private Socket fSocket;

    public TcpArfDataConnection(IAgent agent, Socket socket, BufferedReader input, String connectMessage) throws ArfException, IOException {
        super(agent, connectMessage);
        this.fSocket = socket;
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = input;
        if (this.fIn == null) {
            this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
    }

    public TcpArfDataConnection(IAgent agent, Socket socket) throws IOException {
        super(agent);
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    @Override
    protected void writeToTransport(String message) {
        if (this.fOut != null) {
            this.fOut.println(message);
        }
    }

    protected boolean pingConnection() {
        return false;
    }

    protected void pingResponse() {
    }

    @Override
    protected String waitForNextMessage() {
        try {
            return this.fIn.readLine();
        }
        catch (IOException e) {
            if (this.fListener != null) {
                this.fListener.processMessageError(this, null, new ArfException(e.getMessage()));
            }
            this.close();
            return null;
        }
    }

    @Override
    public String toString() {
        return "TcpArfDataConnection " + (this.isClient() ? "Client" : "Server");
    }

    @Override
    protected void closeConnection() {
        try {
            if (this.fOut != null) {
                this.fOut.close();
            }
            if (this.fSocket != null) {
                this.fSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fIn = null;
        this.fOut = null;
        this.fSocket = null;
    }
}

