/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import javax.naming.NameNotFoundException;

public class CrossProcessCorrelationEjbTracer
extends ASingleInstanceTracerFactory {
    private static ThreadLocal weblogicCorrelationContext = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private boolean fWeblogicContext = false;
    private boolean fHasAcquiredCorrelationContext = false;
    private static IModuleFeedbackChannel fFeedback;
    private static volatile PbdCreator fPbdCreator;

    public CrossProcessCorrelationEjbTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        fFeedback = agent.IAgent_getModuleFeedback();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.fHasAcquiredCorrelationContext) {
            IPlatformCrossProcessDataHelper helper = null;
            try {
                helper = CrossProcessDataHelper.getInstance().getValidEjbCrossProcessHelper();
            }
            catch (NameNotFoundException e) {
                fFeedback.error(e);
            }
            if (helper != null) {
                if (helper.getPlatformType() == 0) {
                    if (this.fWeblogicContext) {
                        helper.teardown(this.getModuleFeedback());
                        weblogicCorrelationContext.set(Boolean.FALSE);
                        this.fWeblogicContext = false;
                        if (fFeedback.isDebugEnabled()) {
                            fFeedback.debug("CorrelationTrace: weblogicContext calling teardown");
                        }
                    } else if (fFeedback.isDebugEnabled()) {
                        fFeedback.debug("CorrelationTrace: weblogicContext Not calling teardown since this is not the first executed tracer");
                    }
                    return;
                }
                if (fFeedback.isDebugEnabled()) {
                    fFeedback.debug("CorrelationTrace: websphereContext calling teardown");
                }
                helper.teardown(this.getModuleFeedback());
            }
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean shouldCurrentBePropagated = false;
        IPlatformCrossProcessDataHelper helper = null;
        try {
            helper = CrossProcessDataHelper.getInstance().getValidEjbCrossProcessHelper();
        }
        catch (NameNotFoundException e) {
            fFeedback.debug("CorrelationTrace: NameNotFoundException occurs when calling getValidEjbCrossProcessHelper() in ITracer_startTrace.");
            fPbdCreator = PbdCreator.getPbdCreatorInstance();
            fPbdCreator.dumpClassInfo(this.getAgent(), data);
        }
        if (helper != null) {
            if (helper.getPlatformType() == 0 && !((Boolean)weblogicCorrelationContext.get()).booleanValue()) {
                weblogicCorrelationContext.set(Boolean.TRUE);
                this.fWeblogicContext = true;
            }
            boolean initializationStatus = false;
            SharedCrossProcessData sdata = this.getAgent().IAgent_getComponentTracer().getCrossProcessDataCache();
            shouldCurrentBePropagated = true;
            if (shouldCurrentBePropagated) {
                SharedCrossProcessData cache;
                if (fFeedback.isDebugEnabled()) {
                    fFeedback.debug("CorrelationTrace: currentTrace is marked for propagation");
                }
                initializationStatus = helper.initialize(this.getModuleFeedback());
                if (fFeedback.isDebugEnabled()) {
                    fFeedback.debug("CorrelationTrace: initialize status was " + initializationStatus);
                }
                if (initializationStatus && (cache = helper.getCurrentCrossProcessData(true, fFeedback)) != null) {
                    this.fHasAcquiredCorrelationContext = true;
                    if (fFeedback.isDebugEnabled()) {
                        fFeedback.debug("CorrelationTracer: calling incrementAndpropagate");
                    }
                    if (!cache.isFirstInProcessFlag()) {
                        helper.incrementAndPropagateSequenceId(this.getAgent().IAgent_getModuleFeedback());
                    }
                }
            }
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static class PbdCreator {
        private final String kForwardSlash = "//";
        private final String kBackSlash = "\\\\";
        private String path;
        private String superClassName = null;
        private ArrayList interfaceNameArray = new ArrayList();
        private String skipClassName = null;
        private int classCounter;
        private final int skipClassThreshold = 5;
        private HashSet classSet = new HashSet();
        private String skipPbdLocation = null;
        private Exception CannotCreateFileException;
        private static PbdCreator kInstance;

        public void setSuperClassName(String superClass) {
            this.superClassName = superClass;
            if (!this.classSet.add(this.superClassName)) {
                ++this.classCounter;
            }
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public void setSkipClassName(String skipClass) {
            this.skipClassName = skipClass;
        }

        public String getSkipClassName() {
            return this.skipClassName;
        }

        public void setInterfaceNameArray(String interfaceName) {
            this.interfaceNameArray.add(interfaceName);
        }

        public ArrayList getInterfaceNameArray() {
            return this.interfaceNameArray;
        }

        public void setSkipPbdLocation(IAgent agent) {
            this.skipPbdLocation = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.skipjndierror.location", null);
        }

        public String getSkipPbdLocation() {
            return this.skipPbdLocation;
        }

        private PbdCreator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PbdCreator getPbdCreatorInstance() {
            Class<PbdCreator> clazz = PbdCreator.class;
            synchronized (PbdCreator.class) {
                if (kInstance == null) {
                    kInstance = new PbdCreator();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return kInstance;
            }
        }

        synchronized void dumpClassInfo(IAgent agent, InvocationData data) {
            block17: {
                if (fPbdCreator != null) {
                    fPbdCreator.setSkipPbdLocation(agent);
                }
                Module kModule = new Module("EJBPROBLEM");
                IModuleFeedbackChannel fFeedback = agent.IAgent_getModuleFeedback();
                Object obj = data.getInvocationObject();
                Class<?> className = data.getInvocationObject().getClass();
                ClassLoader cl = className.getClassLoader();
                String cName = className.getName();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(cName, false, cl);
                    if (clazz != null) {
                        fFeedback.debug("clazz is " + clazz.getName());
                    } else {
                        if (cl != null) {
                            fFeedback.debug("clazz is null and cannot be loaded by " + cl.toString());
                        }
                        clazz = Class.forName(cName, false, cl.getParent());
                    }
                    if (clazz == null) {
                        if (cl != null && cl.getParent() != null) {
                            fFeedback.debug("clazz is still null and cannot be loaded by " + cl.getParent().toString());
                        }
                        clazz = Class.forName(cName, false, ClassLoader.getSystemClassLoader());
                    }
                    if (clazz == null) {
                        fFeedback.debug("clazz is still null and cannot be loaded by the System CL either: " + ClassLoader.getSystemClassLoader().toString());
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    fFeedback.error(e);
                }
                catch (Throwable t) {
                    fFeedback.error(t);
                }
                if (obj != null && clazz != null) {
                    Class<?>[] interfaces;
                    if (fFeedback.isDebugEnabled(kModule)) {
                        fFeedback.debug(kModule, this.getClass().getName() + ": Preparing cross process space for " + className + "(" + clazz.getName() + ")");
                    }
                    if ((interfaces = clazz.getInterfaces()) != null && interfaces.length > 0) {
                        for (int i = 0; i < interfaces.length; ++i) {
                            String interfaceName = interfaces[i].getClass().getName();
                            fFeedback.debug(kModule, "Implements: " + interfaceName);
                            fPbdCreator.setInterfaceNameArray(interfaceName);
                        }
                    }
                    fPbdCreator.setSkipClassName(clazz.getName());
                    Class<?> superClass = clazz.getSuperclass();
                    if (superClass != null) {
                        fFeedback.debug(kModule, "Extends: " + superClass.getName());
                        fPbdCreator.setSuperClassName(superClass.getName());
                    }
                }
                try {
                    fPbdCreator.execute();
                }
                catch (Exception CannotCreateFile) {
                    fFeedback.warn("Unable to create jndierrorskip.pbd, turn on DEBUG for more details");
                    if (!fFeedback.isDebugEnabled()) break block17;
                    fFeedback.debug(CannotCreateFile);
                }
            }
        }

        public void execute() throws Exception {
            if (this.CannotCreateFileException == null) {
                this.CannotCreateFileException = new Exception("Unable to create jndierrorskip.pbd, turn on DEBUG for more details");
            }
            if (this.superClassName == null && this.skipClassName == null) {
                fFeedback.debug("No [super]classname was set for jndierrorskip.pbd");
                throw this.CannotCreateFileException;
            }
            if (this.skipPbdLocation == null) {
                fFeedback.info("Skip jndi error pbd location not set in agent profile. Will not create jndierrorskip.pbd.");
                throw this.CannotCreateFileException;
            }
            this.path = this.addPathSeparatorAndAppend(this.skipPbdLocation);
            if (this.path == null || this.path.equals("")) {
                throw this.CannotCreateFileException;
            }
            File file = new File(this.path);
            if (!this.createFile(file)) {
                fFeedback.info("Unable to create jndierrorskip.pbd. Please make sure path is correct.");
                file.delete();
                throw this.CannotCreateFileException;
            }
            this.writeToFile(file);
        }

        private String addPathSeparatorAndAppend(String location) {
            if (location.indexOf("\\\\") != -1) {
                location.replaceAll("\\\\", File.separator);
                return location + File.separator + "jndierrorskip.pbd";
            }
            location.replaceAll("//", File.separator);
            return location + File.separator + "jndierrorskip.pbd";
        }

        private boolean createFile(File file) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                return true;
            }
            catch (IOException ioe) {
                fFeedback.error(ioe);
                return false;
            }
            catch (SecurityException se) {
                fFeedback.error(se);
                return false;
            }
        }

        private void writeToFile(File file) {
            if (this.classCounter >= 5) {
                this.printSkipClassDirectives(file, this.superClassName);
                for (int i = 0; i < this.interfaceNameArray.size(); ++i) {
                    this.printSkipClassDirectives(file, (String)this.interfaceNameArray.get(i));
                }
            } else {
                this.printSkipClassDirectives(file, this.skipClassName);
            }
        }

        private void printSkipClassDirectives(File file, String classOrInterfaceName) {
            try {
                String ibmSystemEncoding = null;
                String platform_ebcdic = System.getProperty("platform.notASCII");
                if (platform_ebcdic != null && platform_ebcdic.equals("true")) {
                    ibmSystemEncoding = System.getProperty("ibm.system.encoding");
                }
                OutputStreamWriter fw = ibmSystemEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), ibmSystemEncoding) : new OutputStreamWriter(new FileOutputStream(file, true));
                BufferedWriter bw = new BufferedWriter(fw);
                if (file.length() != 0L) {
                    bw.newLine();
                }
                if (this.classCounter < 5) {
                    String skipClass = "SkipClass: " + classOrInterfaceName;
                    bw.write(skipClass);
                    bw.newLine();
                } else {
                    String skipClass = "SkipClass: " + classOrInterfaceName;
                    bw.write(skipClass);
                    bw.newLine();
                    String skipIfInheritedFromClassForFlag = "SkipIfInheritedForFlag: " + classOrInterfaceName + " EJB2StubTracing";
                    bw.write(skipIfInheritedFromClassForFlag);
                    bw.newLine();
                    String skipIfInheritedFromClassForFlag2 = "SkipIfInheritedForFlag: " + classOrInterfaceName + " EJB3StubTracing";
                    bw.write(skipIfInheritedFromClassForFlag2);
                    bw.newLine();
                }
                bw.flush();
                bw.close();
            }
            catch (IOException e) {
                fFeedback.error(e);
            }
        }
    }
}

