/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelPerIntervalCounter;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public final class DatagramPerIntervalCounter
extends ChannelPerIntervalCounter
implements ITracer {
    public DatagramPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof DatagramChannel) {
            DatagramChannel channel = (DatagramChannel)invocationObject;
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
            if (DatagramChannelMap.isRequired(channel, remoteAddress, this.getAgent())) {
                return this;
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a DatagramChannel");
        }
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName = this.formatParameterizedName(data);
        if (formattedName != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }
}

