/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.util.parameter.CheckParameter;
import java.io.OutputStream;

public class TransportConfiguration {
    public static final boolean kDefaultUseOswegoConcurrencyLibrary = false;
    public static final boolean kDefaultIsNioEnabled = true;
    public static final int kDefaultMaxNumInputBuffer = 600;
    public static final int kDefaultMaxNumInputBufferNio = 4000;
    public static final boolean kDefaultUseDirectBuffers = false;
    public static final int kDefaultNumDispatchers = 1;
    public static final int kDefaultOutgoingMessageQueueSize = 6000;
    public static final int kDefaultIncomingMessageQueueSize = 100;
    public static final int kDefaultSocketTimeout = 120000;
    public static final boolean kDefaultIsHttpTunnelingServerEnabled = true;
    public static final int kDefaultHttpTunnelingServerPort = 8081;
    public static final boolean kDefaultIsHighConcurrencyTransportEnabled = true;
    public static final boolean kDefaultSlowClientTolerance = true;
    public static final long kDefaultSlowClientTimeLimit = 60000L;
    public static final long kDefaultSlowClientTimePeriod = 120000L;
    public static final int kDefaultHighConcurrencyTransportPoolMaxSize = 10;
    public static final int kDefaultHighConcurrencyTransportPoolMinSize = 10;
    public static final int kDefaultHighConcurrencyTransportPoolQueueSize = 100;
    public static final int kDefaultHighConcurrencyTransportPoolKeepAlive = 60000;
    public static final int kDefaultIsengardClientPOThreadPoolSize = 3;
    public static final boolean kTransportShouldUseOrderedExecutor = false;
    private int fOutgoingMessageQueueSize;
    private int fIncomingMessageQueueSize;
    private final boolean fIsHttpTunnelingServerEnabled;
    private final boolean fIsHighConcurrencyTransportEnabled;
    private final boolean fUseOswegoConcurrencyLibrary;
    private final boolean fIsNioEnabled;
    private final int fBufferMaxNum;
    private final int fBufferMaxNumNio;
    private final boolean fUseDirectBuffers;
    private final int fNumDispatchers;
    private int fHttpTunnelingServerPort;
    private int fHighConcurrencyTransportPoolMaxSize;
    private int fHighConcurrencyTransportPoolMinSize;
    private int fHighConcurrencyTransportPoolQueueSize;
    private int fHighConcurrencyTransportPoolKeepAlive;
    private int fSerializationMode;
    private int fSocketTimeout;
    private int fIsengardClientPOThreadPoolSize = 3;
    private boolean fTransportShouldUseOrderedExecutor;
    private boolean fSlowClientTolerance = true;
    private long fSlowClientTimeLimit = 60000L;
    private long fSlowClientTimePeriod = 120000L;
    private OutputStream fCaptureLogStream = null;
    private long fCaptureLogLimit = 10000L;

    public TransportConfiguration() {
        this(6000, 100, true, true, false, true, false, 1);
    }

    public TransportConfiguration(int outgoingMessageQueueSize, int incomingMessageQueueSize, boolean isHttpTunnelingServerEnabled, boolean isHighConcurrencyTransportEnabled) {
        this(outgoingMessageQueueSize, incomingMessageQueueSize, isHttpTunnelingServerEnabled, isHighConcurrencyTransportEnabled, false, true, false, 1);
    }

    public TransportConfiguration(int outgoingMessageQueueSize, int incomingMessageQueueSize, boolean isHttpTunnelingServerEnabled, boolean isHighConcurrencyTransportEnabled, boolean isUseOswegoConcurrencyLibrary, boolean isNioEnabled, boolean useDirectBuffers, int numDispatchers) {
        this(outgoingMessageQueueSize, incomingMessageQueueSize, isHttpTunnelingServerEnabled, isHighConcurrencyTransportEnabled, false, true, 600, 4000, false, 1);
    }

    public TransportConfiguration(int outgoingMessageQueueSize, int incomingMessageQueueSize, boolean isHttpTunnelingServerEnabled, boolean isHighConcurrencyTransportEnabled, boolean isUseOswegoConcurrencyLibrary, boolean isNioEnabled, int bufferMaxNum, int bufferMaxNumNio, boolean useDirectBuffers, int numDispatchers) {
        CheckParameter.isPositive("Outgoing Message Queue Size", outgoingMessageQueueSize);
        CheckParameter.isPositive("Incoming Message Queue Size", incomingMessageQueueSize);
        this.fOutgoingMessageQueueSize = outgoingMessageQueueSize;
        this.fIncomingMessageQueueSize = incomingMessageQueueSize;
        this.fIsHttpTunnelingServerEnabled = isHttpTunnelingServerEnabled;
        this.fSerializationMode = 48;
        this.fIsHighConcurrencyTransportEnabled = isHighConcurrencyTransportEnabled;
        this.fUseOswegoConcurrencyLibrary = isUseOswegoConcurrencyLibrary;
        this.fIsNioEnabled = isNioEnabled;
        this.fBufferMaxNum = bufferMaxNum;
        this.fBufferMaxNumNio = bufferMaxNumNio;
        this.fUseDirectBuffers = useDirectBuffers;
        this.fNumDispatchers = numDispatchers;
        this.fSocketTimeout = 120000;
        this.initializeHttpTunnelingServerPort(isHttpTunnelingServerEnabled);
        this.initializeHighConcurrencyTransportPool(isHighConcurrencyTransportEnabled);
    }

    public int getOutgoingMessageQueueSize() {
        return this.fOutgoingMessageQueueSize;
    }

    public void setOutgoingMessageQueueSize(int size) {
        this.fOutgoingMessageQueueSize = size;
    }

    public int getSocketTimeout() {
        return this.fSocketTimeout;
    }

    public int getIncomingMessageQueueSize() {
        return this.fIncomingMessageQueueSize;
    }

    public void setIncomingMessageQueueSize(int size) {
        this.fIncomingMessageQueueSize = size;
    }

    public boolean isHighConcurrencyTransportEnabled() {
        return this.fIsHighConcurrencyTransportEnabled;
    }

    public void setHighConcurrencyTransportPoolMaxSize(int size) {
        CheckParameter.isPositive("Thread Pool Max Size", size);
        if (!this.isHighConcurrencyTransportEnabled()) {
            throw new IllegalStateException("High concurrency transport must be enabled to set the thread pool max size to: " + size);
        }
        this.fHighConcurrencyTransportPoolMaxSize = size;
    }

    public int getHighConcurrencyTransportPoolMaxSize() {
        return this.fHighConcurrencyTransportPoolMaxSize;
    }

    public void setHighConcurrencyTransportPoolMinSize(int size) {
        CheckParameter.notNegative("Thread Pool Min Size", size);
        if (!this.isHighConcurrencyTransportEnabled()) {
            throw new IllegalStateException("High concurrency transport must be enabled to set the thread pool min size to: " + size);
        }
        this.fHighConcurrencyTransportPoolMinSize = size;
    }

    public int getHighConcurrencyTransportPoolMinSize() {
        return this.fHighConcurrencyTransportPoolMinSize;
    }

    public void setHighConcurrencyTransportPoolQueueSize(int size) {
        CheckParameter.notNegative("Thread Pool Queue Size", size);
        if (!this.isHighConcurrencyTransportEnabled()) {
            throw new IllegalStateException("High concurrency transport must be enabled to set the thread pool queue size to: " + size);
        }
        this.fHighConcurrencyTransportPoolQueueSize = size;
    }

    public int getHighConcurrencyTransportPoolQueueSize() {
        return this.fHighConcurrencyTransportPoolQueueSize;
    }

    public void setHighConcurrencyTransportPoolKeepAlive(int keepAlive) {
        if (!this.isHighConcurrencyTransportEnabled()) {
            throw new IllegalStateException("High concurrency transport must be enabled to set the thread keep alive time to: " + keepAlive);
        }
        this.fHighConcurrencyTransportPoolKeepAlive = keepAlive;
    }

    public int getHighConcurrencyTransportPoolKeepAlive() {
        return this.fHighConcurrencyTransportPoolKeepAlive;
    }

    public boolean isHttpTunnelingServerEnabled() {
        return this.fIsHttpTunnelingServerEnabled;
    }

    public boolean isUseOswegoConcurrencyLibrary() {
        return this.fUseOswegoConcurrencyLibrary;
    }

    public boolean isNioEnabled() {
        return this.fIsNioEnabled;
    }

    public int getBufferMaxNum() {
        return this.fBufferMaxNum;
    }

    public int getBufferMaxNumNio() {
        return this.fBufferMaxNumNio;
    }

    public boolean useDirectBuffers() {
        return this.fUseDirectBuffers;
    }

    public int getNumDispatchers() {
        return this.fNumDispatchers;
    }

    public void setHttpTunnelingServerPort(int port) {
        if (!this.isHttpTunnelingServerEnabled()) {
            throw new IllegalStateException("Http tunneling server must be enabled to set the port to: " + port);
        }
        this.checkPortRange(port);
        this.fHttpTunnelingServerPort = port;
    }

    public int getHttpTunnelingServerPort() {
        return this.fHttpTunnelingServerPort;
    }

    public void setSerializationMode(int mode) {
        this.fSerializationMode = mode;
    }

    public int getSerializationMode() {
        return this.fSerializationMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransportConfiguration)) {
            return false;
        }
        TransportConfiguration compareTo = (TransportConfiguration)o;
        return this.getOutgoingMessageQueueSize() == compareTo.getOutgoingMessageQueueSize() && this.getIncomingMessageQueueSize() == compareTo.getIncomingMessageQueueSize() && this.getSerializationMode() == compareTo.getSerializationMode() && this.isHttpTunnelingServerEnabled() == compareTo.isHttpTunnelingServerEnabled() && this.getHttpTunnelingServerPort() == compareTo.getHttpTunnelingServerPort() && this.isHighConcurrencyTransportEnabled() == compareTo.isHighConcurrencyTransportEnabled() && this.getHighConcurrencyTransportPoolMaxSize() == compareTo.getHighConcurrencyTransportPoolMaxSize() && this.getHighConcurrencyTransportPoolMinSize() == compareTo.getHighConcurrencyTransportPoolMinSize() && this.getHighConcurrencyTransportPoolQueueSize() == compareTo.getHighConcurrencyTransportPoolQueueSize() && this.getHighConcurrencyTransportPoolKeepAlive() == compareTo.getHighConcurrencyTransportPoolKeepAlive() && this.getIsengardClientPOThreadPoolSize() == compareTo.getIsengardClientPOThreadPoolSize();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getOutgoingMessageQueueSize();
        result = 37 * result + this.getIncomingMessageQueueSize();
        result = 37 * result + this.getSerializationMode();
        result = 37 * result + (this.isHttpTunnelingServerEnabled() ? 0 : 1);
        result = 37 * result + this.getHttpTunnelingServerPort();
        result = 37 * result + (this.isHighConcurrencyTransportEnabled() ? 0 : 1);
        result = 37 * result + this.getHighConcurrencyTransportPoolMaxSize();
        result = 37 * result + this.getHighConcurrencyTransportPoolMinSize();
        result = 37 * result + this.getHighConcurrencyTransportPoolQueueSize();
        result = 37 * result + this.getHighConcurrencyTransportPoolKeepAlive();
        result = 37 * result + this.getIsengardClientPOThreadPoolSize();
        return result;
    }

    private void checkPortRange(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
    }

    private void initializeHttpTunnelingServerPort(boolean isHttpTunnelingServerEnabled) {
        this.fHttpTunnelingServerPort = isHttpTunnelingServerEnabled ? 8081 : -1;
    }

    private void initializeHighConcurrencyTransportPool(boolean isHighConcurrencyTransportEnabled) {
        if (isHighConcurrencyTransportEnabled) {
            this.fHighConcurrencyTransportPoolMaxSize = 10;
            this.fHighConcurrencyTransportPoolMinSize = 10;
            this.fHighConcurrencyTransportPoolQueueSize = 100;
            this.fHighConcurrencyTransportPoolKeepAlive = 60000;
        } else {
            this.fHighConcurrencyTransportPoolMaxSize = -1;
            this.fHighConcurrencyTransportPoolMinSize = -1;
            this.fHighConcurrencyTransportPoolQueueSize = -1;
            this.fHighConcurrencyTransportPoolKeepAlive = -1;
        }
    }

    public static TransportConfiguration getDefaultClientConfiguration() {
        return new TransportConfiguration(6000, 100, false, false);
    }

    public static TransportConfiguration getDefaultServerConfiguration() {
        return new TransportConfiguration(6000, 100, true, true);
    }

    public static TransportConfiguration getDefaultServerConfigurationNoHttpTunneling() {
        return new TransportConfiguration(6000, 100, false, true);
    }

    public void setIsengardClientPOThreadPoolSize(int fIsengardClientPOThreadPoolSize) {
        this.fIsengardClientPOThreadPoolSize = fIsengardClientPOThreadPoolSize;
    }

    public int getIsengardClientPOThreadPoolSize() {
        return this.fIsengardClientPOThreadPoolSize;
    }

    public static int getDefualtIsengardClientPOThreadPoolSize() {
        return 3;
    }

    public void setTransportShouldUseOrderedExecutor(boolean fTransportShouldUseOrderedExecutor) {
        this.fTransportShouldUseOrderedExecutor = fTransportShouldUseOrderedExecutor;
    }

    public boolean transportShouldUseOrderedExecutor() {
        return this.fTransportShouldUseOrderedExecutor;
    }

    public void setSlowClientTolerance(boolean tolerance) {
        this.fSlowClientTolerance = tolerance;
    }

    public boolean isClientTolerant() {
        return this.fSlowClientTolerance;
    }

    public void setSlowClientTimeLimit(long timeLimit) {
        this.fSlowClientTimeLimit = timeLimit;
    }

    public long getSlowClientTimeLimit() {
        return this.fSlowClientTimeLimit;
    }

    public void setSlowClientTimePeriod(long timePeriod) {
        this.fSlowClientTimePeriod = timePeriod;
    }

    public long getSlowClientTimePeriod() {
        return this.fSlowClientTimePeriod;
    }

    public OutputStream getCaptureLogStream() {
        return this.fCaptureLogStream;
    }

    public void setCaptureLogStream(OutputStream stream) {
        this.fCaptureLogStream = stream;
    }

    public long getCaptureLogLimit() {
        return this.fCaptureLogLimit;
    }

    public void setCaptureLogLimit(long limit) {
        this.fCaptureLogLimit = limit;
    }
}

