/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class WeakWeakObjectMapCache {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 0.75f;
    private static final int kSmall = 8;
    private static final int kMedium = 32;
    private static final int kLarge = 64;
    private final ReferenceQueue[] fReferenceQueue;
    private Entry[][] fTable;
    private int[] fCount;
    private int fBitMask;
    private int fArraySize;
    private boolean fUseIdentity;
    private ThreadLocal tLocal;

    public WeakWeakObjectMapCache() {
        this(11, 32, false, true);
    }

    public WeakWeakObjectMapCache(boolean useIdentity) {
        this(11, 32, useIdentity, true);
    }

    public static WeakWeakObjectMapCache getSmallMap(boolean useIdentity) {
        return new WeakWeakObjectMapCache(11, 8, useIdentity, true);
    }

    public static WeakWeakObjectMapCache getMediumMap(boolean useIdentity) {
        return new WeakWeakObjectMapCache(11, 32, useIdentity, true);
    }

    public static WeakWeakObjectMapCache getLargeMap(boolean useIdentity) {
        return new WeakWeakObjectMapCache(11, 64, useIdentity, true);
    }

    public WeakWeakObjectMapCache(int initialCapacity, int arraySize, boolean useIdentity) {
        this(initialCapacity, arraySize, useIdentity, true);
    }

    public WeakWeakObjectMapCache(int initialCapacity, int arraySize) {
        this(initialCapacity, arraySize, false, true);
    }

    private WeakWeakObjectMapCache(int initialCapacity, int arraySize, boolean useIdentity, boolean useThreadLocal) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fArraySize = arraySize;
        this.fBitMask = arraySize - 1;
        this.fUseIdentity = useIdentity;
        this.fReferenceQueue = new ReferenceQueue[arraySize];
        this.fTable = new Entry[arraySize][];
        this.fCount = new int[arraySize];
        if (useThreadLocal) {
            this.tLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new WeakWeakObjectMapCache(11, 1, false);
                }
            };
        }
        int i = 0;
        while (i < arraySize) {
            this.fReferenceQueue[i] = new ReferenceQueue();
            this.fTable[i] = new Entry[initialCapacity];
            this.fCount[i] = 0;
            ++i;
        }
    }

    public int size() {
        int sz = 0;
        int i = 0;
        while (i < this.fArraySize) {
            this.purge(i);
            sz += this.fCount[i];
            ++i;
        }
        return sz;
    }

    private int getIndex(int hashCode) {
        return hashCode & this.fBitMask;
    }

    private WeakWeakObjectMapCache getChildCache() {
        WeakWeakObjectMapCache result = null;
        if (this.tLocal != null) {
            result = (WeakWeakObjectMapCache)this.tLocal.get();
        }
        return result;
    }

    private int getHash(Object key) {
        if (this.fUseIdentity) {
            return System.identityHashCode(key);
        }
        return key.hashCode();
    }

    public Object get(Object key) {
        int hashCode = this.getHash(key);
        Object result = null;
        Object tLocalResult = null;
        WeakWeakObjectMapCache childCache = null;
        if (this.tLocal != null) {
            childCache = this.getChildCache();
            tLocalResult = childCache.get(key, hashCode, false);
        }
        if ((result = tLocalResult == null ? this.get(key, hashCode, true) : tLocalResult) != null && this.tLocal != null && tLocalResult == null) {
            childCache.put(key, result, hashCode, false);
        }
        return result;
    }

    private Object get(Object key, int hashCode, boolean sync) {
        Object result = null;
        int mapIndex = this.getIndex(hashCode);
        result = sync ? this.getSync(key, mapIndex, hashCode) : this.getInternal(key, mapIndex, hashCode);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSync(Object key, int mapIndex, int hashCode) {
        Object result = null;
        Entry[] entryArray = this.fTable[mapIndex];
        synchronized (entryArray) {
            result = this.getInternal(key, mapIndex, hashCode);
        }
        return result;
    }

    private Object getInternal(Object key, int mapIndex, int hashCode) {
        this.purge(mapIndex);
        if (key == null) {
            throw new NullPointerException();
        }
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable[mapIndex].length;
        Entry e = this.fTable[mapIndex][index];
        Entry previous = null;
        while (e != null) {
            if (e.keyEquals(key)) {
                Object result = e.fValue.get();
                if (result == null) {
                    if (previous == null) {
                        this.fTable[mapIndex][index] = e.fNext;
                    } else {
                        previous.fNext = e.fNext;
                    }
                    int n = mapIndex;
                    this.fCount[n] = this.fCount[n] - 1;
                }
                return result;
            }
            previous = e;
            e = e.fNext;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int hashCode = this.getHash(key);
        if (this.tLocal != null) {
            WeakWeakObjectMapCache childCache = this.getChildCache();
            childCache.put(key, value, hashCode, false);
        }
        return this.put(key, value, hashCode, true);
    }

    private Object put(Object key, Object value, int hashCode, boolean sync) {
        int mapIndex = this.getIndex(hashCode);
        if (sync) {
            return this.putSync(key, value, mapIndex, hashCode);
        }
        return this.putInternal(key, value, mapIndex, hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object putSync(Object key, Object value, int index, int hashCode) {
        Object result = null;
        Entry[] entryArray = this.fTable[index];
        synchronized (entryArray) {
            result = this.putInternal(key, value, index, hashCode);
        }
        return result;
    }

    private Object putInternal(Object key, Object value, int mapIndex, int hashCode) {
        Entry newEntry;
        this.purge(mapIndex);
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable[mapIndex].length;
        Entry e = this.fTable[mapIndex][index];
        while (e != null) {
            if (e.keyEquals(key)) {
                Object result = e.fValue.get();
                e.fValue = new WeakReference<Object>(value);
                return result;
            }
            e = e.fNext;
        }
        this.fTable[mapIndex][index] = newEntry = new Entry(hashCode, key, value, this.fTable[mapIndex][index], this.fReferenceQueue[mapIndex]);
        int n = mapIndex;
        this.fCount[n] = this.fCount[n] + 1;
        if ((float)this.fCount[mapIndex] > (float)this.fTable[mapIndex].length * 0.75f) {
            this.rehash(mapIndex);
        }
        return null;
    }

    public Set keySet() {
        HashSet result = new HashSet();
        int i = 0;
        while (i < this.fArraySize) {
            this.purge(i);
            Entry e = null;
            int index = 0;
            while (index < this.fTable[i].length) {
                e = this.fTable[i][index];
                while (e != null) {
                    Object o = e.get();
                    if (o != null) {
                        result.add(o);
                    }
                    e = e.fNext;
                }
                ++index;
            }
            ++i;
        }
        return result;
    }

    public Collection values() {
        ArrayList<WeakReference> result = new ArrayList<WeakReference>(this.fArraySize * 3);
        int i = 0;
        while (i < this.fArraySize) {
            this.purge(i);
            Entry e = null;
            int index = 0;
            while (index < this.fTable[i].length) {
                e = this.fTable[i][index];
                while (e != null) {
                    result.add(e.fValue);
                    e = e.fNext;
                }
                ++index;
            }
            ++i;
        }
        return result;
    }

    private void rehash(int mapIndex) {
        Entry[] newTable = new Entry[this.fTable[mapIndex].length * 2 + 1];
        int i = 0;
        while (i < this.fTable[mapIndex].length) {
            Entry e = this.fTable[mapIndex][i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.hashCode() & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable[mapIndex] = newTable;
    }

    public Object remove(Object key) {
        int hashCode = this.getHash(key);
        if (this.tLocal != null) {
            WeakWeakObjectMapCache childCache = this.getChildCache();
            childCache.remove(key, hashCode, false);
        }
        return this.remove(key, hashCode, true);
    }

    private Object remove(Object key, int hashCode, boolean sync) {
        Object result = null;
        int mapIndex = this.getIndex(hashCode);
        result = sync ? this.removeSync(key, mapIndex, hashCode) : this.removeInternal(key, mapIndex, hashCode);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeSync(Object key, int mapIndex, int hashCode) {
        Object result = null;
        Entry[] entryArray = this.fTable[mapIndex];
        synchronized (entryArray) {
            result = this.removeInternal(key, mapIndex, hashCode);
        }
        return result;
    }

    private Object removeInternal(Object key, int mapIndex, int hashCode) {
        this.purge(mapIndex);
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable[mapIndex].length;
        Entry previous = null;
        Entry e = this.fTable[mapIndex][index];
        while (e != null) {
            if (e.keyEquals(key)) {
                if (previous == null) {
                    this.fTable[mapIndex][index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                int n = mapIndex;
                this.fCount[n] = this.fCount[n] - 1;
                return e.fValue.get();
            }
            previous = e;
            e = e.fNext;
        }
        return null;
    }

    private void purge(int mapIndex) {
        Entry entry = (Entry)this.fReferenceQueue[mapIndex].poll();
        while (entry != null) {
            this.purge(entry, mapIndex);
            entry = (Entry)this.fReferenceQueue[mapIndex].poll();
        }
    }

    private void purge(Entry entry, int mapIndex) {
        int hashCode = entry.hashCode();
        int index = (hashCode & Integer.MAX_VALUE) % this.fTable[mapIndex].length;
        Entry previous = null;
        Entry e = this.fTable[mapIndex][index];
        while (e != null) {
            if (e == entry) {
                if (previous == null) {
                    this.fTable[mapIndex][index] = e.fNext;
                } else {
                    previous.fNext = e.fNext;
                }
                int n = mapIndex;
                this.fCount[n] = this.fCount[n] - 1;
                return;
            }
            previous = e;
            e = e.fNext;
        }
    }

    private static final class Entry
    extends WeakReference {
        private final int fHashCode;
        WeakReference fValue;
        Entry fNext;

        Entry(int hashCode, Object key, Object value, Entry next, ReferenceQueue queue) {
            super(key, queue);
            this.fHashCode = hashCode;
            this.fValue = new WeakReference<Object>(value);
            this.fNext = next;
        }

        public int hashCode() {
            return this.fHashCode;
        }

        boolean keyEquals(Object key) {
            return this.get() == key;
        }
    }
}

