/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.texthelp;

import com.wily.util.StringUtils;
import com.wily.util.texthelp.IHelpProviderListSupplier;
import com.wily.util.texthelp.ISingleCommandHelpProvider;
import java.io.PrintWriter;

public class TextualHelpProvider {
    private static final String kIndentationString = "  ";
    private static final int kDefaultNameLength = 25;
    private static final int kDefaultLineLength = 79;
    private final IHelpProviderListSupplier fListSupplier;
    private final int fNameLength;
    private final int fLineLength;

    public TextualHelpProvider(IHelpProviderListSupplier listSupplier, int nameColumnWidth) {
        this.fListSupplier = listSupplier;
        this.fNameLength = nameColumnWidth;
        this.fLineLength = 79;
    }

    public TextualHelpProvider(IHelpProviderListSupplier listSupplier) {
        this(listSupplier, 25);
    }

    public void printHelp(PrintWriter outputChannel) {
        ISingleCommandHelpProvider[] providers = this.fListSupplier.ICommandListSupplier_getHelpProviders();
        int i = 0;
        while (i < providers.length) {
            this.printSingleHelp(outputChannel, providers[i]);
            ++i;
        }
    }

    private void printSingleHelp(PrintWriter outputChannel, ISingleCommandHelpProvider provider) {
        if (!provider.ISingleCommandHelpProvider_shouldSuppress()) {
            int length = this.printCommands(outputChannel, provider);
            if (length < this.fNameLength) {
                outputChannel.print(this.padString("", this.fNameLength - length));
            } else {
                outputChannel.println();
                outputChannel.print(this.padString("", this.fNameLength));
            }
            this.printHelpText(outputChannel, provider);
            outputChannel.println();
        }
    }

    private int printCommands(PrintWriter outputChannel, ISingleCommandHelpProvider provider) {
        String[] names = provider.ISingleCommandHelpProvider_getCommands();
        String argHelp = provider.ISingleCommandHelpProvider_getArgumentPrompt();
        outputChannel.print(kIndentationString);
        int length = kIndentationString.length();
        length += this.printList(outputChannel, names);
        if (argHelp != null) {
            outputChannel.print(" ");
            ++length;
            outputChannel.print(argHelp);
            length += argHelp.length();
        }
        return length;
    }

    public void printHelpText(PrintWriter outputChannel, ISingleCommandHelpProvider provider) {
        if (!provider.ISingleCommandHelpProvider_shouldSuppress()) {
            String helpText = provider.ISingleCommandHelpProvider_getHelpText();
            if (helpText == null) {
                return;
            }
            String[] wrappedText = StringUtils.wordWrap(helpText, this.fLineLength - this.fNameLength);
            int i = 0;
            while (i < wrappedText.length) {
                if (i > 0) {
                    outputChannel.println();
                    outputChannel.print(this.padString("", this.fNameLength));
                }
                outputChannel.print(wrappedText[i]);
                ++i;
            }
        }
    }

    private String padString(String source, int length) {
        int start;
        StringBuilder buffer = new StringBuilder(length);
        buffer.append(source);
        int i = start = source == null ? 0 : source.length();
        while (i < length) {
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    private int printList(PrintWriter output, String[] list) {
        int length = 0;
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i] != null) {
                    output.print(" ");
                    ++length;
                    output.print(list[i]);
                    length += list[i].length();
                }
                ++i;
            }
        }
        return length;
    }
}

