/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.properties.AttributeListing;

public class JaxWsFaultTracer
extends ASingleInstanceTracerFactory {
    public JaxWsFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        WSMUtils.getLogger().debug("START:JaxWsFaultTracer.ITracer_finishTrace()");
        try {
            String component = this.formatParameterizedName(data);
            Object objPacket = data.getInvocationReturnValueAsObject();
            Object msg = WSMUtils.invokeMethodOnObject(objPacket, "getMessage");
            boolean isFault = (Boolean)WSMUtils.invokeMethodOnObject(msg, "isFault");
            if (isFault) {
                WSMUtils.getLogger().debug("Has FAULT:" + component);
                ILongIntervalCounterDataAccumulator accumErrorCnt = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(component);
                accumErrorCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
        catch (Exception e) {
            WSMUtils.getLogger().info("JAXWSFaultTracer Error " + WSMUtils.dumpStackTrace(e));
        }
        WSMUtils.getLogger().debug("END:JaxWsFaultTracer.ITracer_finishTrace()");
    }

    public void ITracer_startTrace(int arg0, InvocationData arg1) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

