/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.AWSTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.resource.IResource;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class SAPClientDeploymentTracer
extends AWSTracer {
    private IAgent agent = null;
    private IModuleFeedbackChannel logger = null;
    private String agentHome = null;

    public SAPClientDeploymentTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.agentHome = this.getAbsoluteAgentPath();
    }

    private String getAbsoluteAgentPath() {
        try {
            IResource profileResource = this.agent.IAgent_getConfigurationResource();
            if (profileResource.IResource_isFileResource()) {
                File profileDirectory = new File(profileResource.IResource_getLocation()).getParentFile();
                File pathFile = new File(profileDirectory, this.agentHome);
                this.agentHome = pathFile.getAbsolutePath();
            }
        }
        catch (Exception e) {
            this.agentHome = "wily";
        }
        return this.agentHome;
    }

    public void ITracer_startTrace(int index, InvocationData invocationData) {
        try {
            ClassLoader parent = null;
            Object wsContainer = invocationData.getInvocationObject();
            if (wsContainer != null) {
                parent = invocationData.getInvocationObject().getClass().getClassLoader();
                Class<?> resourceClass = Class.forName("com.sap.engine.frame.core.load.res.Resource", true, invocationData.getInvocationObject().getClass().getClassLoader());
                Class<?> jarResourceClass = Class.forName("com.sap.engine.frame.core.load.res.JarResource", true, invocationData.getInvocationObject().getClass().getClassLoader());
                Constructor<?> jarResourceConstr = jarResourceClass.getDeclaredConstructor(String.class);
                Method method = invocationData.getInvocationObject().getClass().getClassLoader().getClass().getSuperclass().getDeclaredMethod("addResource", resourceClass);
                method.invoke((Object)parent, jarResourceConstr.newInstance(this.agentHome + File.separator + WSMUtils.getExtensionDirectory() + File.separator + "WebServicesAgent.jar"));
                this.logger.debug("Added JarResource(WSM ClientHandler) to the classloader of WebserviceRuntime ");
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
        }
    }

    public void ITracer_finishTrace(int index, InvocationData invocationData) {
    }
}

