/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.substituteresult.websphere;

import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.WSDMHandlerInstantiationException;
import com.wily.powerpack.webservices.handlers.websphere.WsdmWebSphereHandler;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;

public class WASModifyHandler {
    private static ThreadLocal Cache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };
    private static final String kWSClientHandlerChain = "com.wily.powerpack.webservices.WASClientHandlerChain";
    private static final String kWSServerHandlerChain = "com.wily.powerpack.webservices.WASServerHandlerChain";

    public static void set(Object key, Object value) {
        WASModifyHandler.get().put(key, value);
    }

    public static Object get(Object key) {
        return WASModifyHandler.get().get(key);
    }

    private static Map get() {
        return (Map)Cache.get();
    }

    public static void clear() {
        WASModifyHandler.get().clear();
    }

    public static void remove(Object key) {
        WASModifyHandler.get().remove(key);
    }

    public static ExtendedHandlerInfo getClientWsdmHandler() {
        return ClientHandlerHolder.wsdmHandler;
    }

    public static ExtendedHandlerInfo getServerWsdmHandler() {
        return ServerHandlerHolder.wsdmHandler;
    }

    public static HandlerChain modifyHandlerChain(HandlerChain handlers) {
        WSMUtils.refreshLogLevels();
        HandlerChain newHandlers = handlers;
        String handlerChain = (String)WASModifyHandler.get("com.wily.powerpack.webservices.WASTargettedChain");
        WSMUtils.getLogger().debug("handerChain " + handlerChain);
        String engineType = (String)WASModifyHandler.get("com.wily.powerpack.webservices.WASEngine");
        WSMUtils.getLogger().debug("engineType " + engineType);
        if (handlerChain != null && handlerChain.equals("com.ibm.ws.webservices.engine.deployment.wsdd.WSDDGlobalConfiguration") && engineType != null) {
            String message;
            try {
                ExtendedHandlerInfo wsdmHandler;
                String message2 = Thread.currentThread() + " [" + WASModifyHandler.class + "::modifyHandler] Modifying handlerChain in handler";
                WSMUtils.getLogger().trace(WSMUtils.getModule(), message2);
                if (engineType.equals("com.ibm.ws.webservices.engine.server.ServerEngine")) {
                    boolean prop = WSMUtils.appendServerHandlerEnabled();
                    message = Thread.currentThread() + " Getting server handlers";
                    WSMUtils.getLogger().debug(message);
                    wsdmHandler = WASModifyHandler.getServerWsdmHandler();
                    if (wsdmHandler != null) {
                        newHandlers = prop ? WASModifyHandler.appendWSDMHandler(handlers, wsdmHandler) : WASModifyHandler.prependWSDMHandler(handlers, wsdmHandler);
                    }
                } else if (engineType.equals("com.ibm.ws.webservices.engine.client.ClientEngine")) {
                    boolean prop = WSMUtils.prependClientHandlerEnabled();
                    message = Thread.currentThread() + " Getting client handlers";
                    WSMUtils.getLogger().debug(message);
                    wsdmHandler = WASModifyHandler.getClientWsdmHandler();
                    if (wsdmHandler != null) {
                        newHandlers = prop ? WASModifyHandler.prependWSDMHandler(handlers, wsdmHandler) : WASModifyHandler.appendWSDMHandler(handlers, wsdmHandler);
                    }
                } else {
                    message2 = Thread.currentThread() + " Detected unsupported WebSphere Mode " + engineType + ", ignoring handlers";
                    WSMUtils.getLogger().debug(message2);
                }
            }
            catch (ThreadDeath bomb) {
                throw bomb;
            }
            catch (Throwable bomb) {
                try {
                    message = Thread.currentThread() + " Caught unexpected exception while modifying handlers, " + bomb + ", using configured handlers";
                    WSMUtils.getLogger().error(message);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                newHandlers = handlers;
            }
        }
        if (WSMUtils.getLogger().isDebugEnabled()) {
            for (int i = 0; i < newHandlers.size(); ++i) {
                if (!(newHandlers.get(i) instanceof ExtendedHandlerInfo)) continue;
                WSMUtils.getLogger().debug("WLS9ModifyHandler modifyHandlerList(" + i + "):" + ((ExtendedHandlerInfo)newHandlers.get(i)).getName());
            }
        }
        return newHandlers;
    }

    private static HandlerChain appendWSDMHandler(HandlerChain handler, ExtendedHandlerInfo wsdmHandler) throws WSDMHandlerInstantiationException {
        String message = Thread.currentThread() + " [::appendWSDMHandler]  Appending WSDM handler to handler chain, size=" + (handler == null ? "null" : Integer.toString(handler.size()));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        if (handler != null) {
            try {
                int position = handler.size();
                handler.add(position, (Object)wsdmHandler);
            }
            catch (JAXRPCException bomb) {
                throw new WSDMHandlerInstantiationException(bomb);
            }
        }
        return handler;
    }

    private static HandlerChain prependWSDMHandler(HandlerChain handler, ExtendedHandlerInfo wsdmHandler) throws WSDMHandlerInstantiationException {
        String message = Thread.currentThread() + " [::appendWSDMHandler]  Appending WSDM handler to handler chain, size=" + (handler == null ? "null" : Integer.toString(handler.size()));
        WSMUtils.getLogger().trace(WSMUtils.getModule(), message);
        if (handler != null) {
            try {
                int position = 0;
                handler.add(position, (Object)wsdmHandler);
            }
            catch (JAXRPCException bomb) {
                throw new WSDMHandlerInstantiationException(bomb);
            }
        }
        return handler;
    }

    public static ExtendedHandlerInfo getWSDMHandler(Hashtable config) {
        ExtendedHandlerInfo wsdmHandler = null;
        try {
            HandlerInfo hi = new HandlerInfo(WsdmWebSphereHandler.class, (Map)config, null);
            wsdmHandler = new ExtendedHandlerInfo(hi);
            wsdmHandler.setName("WsdmWebSphereHandler");
        }
        catch (ThreadDeath bomb) {
            throw bomb;
        }
        catch (Throwable bomb) {
            WSMUtils.getLogger().error("getWSDMHandler " + WSMUtils.dumpStackTrace(bomb));
        }
        return wsdmHandler;
    }

    private static class ServerHandlerHolder {
        public static ExtendedHandlerInfo wsdmHandler = null;

        private ServerHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while creating SOA handler";
            WSMUtils.getLogger().error(message.toString());
        }

        static {
            wsdmHandler = WASModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("1"));
        }
    }

    private static class ClientHandlerHolder {
        public static ExtendedHandlerInfo wsdmHandler = null;

        private ClientHandlerHolder() {
        }

        private static void onError(Exception e) {
            String message = Thread.currentThread() + " Caught unexpected exception while creating SOA handler";
            WSMUtils.getLogger().error(message.toString());
        }

        static {
            wsdmHandler = WASModifyHandler.getWSDMHandler(WSMUtils.getWSDMHandlerConfig("2"));
        }
    }
}

