/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.correlation.custom;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class ApplicationCorrelationIDTracer
extends BlamePointTracer
implements IInvocationDataParameterCallback {
    private static final String DEFAULT_CORRELATION_KEY = "CorApplicationCorrelationId";
    private static final int DEFAULT_ARGUMENT_POSITION = -1;
    private final IModuleFeedbackChannel feedback;
    private final int argumentPosition;
    private final String correlationKey;

    public ApplicationCorrelationIDTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.argumentPosition = this.fetchIntegerParameterSafe(parameters, "argumentPosition", -1);
        this.correlationKey = this.fetchStringParameterSafe(parameters, "correlationKey", DEFAULT_CORRELATION_KEY);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        super.ITracer_startTrace(tracerIndex, data);
        data.setParameterCallback((IInvocationDataParameterCallback)this);
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        try {
            String customId;
            Object correlationObject = this.argumentPosition < 0 ? data.getInvocationReturnValueAsObject() : data.getInvocationParameterAsObject(this.argumentPosition);
            if (correlationObject != null && (customId = correlationObject.toString()) != null) {
                parameters.put(this.correlationKey, customId);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.feedback.error(data.getProbeInformation().getProbeIdentification() + " did not contain argument at position " + this.argumentPosition, (Throwable)e);
        }
        catch (Exception e) {
            this.feedback.error(" Unexpected Error in tracer " + ApplicationCorrelationIDTracer.class.getSimpleName(), (Throwable)e);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    private String fetchStringParameterSafe(AttributeListing parameters, String keyName, String defaultValue) {
        String paramValue = defaultValue;
        String customIdNameParam = parameters.get(keyName);
        if (customIdNameParam != null && !customIdNameParam.isEmpty()) {
            paramValue = "Cor" + customIdNameParam;
        }
        return paramValue;
    }

    private int fetchIntegerParameterSafe(AttributeListing parameters, String keyName, int defaultValue) {
        int value = defaultValue;
        String argumentPositionParam = parameters.get(keyName);
        if (argumentPositionParam != null && !argumentPositionParam.isEmpty()) {
            try {
                value = Integer.valueOf(argumentPositionParam);
            }
            catch (NumberFormatException nfe) {
                this.feedback.warn("Illegal value " + argumentPositionParam + " for " + keyName + " parameter. Expecting an integer. Using default value " + defaultValue);
            }
        }
        return value;
    }
}

