/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.clock.MasterClock;
import java.util.HashMap;
import java.util.Stack;

public class VirtualStackFeatureHelper {
    public static TransactionComponentData getTransactionSnapshotFromStack(IStackElement data, Runnable t, Throwable error, String errorMessage) {
        TransactionComponentData bizDefComponent;
        final Stack stack = new Stack();
        StackRecursionHelper.staticSafeRecurseAccessParent(data, new IStackElementCallbackOnRecursion(){

            @Override
            public boolean doOnElement(IStackElement pivot) {
                if (!(pivot instanceof INotAnOldModeStallSubscriber) && !(pivot instanceof WrappedInvocationData)) {
                    stack.push(pivot);
                }
                return false;
            }
        });
        IStackElement popped = (IStackElement)stack.pop();
        Throwable errorForData = popped == data ? error : null;
        TransactionComponentData root = null;
        long eventTime = MasterClock.currentTimeMillis();
        root = popped instanceof InvocationData ? VirtualStackFeatureHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, (InvocationData)popped, eventTime) : VirtualStackFeatureHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, eventTime);
        if (root == null) {
            return null;
        }
        TransactionComponentData cursor = root.getLeftmostLeafOrSelf();
        if (cursor == null) {
            return root;
        }
        while (!stack.isEmpty()) {
            popped = (IStackElement)stack.pop();
            errorForData = popped == data ? error : null;
            TransactionComponentData child = popped instanceof InvocationData ? VirtualStackFeatureHelper.getTransanctionSnapShotFromInvocationData(t, errorMessage, errorForData, (InvocationData)popped, eventTime) : VirtualStackFeatureHelper.getTransanctionSnapshotFromStackElement(t, errorMessage, errorForData, popped, eventTime);
            if (child == null) continue;
            cursor.addSubNode(child);
            cursor = child.getLeftmostLeafOrSelf();
        }
        if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
            root = bizDefComponent;
        }
        root.setParameterValue("Trace Type", "ErrorSnapshot");
        return root;
    }

    private static void fillComponentParams(TransactionComponentData component, InvocationData data, Runnable t, String errorMessage, Throwable error) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        parameters.put("Method", data.getProbeInformation().getProbeIdentification().getProbeMethodName());
        parameters.put("Method Descriptor", data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor());
        parameters.put("Class", data.getProbeInformation().getProbeIdentification().getRuntimeFullClassName());
        String lineInfo = data.getProbeInformation().getProbeIdentification().getSourceFileLine();
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        parameters.put("Resource Name", component.getResource());
        data.addParameterCallbacks(parameters);
        IFactoryLevelParameterCallback[] staticCallbacks = data.getProbeInformation().getCallbacks();
        for (int i = 0; i < staticCallbacks.length; ++i) {
            if (staticCallbacks[i] == null) continue;
            staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
        }
        if (t instanceof Thread) {
            Thread thread = (Thread)t;
            ThreadGroup tg = thread.getThreadGroup();
            if (tg == null) {
                try {
                    if (AgentShim.getAgent().IAgent_getModuleFeedback().isDebugEnabled()) {
                        AgentShim.getAgent().IAgent_getModuleFeedback().debug("Threadgroup for thread is null");
                    }
                }
                catch (AgentNotAvailableException agentNotAvailableException) {}
            } else {
                String threadGroupName;
                String threadName = InvocationData.limitSize(thread.getName());
                if (threadName != null) {
                    parameters.put("Thread Name", threadName);
                }
                if ((threadGroupName = InvocationData.limitSize(tg.getName())) != null) {
                    parameters.put("Thread Group Name", threadGroupName);
                }
            }
        } else if (t != null) {
            String threadName = InvocationData.limitSize(t.toString());
            if (threadName != null) {
                parameters.put("Thread Name", threadName);
            }
            parameters.put("Thread Group Name", "NA");
        }
        if (errorMessage != null) {
            parameters.put("Error Message", InvocationData.limitSize(errorMessage));
            parameters.put("Trace Type", "ErrorSnapshot");
            if (error != null) {
                parameters.put("Exception", InvocationData.limitSize(errorMessage));
            }
        }
    }

    public static TransactionComponentData getTransanctionSnapShotFromInvocationData(Runnable t, String errorMessage, Throwable error, InvocationData data, long eventTime) {
        if (data.getCursor() == null) {
            return null;
        }
        long startTime = data.getWallClockStartTime();
        long roughlyDuration = eventTime - startTime;
        TransactionComponentData root = null;
        TransactionComponentData curComponent = null;
        boolean isRootComponentAlreadySet = false;
        for (int i = 0; i < data.getStartCursorsCount(); ++i) {
            ITransactionElement element = data.getStartCursorAt(i);
            if (!(element instanceof BlameTransactionElement)) continue;
            String componentName = ((BlameTransactionElement)element).getComponentName();
            TransactionComponentData nextComponent = TransactionComponentData.createMilliSecTransactionComponentData(componentName, startTime, roughlyDuration);
            VirtualStackFeatureHelper.fillComponentParams(nextComponent, data, t, errorMessage, error);
            if (!isRootComponentAlreadySet) {
                curComponent = root = nextComponent;
                isRootComponentAlreadySet = true;
                continue;
            }
            curComponent.addSubNode(nextComponent);
            curComponent = nextComponent;
        }
        return root;
    }

    public static TransactionComponentData getTransanctionSnapshotFromStackElement(Runnable t, String errorMessage, Throwable error, IStackElement data, long eventTime) {
        long startTime = data.getWallClockStartTime();
        long duration = eventTime - startTime;
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(data.getComponentName(), startTime, duration);
        HashMap<String, String> parameters = new HashMap<String, String>();
        component.setParameters(parameters);
        if (data != null) {
            VirtualStack.addParameterCallbacks(parameters, data);
            data.addParameterCallbacks(parameters);
        }
        if (error != null) {
            parameters.put("Exception", error.getMessage());
        }
        if (errorMessage != null) {
            parameters.put("Error Message", errorMessage);
        }
        return component;
    }
}

