/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.urlgroup;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLRegExPreprocessor {
    protected final Rule[] rules;
    protected final boolean enabled;
    private final Module module;
    private final IModuleFeedbackChannel feedback;
    private static final Pattern NON_ESCAPED_SLASH = Pattern.compile("(?<!\\\\)\\/");

    public URLRegExPreprocessor(IndexedProperties props, String prefix, boolean enabled, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(enabled, props.getTrimmedIndexedProperties(prefix), module, feedback, localizer);
    }

    URLRegExPreprocessor(String[] properties, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(true, properties, module, feedback, localizer);
    }

    URLRegExPreprocessor(boolean enabled, String[] properties, Module module, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.enabled = enabled;
        this.module = module;
        this.feedback = feedback;
        if (!this.enabled) {
            feedback.info(module, "URL RegEx Group preprocessor is disabled");
            this.rules = new Rule[0];
            return;
        }
        if (properties == null) {
            this.rules = new Rule[0];
            return;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>(properties.length);
        for (String strRegex : properties) {
            Rule rule;
            block11: {
                if (strRegex == null || strRegex.length() == 0) continue;
                try {
                    if (strRegex.startsWith("s/")) {
                        String[] tokens = NON_ESCAPED_SLASH.split(strRegex);
                        switch (tokens.length) {
                            case 3: {
                                rule = new Rule(tokens[1], tokens[2], "");
                                break block11;
                            }
                            case 4: {
                                rule = new Rule(tokens[1], tokens[2], tokens[3]);
                                break block11;
                            }
                            default: {
                                feedback.warn(module, "Rule has wrong number of components: " + strRegex);
                                break;
                            }
                        }
                        continue;
                    }
                    rule = new Rule(strRegex, "", "g");
                }
                catch (RuntimeException e) {
                    feedback.warn(module, "Invalid rule: " + strRegex + ", the detailed cause follows: " + e.getMessage());
                    continue;
                }
            }
            rules.add(rule);
        }
        if (feedback.isDebugEnabled(module)) {
            feedback.debug(module, "Following RegEx preprocessor rule set is configured: " + rules);
        }
        this.rules = rules.toArray(new Rule[rules.size()]);
    }

    public String apply(String source) {
        if (!this.enabled) {
            return source;
        }
        CharSequence input = source;
        for (Rule rule : this.rules) {
            input = rule.apply(input);
        }
        String result = input.toString();
        if (this.feedback.isDebugEnabled(this.module)) {
            this.feedback.debug(this.module, '\"' + source + "\" had been normalized to \"" + result + "\"");
        }
        return result;
    }

    protected static final class Rule {
        final Pattern regex;
        final String replacement;
        final Set<Flags> flags;

        private Rule(Pattern regex, String replacement, Set<Flags> flags) {
            this.regex = regex;
            this.replacement = replacement;
            this.flags = flags;
        }

        private Rule(String regex, String replacement, String strFlags) {
            this(Pattern.compile(regex), replacement, Flags.parse(strFlags));
        }

        final CharSequence apply(CharSequence input) {
            Matcher matcher = this.regex.matcher(input);
            if (this.flags.contains((Object)Flags.GLOBAL)) {
                boolean result = matcher.find();
                if (!result) {
                    return input;
                }
                StringBuffer sb = new StringBuffer(input.length());
                do {
                    matcher.appendReplacement(sb, this.replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                return sb;
            }
            String replacement = this.replacement;
            if (replacement == null) {
                throw new NullPointerException("replacement is null");
            }
            if (!matcher.find()) {
                return input;
            }
            StringBuffer sb = new StringBuffer();
            matcher.appendReplacement(sb, replacement);
            matcher.appendTail(sb);
            return sb;
        }

        public String toString() {
            String text = this.regex.toString() + " will being replaced by " + this.replacement;
            if (this.flags.contains((Object)Flags.GLOBAL)) {
                return "{Each occurence of " + text + '}';
            }
            return '{' + text + " once}";
        }

        static enum Flags {
            GLOBAL;


            static Set<Flags> parse(String flags) {
                if (flags.contains("g")) {
                    return EnumSet.of(GLOBAL);
                }
                return EnumSet.noneOf(Flags.class);
            }
        }
    }
}

