/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.blame;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.HashCodeUtils;
import com.wily.util.adt.WeakElementArrayHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Map;

public final class BlameStackToCalledMetricConverter {
    private static final int kDefaultStringBufferSize = 256;
    private static final String kBlamedPrefixSegment = "|Called ";
    private static final String kNoResourceBlamedPrefix = "Metric";
    private static BlameStackToCalledMetricConverter sSingleton;
    private final Map fBlamedMetricCache = new WeakElementArrayHashMap(0, 1);

    private BlameStackToCalledMetricConverter() {
    }

    public static synchronized BlameStackToCalledMetricConverter getInstance() {
        if (sSingleton == null) {
            sSingleton = new BlameStackToCalledMetricConverter();
        }
        return sSingleton;
    }

    public AgentMetricData[] generateBlamedMetricBindingsNonSync(IModuleFeedbackChannel feedback, AgentMetricData[] original) {
        Assertion.wilyAssert(false);
        ArrayList<AgentMetricData> results = new ArrayList<AgentMetricData>(original.length);
        StringBuffer buffer = new StringBuffer(256);
        int i = 0;
        int l = original.length;
        while (i < l) {
            AgentMetricData binding = original[i];
            BlameStackSnapshot blameStack = binding.getTimeslicedValue().getBlameStackSnapshot();
            if (blameStack != null && blameStack.getComponentCount() > 0) {
                try {
                    Assertion.wilyAssert(false);
                    BlamedMetricCacheKey cacheKey = new BlamedMetricCacheKey(blameStack, binding.getAgentMetric());
                    AgentMetric blamedMetric = (AgentMetric)this.fBlamedMetricCache.get(cacheKey);
                    if (blamedMetric == null) {
                        String component = blameStack.getComponent(0);
                        buffer.setLength(0);
                        buffer.append(component);
                        buffer.append(kBlamedPrefixSegment);
                        BlameStackToCalledMetricConverter.addMetricNameToPath(buffer, binding.getBindingURL());
                        blamedMetric = new AgentMetric(buffer.toString(), binding.getAttributeType());
                        this.fBlamedMetricCache.put(cacheKey, blamedMetric);
                    }
                    AgentMetricData blamedBinding = new AgentMetricData(blamedMetric, binding.getFrequency(), binding.getDataValue());
                    results.add(blamedBinding);
                }
                catch (BadlyFormedNameException bfne) {
                    feedback.error(bfne.getInternalMessage(), bfne);
                }
            }
            ++i;
        }
        return results.toArray(AgentMetricData.kZeroLengthESETimeslicedBindingArray);
    }

    public static synchronized AgentMetricData[] generateBlamedMetricBindings(IModuleFeedbackChannel feedback, AgentMetricData[] original) {
        return BlameStackToCalledMetricConverter.getInstance().generateBlamedMetricBindingsNonSync(feedback, original);
    }

    private static void addMetricNameToPath(StringBuffer buffer, String metricName) {
        if (metricName.indexOf(58) == -1) {
            buffer.append(kNoResourceBlamedPrefix);
            buffer.append(':');
        }
        buffer.append(metricName);
    }

    private static class BlamedMetricCacheKey {
        private final BlameStackSnapshot fBlameStack;
        private final AgentMetric fMetric;
        private final int fHashCode;

        public BlamedMetricCacheKey(BlameStackSnapshot blameStack, AgentMetric metric) {
            this.fBlameStack = blameStack;
            this.fMetric = metric;
            this.fHashCode = this.calculateHashCode();
        }

        public boolean equals(Object obj) {
            BlamedMetricCacheKey cacheKey = (BlamedMetricCacheKey)obj;
            return cacheKey.fMetric.equals(this.fMetric) && cacheKey.fBlameStack.equals(this.fBlameStack);
        }

        public int hashCode() {
            return this.fHashCode;
        }

        private int calculateHashCode() {
            int hash = 17;
            hash = HashCodeUtils.accumulateHashCode(hash, this.fBlameStack.hashCode());
            hash = HashCodeUtils.accumulateHashCode(hash, this.fMetric.hashCode());
            return hash;
        }
    }
}

