/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.catalog.server;

import com.wily.isengard.catalog.server.CatalogException;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.BeanContainerCore;
import com.wily.isengard.container.BeanUpdateException;
import com.wily.isengard.container.IContainerControlService;
import com.wily.isengard.container.beans.IsengardBeanDescriptor;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.util.tree.DirectoryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.DirectoryPathAndEntry;
import com.wily.isengard.util.tree.DirectoryPathTokenizer;
import com.wily.isengard.util.tree.DirectoryTreeNode;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

class CatalogCore {
    private static Module sModule = new Module("CatalogCore");
    private static final IsengardBeanDescriptor[] kNoResults = new IsengardBeanDescriptor[0];
    private final DirectoryTreeNode fRootNode;
    private final IModuleFeedbackChannel fFeedback;
    private final PostOffice fPostOffice;
    private int fOrder = 0;

    CatalogCore(PostOffice po, IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
        this.fPostOffice = po;
        if (this.fPostOffice == null) {
            Assertion.wilyAssert(false);
        }
        this.fRootNode = new DirectoryTreeNode(null, "", null);
    }

    private void addBeanToCatalogAndCore(IsengardBeanDescriptor bean) throws EntryAlreadyExistsException, InvalidPathException, BeanActivationException {
        if (this.fFeedback.isTraceEnabled(sModule)) {
            this.fFeedback.trace(sModule, "Catalog: Adding bean - " + bean.getInstanceName());
        }
        DirectoryPath path = new DirectoryPath(bean.getInstanceName());
        CatalogEntry entry = new CatalogEntry(bean, this.fOrder++);
        this.fRootNode.addIfNotExists(new DirectoryPathTokenizer(path), entry);
        String containerPath = bean.getContainerName();
        try {
            IContainerControlService containerService = BeanContainerCore.getContainerControlService(this.fPostOffice, containerPath);
            containerService.addBean(bean);
        }
        catch (ConnectionException connectionException) {
            this.fRootNode.deleteEntry(new DirectoryPathTokenizer(path));
            throw new BeanActivationException("The connection to the remote node was lost and the bean was not activated");
        }
        catch (BeanActivationException e) {
            this.fRootNode.deleteEntry(new DirectoryPathTokenizer(path));
            throw e;
        }
    }

    CatalogEntry removeBeanFromCore(String beanName) throws InvalidPathException, EntryNotFoundException {
        CatalogEntry entry = (CatalogEntry)this.fRootNode.deleteEntry(new DirectoryPathTokenizer(beanName));
        if (entry == null) {
            throw new EntryNotFoundException("There was no entry found for: " + beanName);
        }
        String containerPath = entry.getBean().getContainerName();
        try {
            IContainerControlService containerService = BeanContainerCore.getContainerControlService(this.fPostOffice, containerPath);
            containerService.removeBean(entry.getBean());
        }
        catch (ConnectionException connectionException) {}
        return entry;
    }

    void removeBeans(String[] beans) throws EntryNotFoundException, CatalogException {
        try {
            int i = 0;
            while (i < beans.length) {
                this.removeBeanFromCore(beans[i]);
                ++i;
            }
        }
        catch (InvalidPathException e) {
            throw new CatalogException(e);
        }
    }

    void addBean(IsengardBeanDescriptor bean) throws EntryAlreadyExistsException, CatalogException, BeanActivationException {
        try {
            this.addBeanToCatalogAndCore(bean);
            return;
        }
        catch (InvalidPathException e) {
            throw new CatalogException(e);
        }
    }

    IsengardBeanDescriptor[] queryBeans(String query) {
        DirectoryPath queryPath = new DirectoryPath(query);
        ArrayList<IsengardBeanDescriptor> output = new ArrayList<IsengardBeanDescriptor>();
        try {
            if (this.fRootNode.hasEntry(new DirectoryPathTokenizer(queryPath))) {
                CatalogEntry entry = (CatalogEntry)this.fRootNode.getEntry(new DirectoryPathTokenizer(queryPath));
                output.add(entry.getBean());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The query [" + query + "] caused an unexpected error: " + e);
        }
        try {
            Iterator it = this.fRootNode.getSubDirectoryIterator(new DirectoryPathTokenizer(queryPath));
            while (it.hasNext()) {
                DirectoryPathAndEntry path = (DirectoryPathAndEntry)it.next();
                IsengardBeanDescriptor bean = ((CatalogEntry)path.getEntry()).getBean();
                output.add(bean);
            }
        }
        catch (InvalidPathException invalidPathException) {}
        return output.toArray(kNoResults);
    }

    public Object queryMatches(Object query, Object stateInformation) {
        String beanName;
        String prefix = (String)query;
        DirectoryPathAndEntry entry = (DirectoryPathAndEntry)stateInformation;
        CatalogEntry catalog = (CatalogEntry)entry.getEntry();
        if (catalog != null && (beanName = catalog.getBean().getInstanceName()).startsWith(prefix)) {
            return catalog.getBean();
        }
        return null;
    }

    public Object updateBean(String instanceName, Object data) throws InvalidPathException, EntryNotFoundException, BeanUpdateException {
        CatalogEntry entry = (CatalogEntry)this.fRootNode.getEntry(new DirectoryPathTokenizer(instanceName));
        String containerPath = entry.getBean().getContainerName();
        try {
            IContainerControlService containerService = BeanContainerCore.getContainerControlService(this.fPostOffice, containerPath);
            return containerService.updateBean(entry.getBean(), data);
        }
        catch (ConnectionException e) {
            throw new BeanUpdateException(e);
        }
    }

    public void passivateBeans() {
        Vector<DirectoryEntry> catalogEntries = new Vector<DirectoryEntry>();
        Iterator iter = this.fRootNode.iterator();
        while (iter.hasNext()) {
            DirectoryPathAndEntry directoryPathAndEntry = (DirectoryPathAndEntry)iter.next();
            if (!(directoryPathAndEntry.getEntry() instanceof CatalogEntry)) continue;
            catalogEntries.add(directoryPathAndEntry.getEntry());
        }
        Collections.sort(catalogEntries, new CatalogEntryComparator());
        for (CatalogEntry catalogEntry : catalogEntries) {
            String containerPath = catalogEntry.getBean().getContainerName();
            try {
                IContainerControlService containerService = BeanContainerCore.getContainerControlService(this.fPostOffice, containerPath);
                containerService.removeBean(catalogEntry.getBean());
            }
            catch (ConnectionException connectionException) {}
        }
        this.fRootNode.clear();
    }

    private static class CatalogEntry
    implements DirectoryEntry {
        private static final long serialVersionUID = 7689789411182596125L;
        private IsengardBeanDescriptor fBean;
        public int fStartupOrder;

        public CatalogEntry(IsengardBeanDescriptor bean, int startupOrder) {
            this.fBean = bean;
            this.fStartupOrder = startupOrder;
        }

        public IsengardBeanDescriptor getBean() {
            return this.fBean;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }
    }

    private class CatalogEntryComparator
    implements Comparator {
        private CatalogEntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            CatalogEntry catalogEntry1 = (CatalogEntry)o1;
            CatalogEntry catalogEntry2 = (CatalogEntry)o2;
            int val = catalogEntry2.fStartupOrder - catalogEntry1.fStartupOrder;
            return val;
        }
    }
}

