/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.powerpack.webservices.JAXWSUtils;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class AsyncCallbackTracer
extends ASingleInstanceTracerFactory {
    private DataAccumulatorFactory factory;
    private static final String kMetricNameDivider = ":";
    private static final String kResponseTimeMetricDefault = "Average Response Time (ms)";
    private static final String kPerIntervalMetricDefault = "Responses Per Interval";
    private static final String kErrorMetricDefault = "Errors Per Interval";

    public AsyncCallbackTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            ILongIntervalCounterDataAccumulator accumIntervalCnt;
            String strProbeDescriptor = data.getProbeInformation().getProbeIdentification().getProbeMethodDescriptor();
            Object objAsyncRespImpl = data.getInvocationObject();
            Throwable objError = (Throwable)data.getInvocationParameterAsObject(1);
            Map mapResponseCtx = JAXWSUtils.get();
            Long reqStartTime = (Long)mapResponseCtx.get("wily.request.startTime");
            long startTime = 0L;
            if (reqStartTime != null) {
                startTime = reqStartTime;
            }
            long endTime = System.currentTimeMillis();
            int avgrestime = (int)(endTime - startTime);
            String component = this.formatParameterizedName(data);
            BlameStackSnapshot snap = this.getComponentTracer().getSnapshot(component);
            this.factory = this.getAgent().IAgent_getDataAccumulatorFactory();
            IIntegerAverageDataAccumulator accumRespTime = this.factory.safeGetIntegerAverageDataAccumulator(component + kMetricNameDivider + kResponseTimeMetricDefault);
            if (!accumRespTime.IDataAccumulator_isShutOff()) {
                accumRespTime.IIntegerAggregatingDataAccumulator_recordDataPoint(avgrestime);
            }
            if (!(accumIntervalCnt = this.factory.safeGetLongIntervalCounterDataAccumulator(component + kMetricNameDivider + kPerIntervalMetricDefault)).IDataAccumulator_isShutOff()) {
                accumIntervalCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            ILongIntervalCounterDataAccumulator accumErrorCnt = this.factory.safeGetLongIntervalCounterDataAccumulator(component + kMetricNameDivider + kErrorMetricDefault);
            if (objError != null) {
                accumErrorCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
            } else {
                accumErrorCnt.forceMetricToExist(snap);
            }
        }
        catch (Exception e) {
            WSMUtils.handleError(this.getAgent(), e.getMessage(), e);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kMethodName;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

