/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.weblogic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.properties.AttributeListing;

public class JaxWSClientFaultTracer
extends ASingleInstanceTracerFactory {
    public JaxWSClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        WSMUtils.getLogger().debug("START:JaxWSClientFaultTracer.ITracer_finishTrace()");
        try {
            boolean isFault = data.hasInvocationThrownException();
            WSMUtils.getLogger().debug("JaxWsClientFaultTrace::fault " + isFault);
            String component = this.formatParameterizedName(data);
            if (isFault) {
                Throwable objInvocationError = data.getInvocationThrownException();
                Throwable errCause = objInvocationError.getCause();
                String strErrorMessage = "";
                strErrorMessage = errCause != null ? errCause.getMessage() : objInvocationError.getMessage();
                String faultMessage = "SOAP Fault:: " + strErrorMessage;
                WSMUtils.getLogger().debug("JaxWSClientFaultTracer::faultMessage:" + faultMessage);
                boolean errSnap = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)faultMessage);
                WSMUtils.getLogger().debug("JaxWSClientFaultTracer::errSnap:" + errSnap);
                String name = this.formatParameterizedName(data);
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            this.getComponentTracer().removeComponent(component);
        }
        catch (Exception e) {
            WSMUtils.getLogger().debug("JaxWSClientFaultTracer exception: " + WSMUtils.dumpStackTrace(e));
        }
        WSMUtils.getLogger().debug("END:JaxWSClientFaultTracer.ITracer_finishTrace()");
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        String component = this.formatParameterizedResource(data);
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

