/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.metricgrouping;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.urlgroup.URLComponents;
import com.wily.introscope.agent.urlgroup.URLGroupRuleContainer;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.util.adt.IConcurrentMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PropertyGroupListner;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;

public class WebservicesGroupPropertyHandler
implements PropertyGroupListner {
    private volatile URLGroupRuleContainer urlGroupRuleContainer = new URLGroupRuleContainer();
    private volatile boolean isNormalizationEnabled = false;
    private IModuleFeedbackChannel feedback;
    private static final Module module = new Module("WebservicesGroupPropertyHandler");
    private static int fWebservicesNamespaceClamp = -1;
    private static IConcurrentMap fWebservicesNamespaceGroupMap;
    private static IGuaranteedCounter fWebservicesNamespaceCounter;
    private static final String kUnspecified = "unspecified";

    public WebservicesGroupPropertyHandler(IAgent agent) {
        this.feedback = agent.IAgent_getModuleFeedback();
        this.initializeNamespaceGroups(agent);
        Map map = agent.IAgent_getConcurrentMapFactory().getConcurrentMap("WebservicesNamespaceUrlGroups");
        if (map instanceof IConcurrentMap) {
            fWebservicesNamespaceGroupMap = (IConcurrentMap)map;
        }
        fWebservicesNamespaceCounter = agent.IAgent_getGuaranteedCounter();
        agent.IAgent_getConfigurationManager().add(new ConfigurationProperty("introscope.agent.webservicesnamespacegroup.clamp", "5", "Hot_Property_Configuration_Property", null, true, false, this.feedback, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer()){

            public final void set(Object value) {
                fWebservicesNamespaceClamp = Integer.parseInt((String)value);
            }
        });
    }

    private void initializeNamespaceGroups(IAgent agent) {
        this.initializeNamespaceGroups(agent.IAgent_getIndexedProperties());
    }

    private void initializeNamespaceGroups(IndexedProperties props) {
        try {
            URLGroupRuleContainer container = new URLGroupRuleContainer();
            String keys = props.getProperty("introscope.agent.webservicesnamespacegroup.keys");
            boolean foundKey = false;
            if (keys != null && keys.length() > 0) {
                StringTokenizer strtok = new StringTokenizer(keys, ",", false);
                int i = 0;
                while (strtok.hasMoreTokens()) {
                    String currentKey = strtok.nextToken();
                    String propPrefix = "introscope.agent.webservicesnamespacegroup.group." + currentKey;
                    String prefixPropKey = propPrefix + ".pathprefix";
                    String formatPropKey = propPrefix + ".format";
                    String currentPathPrefix = props.getProperty(prefixPropKey);
                    String currentFormat = null;
                    if (currentPathPrefix != null && currentPathPrefix.length() > 0) {
                        currentFormat = props.getProperty(formatPropKey);
                        if (currentFormat != null && currentFormat.length() > 0) {
                            foundKey = true;
                            container.add(currentPathPrefix, currentFormat);
                        } else {
                            this.feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + ", " + formatPropKey + " has value " + currentFormat + " (both must be non-null and non-empty)");
                        }
                    } else {
                        this.feedback.warn("Mis-configured agent properties: " + prefixPropKey + " has value " + currentPathPrefix + " -- it must be non-null and non-empty");
                    }
                    ++i;
                }
            }
            this.urlGroupRuleContainer = container;
            this.isNormalizationEnabled = foundKey;
        }
        catch (Exception e) {
            try {
                this.feedback.error("BaseURINameFormatter: Could not initialize URL/Path groupings");
                this.feedback.verbose((Throwable)e);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public String getNormalizedPath(String path) {
        try {
            if (path == null || path.length() == 0) {
                path = kUnspecified;
            }
            if (!this.isNormalizationEnabled) {
                return path;
            }
            URLComponents urlComps = new URLComponents(null, null, 0, path, Collections.EMPTY_MAP);
            URLMatchResult matchResult = this.urlGroupRuleContainer.matchFirstRule(urlComps);
            if (matchResult != null && matchResult.getFormatted() != null && matchResult.getFormatted().length() != 0) {
                path = matchResult.getFormatted();
            } else {
                this.feedback.warn(module, "Could not get the normalized webservice path for:" + path);
            }
        }
        catch (Exception e) {
            this.feedback.error(module, "There is an error while doing the normalization:" + e.getMessage());
        }
        if (fWebservicesNamespaceClamp >= 0) {
            path = WebservicesGroupPropertyHandler.applyNamespaceGroupClamp(path, this.feedback);
        }
        return path;
    }

    private static String applyNamespaceGroupClamp(String normalizedNamespace, IModuleFeedbackChannel feedback) {
        String result = normalizedNamespace;
        String urlGroupKey = "";
        if (fWebservicesNamespaceGroupMap != null) {
            if (fWebservicesNamespaceGroupMap.containsKey((Object)result)) {
                return result;
            }
            if (!WebservicesGroupPropertyHandler.checkNamespaceGroupClamp(feedback)) {
                result = "Default";
                return result;
            }
            urlGroupKey = (String)fWebservicesNamespaceGroupMap.putIfAbsent((Object)result, (Object)"");
            if (urlGroupKey != null) {
                fWebservicesNamespaceCounter.prev();
            }
        }
        return result;
    }

    private static boolean checkNamespaceGroupClamp(IModuleFeedbackChannel feedback) {
        int urlCount;
        if (fWebservicesNamespaceClamp >= 0 && (urlCount = fWebservicesNamespaceCounter.next()) >= fWebservicesNamespaceClamp) {
            if (urlCount == fWebservicesNamespaceClamp) {
                feedback.info("Absolute Webservices-namespace metric clamp of " + fWebservicesNamespaceClamp + " reached, All metrics will now report under the Default group.");
                return true;
            }
            fWebservicesNamespaceCounter.prev();
            return false;
        }
        return true;
    }

    public String getKeyGroupPrefix() {
        return "introscope.agent.webservicesnamespacegroup";
    }

    public void onChange(IndexedProperties props) {
        WilyTransactionStructure.getInstance().ageAllImmediately();
        this.initializeNamespaceGroups(props);
    }
}

