/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.util.Glob;
import java.util.ArrayList;

public class MetricExclusionFilter {
    private final String[] fFilters;
    private final Glob[] fGlobs;

    public MetricExclusionFilter(String[] filters) {
        this.fFilters = filters;
        ArrayList<Glob> globs = new ArrayList<Glob>();
        if (filters != null) {
            for (int i = 0; i < this.fFilters.length; ++i) {
                if (this.fFilters[i].length() == 0) continue;
                globs.add(new Glob(this.fFilters[i]));
            }
        }
        this.fGlobs = globs.toArray(new Glob[globs.size()]);
    }

    public String[] getFilter() {
        return this.fFilters;
    }

    public boolean isOK(String metricName) {
        return this.computeIsOK(metricName);
    }

    private boolean computeIsOK(String metricName) {
        for (int i = 0; i < this.fGlobs.length; ++i) {
            if (!this.fGlobs[i].matches(metricName)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MetricExclusionFilter) {
            String[] filter = ((MetricExclusionFilter)obj).getFilter();
            if (this.fFilters.length != filter.length) {
                return false;
            }
            for (int i = 0; i < this.fFilters.length; ++i) {
                if (this.fFilters[i].equals(filter[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

