/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public abstract class ABlameTimer
extends ASingleInstanceTracerFactory {
    private static final int kDefaultStringBufferSize = 128;
    private final boolean fTraceConcurrency;
    private CacheValue fCacheValue;

    public ABlameTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject, boolean traceConcurrency) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fTraceConcurrency = traceConcurrency;
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected abstract String getRateString();

    protected abstract String getAverageString();

    protected abstract String getCountString();

    protected String getInstanceName(int tracerIndex, InvocationData data) {
        return this.getProbeIdentification().getRuntimeSimpleClassName();
    }

    private final boolean traceConcurrency() {
        return this.fTraceConcurrency;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        data.storeWallClockStartTime();
        CacheValue cacheValue = this.getCacheValue(tracerIndex, data);
        componentTracer.addComponent(stack, cacheValue.getComponentName(), data);
        if (this.traceConcurrency()) {
            IIntegerFluctuatingCounterDataAccumulator count = cacheValue.getCategoryCount();
            Assertion.wilyAssert(false);
            if (count != null) {
                count.IIntegerFluctuatingCounterDataAccumulator_increment();
            }
            count = cacheValue.getComponentCount();
            Assertion.wilyAssert(false);
            if (count != null) {
                count.IIntegerFluctuatingCounterDataAccumulator_increment();
            }
        }
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        IIntegerAverageDataAccumulator average;
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        CacheValue cacheValue = this.getCacheValue(tracerIndex, data);
        componentTracer.removeComponent(stack, cacheValue.getComponentName());
        int elapsedTime = data.getWallClockElapsedTimeAsInt();
        IIntegerRateDataAccumulator rate = cacheValue.getCategoryRate();
        if (!rate.IDataAccumulator_isShutOff()) {
            rate.IIntegerRateDataAccumulator_addSingleIncident();
        }
        if (!(average = cacheValue.getCategoryAverage()).IDataAccumulator_isShutOff()) {
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime);
        }
        IIntegerFluctuatingCounterDataAccumulator count = null;
        if (this.traceConcurrency()) {
            count = cacheValue.getCategoryCount();
            Assertion.wilyAssert(false);
            if (count != null) {
                count.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
        }
        BlameStackSnapshot snapshot = componentTracer.getSnapshot(stack, cacheValue.getComponentName());
        rate = cacheValue.getComponentRate();
        if (!rate.IDataAccumulator_isShutOff()) {
            rate.IIntegerRateDataAccumulator_addSingleIncident(snapshot);
        }
        if (!(average = cacheValue.getComponentAverage()).IDataAccumulator_isShutOff()) {
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime, snapshot);
        }
        if (this.traceConcurrency()) {
            count = cacheValue.getComponentCount();
            Assertion.wilyAssert(false);
            if (count != null) {
                count.IIntegerFluctuatingCounterDataAccumulator_decrement();
            }
        }
    }

    protected final CacheValue getCacheValue(int tracerIndex, InvocationData data) {
        if (this.canUseCaching()) {
            if (this.fCacheValue == null) {
                this.fCacheValue = this.buildCacheValue(this.getInstanceName(tracerIndex, data), this.formatParameterizedName(data), this.traceConcurrency());
            }
            return this.fCacheValue;
        }
        return this.buildCacheValue(this.getInstanceName(tracerIndex, data), this.formatParameterizedName(data), this.traceConcurrency());
    }

    private CacheValue buildCacheValue(String instanceName, String metricName, boolean traceConcurrency) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(metricName);
        buffer.append(':');
        int index = buffer.length();
        IIntegerFluctuatingCounterDataAccumulator categoryCount = null;
        if (traceConcurrency) {
            buffer.append(this.getCountString());
            categoryCount = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(buffer.toString());
        }
        buffer.setLength(index);
        buffer.append(this.getRateString());
        IIntegerRateDataAccumulator categoryRate = this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(buffer.toString());
        buffer.setLength(index);
        buffer.append(this.getAverageString());
        IIntegerAverageDataAccumulator categoryAverage = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(buffer.toString());
        buffer.setLength(index);
        buffer.setCharAt(index - 1, '|');
        buffer.append(instanceName);
        String componentName = buffer.toString();
        buffer.append(':');
        index = buffer.length();
        IIntegerFluctuatingCounterDataAccumulator componentCount = null;
        if (traceConcurrency) {
            buffer.append(this.getCountString());
            componentCount = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(buffer.toString());
        }
        buffer.setLength(index);
        buffer.append(this.getRateString());
        String componentBlamedRate = buffer.toString();
        IIntegerRateDataAccumulator componentRate = this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(componentBlamedRate);
        buffer.setLength(index);
        buffer.append(this.getAverageString());
        String componentBlamedAverage = buffer.toString();
        IIntegerAverageDataAccumulator componentAverage = this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(componentBlamedAverage);
        return new CacheValue(componentName, componentBlamedRate, componentBlamedAverage, categoryCount, categoryRate, categoryAverage, componentCount, componentRate, componentAverage);
    }

    private static final class CacheValue {
        private final String fComponentName;
        private final String fComponentBlamedRate;
        private final String fComponentBlamedAverage;
        private final IIntegerFluctuatingCounterDataAccumulator fCategoryCount;
        private final IIntegerFluctuatingCounterDataAccumulator fComponentCount;
        private final IIntegerRateDataAccumulator fCategoryRate;
        private final IIntegerRateDataAccumulator fComponentRate;
        private final IIntegerAverageDataAccumulator fCategoryAverage;
        private final IIntegerAverageDataAccumulator fComponentAverage;

        public CacheValue(String componentName, String componentBlamedRate, String componentBlamedAverage, IIntegerFluctuatingCounterDataAccumulator categoryCount, IIntegerRateDataAccumulator categoryRate, IIntegerAverageDataAccumulator categoryAverage, IIntegerFluctuatingCounterDataAccumulator componentCount, IIntegerRateDataAccumulator componentRate, IIntegerAverageDataAccumulator componentAverage) {
            this.fComponentName = componentName;
            this.fComponentBlamedRate = componentBlamedRate;
            this.fComponentBlamedAverage = componentBlamedAverage;
            this.fCategoryCount = categoryCount;
            this.fCategoryRate = categoryRate;
            this.fCategoryAverage = categoryAverage;
            this.fComponentCount = componentCount;
            this.fComponentRate = componentRate;
            this.fComponentAverage = componentAverage;
        }

        public String getComponentName() {
            return this.fComponentName;
        }

        public String getComponentBlamedRate() {
            return this.fComponentBlamedRate;
        }

        public String getComponentBlamedAverage() {
            return this.fComponentBlamedAverage;
        }

        public IIntegerFluctuatingCounterDataAccumulator getCategoryCount() {
            return this.fCategoryCount;
        }

        public IIntegerRateDataAccumulator getCategoryRate() {
            return this.fCategoryRate;
        }

        public IIntegerAverageDataAccumulator getCategoryAverage() {
            return this.fCategoryAverage;
        }

        public IIntegerFluctuatingCounterDataAccumulator getComponentCount() {
            return this.fComponentCount;
        }

        public IIntegerRateDataAccumulator getComponentRate() {
            return this.fComponentRate;
        }

        public IIntegerAverageDataAccumulator getComponentAverage() {
            return this.fComponentAverage;
        }
    }
}

