/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketConcurrentInvocationCounter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.io.OutputStream;

public class SocketConcurrentWriterCounter
extends SocketConcurrentInvocationCounter {
    public SocketConcurrentWriterCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final int getMetricPosition() {
        return 6;
    }

    @Override
    protected void decreaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.removeFromConcurrentWriters();
    }

    @Override
    protected void increaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.addToConcurrentWriters();
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketRequired()) {
            Object invocationObject = data.getInvocationObject();
            if (invocationObject instanceof OutputStream) {
                SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
                if (cache.getAccumulators(6) == null) {
                    this.getAccumulator(data);
                }
                return this;
            }
            Assertion.wilyAssert("Instrumentation error: invocation object not an OutputStream");
        }
        return null;
    }
}

