/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelPerIntervalCounter;
import com.wily.introscope.agent.trace.nio.SelectorOpenWatcher;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public final class SocketAcceptPerIntervalCounter
extends ChannelPerIntervalCounter
implements ITracer {
    public SocketAcceptPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof ServerSocketChannel) {
            if (!SelectorOpenWatcher.isInSelectorOpen()) {
                return this;
            }
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a ServerSocketChannel");
        }
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        if (!data.hasMethodResultAvailable()) {
            Assertion.wilyAssert("Instrumentation error: no method result");
            return null;
        }
        Object resultObject = data.getInvocationReturnValueAsObject();
        if (resultObject == null) {
            return null;
        }
        if (!(resultObject instanceof SocketChannel)) {
            Assertion.wilyAssert("Instrumentation error: method result is not a SocketChannel");
            return null;
        }
        SocketChannel socketChannel = (SocketChannel)resultObject;
        if (SocketChannelMap.isRequired(socketChannel, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }
}

