/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.stat.gatherer.AIntegerCombiningGatherer;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class IntegerFluctuatingCounterGatherer
extends AIntegerCombiningGatherer {
    private int fValue;
    private int fMinimum;
    private int fMaximum;

    public IntegerFluctuatingCounterGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    @Override
    public int getIntValue() {
        return this.fValue;
    }

    @Override
    public int getIntMinimum() {
        return this.fMinimum;
    }

    @Override
    public int getIntMaximum() {
        return this.fMaximum;
    }

    protected void directSetIntValue(int value) {
        this.fValue = value;
    }

    @Override
    protected void directSetIntMinimum(int minimum) {
        this.fMinimum = minimum;
    }

    @Override
    protected void directSetIntMaximum(int maximum) {
        this.fMaximum = maximum;
    }

    public synchronized void setValue(int value) {
        this.setValueUnsync(value);
    }

    public synchronized void increment() {
        this.setValueUnsync(this.getIntValue() + 1);
    }

    public synchronized void decrement() {
        this.setValueUnsync(this.getIntValue() - 1);
    }

    public synchronized void add(int delta) {
        this.setValueUnsync(this.getIntValue() + delta);
    }

    public synchronized void subtract(int delta) {
        this.setValueUnsync(this.getIntValue() - delta);
    }

    @Override
    protected void doAcceptAggregateIntegerTimeslicedValue(IntegerTimeslicedValue typedAggregate) {
        this.directSetIntValue(typedAggregate.getValue());
        this.syncAggregateBounds(typedAggregate);
        this.addToDataPointCount(typedAggregate.getDataPointCount());
    }

    private void setValueUnsync(int value) {
        this.directSetIntValue(value);
        this.syncSinglePointBounds(value);
        this.incrementDataPointCountNonSync();
        this.noteDataIsPresent();
        this.newDataPointsReceived();
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
        this.resetMinAndMax();
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
        this.directSetIntValue(0);
        this.resetMinAndMax();
    }

    private void resetMinAndMax() {
        this.directSetIntMinimum(this.getIntValue());
        this.directSetIntMaximum(this.getIntValue());
    }
}

