/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.thread.management;

import java.lang.management.ThreadInfo;

public class ThreadPerfStats {
    private final String fThreadName;
    private final long fCPUTimeMS;
    private final long fUserTimeMS;
    private final long fBlockedTimeMS;
    private final long fBlockedCount;
    private final long fWaitedTime;
    private final long fWaitedCount;

    public ThreadPerfStats(String threadName, long cpuTimeMS, long userTimeMS, long blockedTimeMS, long blockedCount, long waitedTimeMS, long waitedCount) {
        this.fThreadName = threadName;
        this.fCPUTimeMS = cpuTimeMS;
        this.fUserTimeMS = userTimeMS;
        this.fBlockedTimeMS = blockedTimeMS;
        this.fBlockedCount = blockedCount;
        this.fWaitedTime = waitedTimeMS;
        this.fWaitedCount = waitedCount;
    }

    public long getBlockedCount() {
        return this.fBlockedCount;
    }

    public long getBlockedTimeMS() {
        return this.fBlockedTimeMS;
    }

    public long getCPUTimeMS() {
        return this.fCPUTimeMS;
    }

    public long getUserTimeMS() {
        return this.fUserTimeMS;
    }

    public long getWaitedCount() {
        return this.fWaitedCount;
    }

    public long getWaitedTime() {
        return this.fWaitedTime;
    }

    public String getThreadName() {
        return this.fThreadName;
    }

    public static ThreadPerfStats create(long oldCPUTime, long newCPUTime, long oldUserTime, long newUserTime, ThreadInfo oldStats, ThreadInfo newStats) {
        return new ThreadPerfStats(newStats.getThreadName(), newCPUTime - oldCPUTime, newUserTime - oldUserTime, newStats.getBlockedTime() - oldStats.getBlockedTime(), newStats.getBlockedCount() - oldStats.getBlockedCount(), newStats.getWaitedTime() - oldStats.getWaitedTime(), newStats.getWaitedCount() - oldStats.getWaitedCount());
    }

    public static ThreadPerfStats aggregate(ThreadPerfStats stats, ThreadPerfStats stats2) {
        return new ThreadPerfStats(stats.getThreadName(), stats.getCPUTimeMS() + stats2.getCPUTimeMS(), stats.getUserTimeMS() + stats2.getUserTimeMS(), stats.getBlockedTimeMS() + stats2.getBlockedTimeMS(), stats.getBlockedCount() + stats2.getBlockedCount(), stats.getWaitedTime() + stats2.getWaitedTime(), stats.getWaitedCount() + stats2.getWaitedCount());
    }
}

