/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.IllegalServiceAccessException;
import com.wily.isengard.messageprimitives.service.MessageServiceClient;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.wilyassert.Assertion;
import java.util.Iterator;
import java.util.Set;

class RegisteredMessageServiceClient
extends MessageServiceClient {
    public RegisteredMessageServiceClient(PostOffice po, Class interfaceClass, String relativeServiceName) throws EntryNotFoundException, ConnectionException, IllegalServiceAccessException {
        super(po, interfaceClass, null);
        RegistryEntry entry;
        String absoluteServiceName;
        IRegistryService client = po.getRegistry();
        if (relativeServiceName != null) {
            Assertion.wilyAssert(relativeServiceName.charAt(0) != '/');
            absoluteServiceName = "/service/" + interfaceClass.getName() + "/" + relativeServiceName;
        } else {
            absoluteServiceName = "/service/" + interfaceClass.getName();
        }
        try {
            entry = client.getEntry(new DirectoryPath(absoluteServiceName));
        }
        catch (InvalidPathException ipe) {
            throw new EntryNotFoundException(ipe.getPath());
        }
        super.setServiceAddress(this.selectAddress(entry));
    }

    protected Address selectAddress(RegistryEntry entry) {
        Set addreses = entry.getAddresses();
        Address bestmatch = null;
        Iterator it = addreses.iterator();
        bestmatch = (Address)it.next();
        while (it.hasNext()) {
            Address address = (Address)it.next();
            if (address.getPostOffice().equals(this.getAddress().getPostOffice())) {
                bestmatch = address;
                break;
            }
            if (!address.getPostOffice().postOfficeHubEquals(this.getAddress().getPostOffice().getHubName())) continue;
            bestmatch = address;
        }
        return bestmatch;
    }
}

