/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class Address
implements Externalizable {
    private static final long serialVersionUID = -2721344172890934646L;
    public static final String[] kAllGroupsHaveAccess = new String[]{"*"};
    private PostOfficeSpecifier fPostOffice;
    private int fMailboxNumber;
    private String[] fGroupAccess;
    private transient Object fHandler;

    public Address() {
    }

    public Address(PostOfficeHub hub) {
        this.fPostOffice = new PostOfficeSpecifier(hub.getHubName(), "Hub");
        this.fMailboxNumber = 0;
    }

    public Address(PostOfficeSpecifier postOffice, int mailboxNumber) {
        this.fPostOffice = postOffice;
        this.fMailboxNumber = mailboxNumber;
    }

    public void setGroupAccess(String[] groupAccess) {
        this.fGroupAccess = groupAccess;
    }

    public String[] getGroupAccess() {
        return this.fGroupAccess;
    }

    public final int getMailboxNumber() {
        return this.fMailboxNumber;
    }

    public final PostOfficeSpecifier getPostOffice() {
        return this.fPostOffice;
    }

    public String toString() {
        return String.valueOf(this.fPostOffice.toString()) + ":" + this.fMailboxNumber;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fPostOffice);
        out.writeInt(this.fMailboxNumber);
        out.writeObject(this.fGroupAccess);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fPostOffice = (PostOfficeSpecifier)in.readObject();
        this.fMailboxNumber = in.readInt();
        this.fGroupAccess = (String[])in.readObject();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address addressObj = (Address)obj;
        return addressObj.fPostOffice.equals(this.fPostOffice) && addressObj.fMailboxNumber == this.fMailboxNumber;
    }

    public int hashCode() {
        return this.fPostOffice.hashCode() ^ this.fMailboxNumber;
    }

    public final Object getInvocationHandler() {
        return this.fHandler;
    }

    public final void setInvocationHandler(Object invocationHandler) {
        this.fHandler = invocationHandler;
    }
}

