/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.isengard.data.IIsengardStaticExternalizable;
import com.wily.isengard.messageprimitives.InterfaceUtilities;
import com.wily.isengard.messageprimitives.InterfaceVersionException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postofficehub.link.NonTerminalIOException;
import com.wily.isengard.postofficehub.link.v1.CacheCorruptionException;
import com.wily.isengard.postofficehub.link.v1.CountingInputStream;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectStreamConstants;
import com.wily.isengard.util.io.DefaultSerializationHandler;
import com.wily.isengard.util.io.ISerializationHandler;
import com.wily.isengard.util.io.WireFormatClassNameMapper;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.adt.IntHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.IConstructorExternalizable;
import com.wily.util.io.IKeyedClassLoader;
import com.wily.wilyassert.Assertion;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public class IsengardObjectInputStream
implements ObjectInput {
    private static Module sModule = new Module("IsengardObjectInputStream");
    private static Class[] kZeroLengthClassArray = new Class[0];
    private final ISerializationHandler fSerializationHandler;
    private DataInputStream fIn;
    private CountingInputStream fCountingInputStream;
    private IModuleFeedbackChannel fFeedback;
    private final IKeyedClassLoader fKeyedClassLoader;
    private StreamState fStreamState;
    private Address fLastMessageSourceAddress;
    private int fStreamVersion;
    private Object[] fThisAsObjectArray;

    public IsengardObjectInputStream(IKeyedClassLoader keyedClassLoader, InputStream in, IModuleFeedbackChannel feedback) throws IOException {
        this(keyedClassLoader, in, new DefaultSerializationHandler(), feedback);
    }

    public IsengardObjectInputStream(IsengardObjectInputStream parent, InputStream in) throws IOException {
        this(parent.getKeyedClassLoader(), in, parent.getSerializationHandler(), parent.getModuleFeedback(), parent.getStreamState());
    }

    private StreamState getStreamState() {
        return this.fStreamState;
    }

    public IsengardObjectInputStream(IKeyedClassLoader keyedClassLoader, InputStream in, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback) throws IOException {
        this(keyedClassLoader, in, serializationHandler, feedback, new StreamState());
    }

    public IsengardObjectInputStream(IKeyedClassLoader keyedClassLoader, InputStream in, ISerializationHandler serializationHandler, IModuleFeedbackChannel feedback, StreamState state) throws IOException {
        CheckParameter.notNull("Input Stream", in);
        CheckParameter.notNull("KeyedClassloader", keyedClassLoader);
        CheckParameter.notNull("Serialization Handler", serializationHandler);
        CheckParameter.notNull("Feedback Channel", feedback);
        this.fStreamState = state;
        this.fFeedback = feedback;
        this.fKeyedClassLoader = keyedClassLoader;
        this.fStreamVersion = in.read();
        if (this.fStreamVersion < 1 || this.fStreamVersion > 2) {
            throw new IOException("Expected Isengard v1 protocol instead of version " + this.fStreamVersion);
        }
        this.fSerializationHandler = serializationHandler;
        this.fCountingInputStream = new CountingInputStream(in);
        this.fIn = new DataInputStream(this.fCountingInputStream);
        this.fThisAsObjectArray = new Object[]{this};
    }

    public void updateInputStream(InputStream in) {
        CheckParameter.notNull("Input Stream", in);
        this.fCountingInputStream = new CountingInputStream(in);
        this.fIn = new DataInputStream(this.fCountingInputStream);
    }

    public IKeyedClassLoader getKeyedClassLoader() {
        return this.fKeyedClassLoader;
    }

    @Override
    public int available() throws IOException {
        return this.fIn.available();
    }

    @Override
    public int read() throws IOException {
        return this.fIn.read();
    }

    @Override
    public void close() throws IOException {
        this.fIn.close();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fIn.skip(n);
    }

    @Override
    public int read(byte[] b) throws IOException {
        Assertion.unimplemented("Introscope code should use readFully() - this call doesn't always return all the data that you want");
        return this.fIn.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Assertion.unimplemented("Introscope code should use readFully() - this call doesn't always return all the data that you want");
        return this.fIn.read(b, off, len);
    }

    private void reset() {
        this.fStreamState.fObjectMap = new IntHashMap();
    }

    private void resetCache() {
        if (this.getFeedbackChannel().isVerboseEnabled()) {
            this.getFeedbackChannel().verbose("Resetting the IsengardObjectInputStream Cache:  fCachedObjects Size before the reset= " + this.fStreamState.fCachedObjects.size() + " for Message Source Address: " + this.getLastMessageSourceAddress());
        }
        this.fStreamState.fCachedObjects = new IntHashMap();
        this.fStreamState.fCachedStrings = new IntHashMap();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        byte control;
        if (this.isStartObjectGraph()) {
            this.setUpStartObjectGraph();
        }
        if ((control = this.readByte()) == 74) {
            this.reset();
            control = this.readByte();
        }
        if (control == 86) {
            this.resetCache();
            control = this.readByte();
        }
        boolean throwingException = false;
        try {
            if (control != 72) {
                throw new StreamCorruptedException("Invalid control byte: " + control);
            }
            byte code = this.readByte();
            if (code == 67) {
                return null;
            }
            if (code == 84) {
                int key = this.readInt();
                Object result = this.fStreamState.fCachedObjects.get(key);
                if (result == null) {
                    throw new InvalidClassException("Invalid object cached object reference (" + key + ") due to previous bad object.");
                }
                if (IsengardObjectStreamConstants.kDebugStream) {
                    this.getFeedbackChannel().warn(sModule, "Read cached object " + key + ": " + result.getClass());
                }
                Object object = result;
                return object;
            }
            if (code == 64) {
                int key = this.readInt();
                Object result = this.fStreamState.fObjectMap.get(key);
                if (result == null) {
                    throw new InvalidClassException("Invalid object cache reference (" + key + ") due to previous bad object.");
                }
                if (IsengardObjectStreamConstants.kDebugStream) {
                    this.getFeedbackChannel().warn(sModule, "Read cached object " + key + ": " + result.getClass());
                }
                Object object = result;
                return object;
            }
            if (code == 83) {
                int key = this.readInt();
                Object result = this.readIsengardDataObject(key, this.fStreamState.fCachedObjects);
                this.fStreamState.fCachedObjects.put(key, result);
                Object object = result;
                return object;
            }
            if (code == 65) {
                int key = this.readInt();
                Object result = this.readIsengardDataObject(key, this.fStreamState.fObjectMap);
                this.fStreamState.fObjectMap.put(key, result);
                Object object = result;
                return object;
            }
            if (code == 85) {
                int key = this.readInt();
                Object result = this.readSerializable(key, this.fStreamState.fCachedObjects);
                this.fStreamState.fCachedObjects.put(key, result);
                Object object = result;
                return object;
            }
            if (code == 66) {
                int key = this.readInt();
                Object result = this.readSerializable(key, this.fStreamState.fObjectMap);
                this.fStreamState.fObjectMap.put(key, result);
                Object object = result;
                return object;
            }
            if (code == 68) {
                ClassDescriptor classDesc = this.readClass();
                if (IsengardObjectStreamConstants.kDebugStream) {
                    this.getFeedbackChannel().warn(sModule, "Read object array " + classDesc.getUnderlyingClass());
                }
                int size = this.readInt();
                Object[] result = (Object[])Array.newInstance(classDesc.getUnderlyingClass().getComponentType(), size);
                int i = 0;
                while (i < size) {
                    result[i] = this.readObject();
                    ++i;
                }
                Object[] objectArray = result;
                return objectArray;
            }
            try {
                throw new StreamCorruptedException("Invalid control code: " + code);
            }
            catch (ClassNotFoundException e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw e;
            }
            catch (NoClassDefFoundError e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw e;
            }
            catch (IOException e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw e;
            }
            catch (InstantiationException e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw new IOException(e.toString());
            }
            catch (IllegalAccessException e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw new IOException(e.toString());
            }
            catch (StackOverflowError e) {
                this.getFeedbackChannel().warn(sModule, e.getMessage());
                throwingException = true;
                throw new NonTerminalIOException(e.toString(), true);
            }
        }
        finally {
            if (throwingException) {
                this.resetObjectCount();
                this.skipToNextObjectGraph();
            } else {
                this.decrementObjectCount();
            }
        }
    }

    private boolean isStartObjectGraph() {
        return this.fStreamState.fNestedObjectCount++ == 0;
    }

    private void setUpStartObjectGraph() throws IOException {
        this.fStreamState.fCurrentObjectGraphLength = this.readInt();
        this.fCountingInputStream.resetCount();
        this.fStreamState.fTopLevelObject = null;
    }

    private void decrementObjectCount() {
        --this.fStreamState.fNestedObjectCount;
    }

    private void resetObjectCount() {
        this.fStreamState.fNestedObjectCount = 0;
    }

    private void skipToNextObjectGraph() throws IOException {
        if (this.fStreamState.fCurrentObjectGraphLength > 0) {
            int expectedSkipped = Math.max(this.fStreamState.fCurrentObjectGraphLength - this.fCountingInputStream.getCount(), 0);
            long skipped = 0L;
            skipped = this.fIn.skip(expectedSkipped);
            if (IsengardObjectStreamConstants.kDebugStream) {
                this.getFeedbackChannel().warn(sModule, "Expected skipped bytes= " + expectedSkipped + ", actual skipped bytes= " + skipped);
            }
            this.fCountingInputStream.resetCount();
            this.fStreamState.fCurrentObjectGraphLength = -1;
        }
    }

    public ClassDescriptor readClass() throws IOException, ClassNotFoundException {
        byte code = this.readByte();
        int id = this.readInt();
        ClassDescriptor desc = null;
        Class<Serializable> clazz = null;
        if (code == 69) {
            desc = (ClassDescriptor)this.fStreamState.fCachedObjects.get(id);
            if (desc == null) {
                this.printObjectMap();
                this.printCachedObjects();
                boolean temp = this.fStreamState.fCachedObjects.containsKey(id);
                String message = "Internal cache is corrupt. Cannot determine class type for Object " + id + ". A prior class deserialization error may have corrupted the cache. And fStreamState.fCachedObjects.containsKey(id) returned:" + temp;
                throw new CacheCorruptionException(message);
            }
        } else if (code == 70) {
            String classLoaderName = this.fIn.readUTF();
            String className = WireFormatClassNameMapper.mapWireToInternal(this.fIn.readUTF());
            try {
                clazz = className.equals("long") ? Long.TYPE : (className.equals("int") ? Integer.TYPE : (className.equals("boolean") ? Boolean.TYPE : (className.equals("short") ? Short.TYPE : (className.equals("char") ? Character.TYPE : (className.equals("byte") ? Byte.TYPE : (className.equals("double") ? Double.TYPE : (className.equals("float") ? Float.TYPE : this.fKeyedClassLoader.forName(classLoaderName, className))))))));
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (className.equals("long")) {
                    clazz = Long.TYPE;
                }
                if (className.equals("int")) {
                    clazz = Integer.TYPE;
                }
                if (className.equals("boolean")) {
                    clazz = Boolean.TYPE;
                }
                if (className.equals("short")) {
                    clazz = Short.TYPE;
                }
                if (className.equals("char")) {
                    clazz = Character.TYPE;
                }
                if (className.equals("byte")) {
                    clazz = Byte.TYPE;
                }
                if (className.equals("double")) {
                    clazz = Double.TYPE;
                }
                if (className.equals("float")) {
                    clazz = Float.TYPE;
                }
                StringBuffer messageBuffer = new StringBuffer();
                if (classLoaderName != null && classLoaderName.length() > 0) {
                    messageBuffer.append("Classloader \"");
                    messageBuffer.append(classLoaderName);
                    messageBuffer.append("\" is not registered.  ");
                }
                messageBuffer.append("Object of type \"");
                messageBuffer.append(className);
                messageBuffer.append("\" cannot be deserialized from loader: ");
                messageBuffer.append(classLoaderName);
                this.getFeedbackChannel().error(sModule, messageBuffer.toString());
                throw new ClassNotFoundException(messageBuffer.toString());
            }
            desc = new ClassDescriptor(clazz);
            this.fStreamState.fCachedObjects.put(id, desc);
        } else {
            throw new StreamCorruptedException("Invalid class code: " + code);
        }
        return desc;
    }

    private void printCachedObjects() {
        Iterator it = this.fStreamState.fCachedObjects.entrySet().iterator();
        StringBuffer buf = new StringBuffer("Dumping contents of fCachedObjects:\n");
        while (it.hasNext()) {
            IntHashMap.Entry entry = (IntHashMap.Entry)it.next();
            buf.append(entry.getKey());
            buf.append(" -> ");
            try {
                buf.append(entry.getValue());
            }
            catch (Exception exception) {
                buf.append("?");
            }
            buf.append("\n");
        }
        this.getFeedbackChannel().info(sModule, buf.toString());
    }

    public Method readMethod(int remoteVersion) throws IOException, ClassNotFoundException, InterfaceVersionException {
        byte code = this.readByte();
        int id = this.readInt();
        if (code == 88) {
            return (Method)this.fStreamState.fCachedObjects.get(id);
        }
        if (code == 87) {
            ClassDescriptor clazzDesc = this.readClass();
            String methodName = this.fIn.readUTF();
            Class[] paramClasses = (Class[])this.readObject();
            int localVersion = InterfaceUtilities.getInterfaceVersion(clazzDesc.getUnderlyingClass());
            if (localVersion != remoteVersion) {
                throw new InterfaceVersionException(methodName, remoteVersion);
            }
            try {
                Method method = clazzDesc.getUnderlyingClass().getDeclaredMethod(methodName, paramClasses);
                Assertion.wilyAssert(method != null);
                this.fStreamState.fCachedObjects.put(id, method);
                return method;
            }
            catch (SecurityException e) {
                throw new IOException("Caught exception: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new IOException("No method exception: " + e.getMessage());
            }
        }
        throw new StreamCorruptedException("Invalid method code: " + code);
    }

    private Object readIsengardDataObject(int key, IntHashMap cache) throws IOException, ClassNotFoundException {
        ClassDescriptor descriptor = this.readClass();
        Class clazz = descriptor.getUnderlyingClass();
        Object result = null;
        if (IsengardObjectStreamConstants.kDebugStream) {
            this.getFeedbackChannel().warn(sModule, "Read new Isengard object " + key + ": " + clazz);
        }
        if (descriptor.isConstructorExternalizable()) {
            try {
                result = descriptor.getDeserializeConstructor().newInstance(this.fThisAsObjectArray);
                cache.put(key, result);
            }
            catch (IllegalAccessException t) {
                this.getFeedbackChannel().error("Illegal Access Exception trying to construct class " + clazz + ". The class is probably private.");
                throw (IOException)new IOException("Illegal Access Exception trying to construct class " + clazz + ". The class is probably private.").initCause(t);
            }
            catch (InvocationTargetException t) {
                Throwable targetException = t.getTargetException();
                if (targetException instanceof IOException) {
                    throw (IOException)targetException;
                }
                if (targetException instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)targetException;
                }
                throw (IOException)new IOException("Unexpected constructor exception " + targetException).initCause(t);
            }
            catch (Throwable t) {
                throw (IOException)new IOException("Caught unexpected exception " + t + " while deserializing class " + clazz).initCause(t);
            }
        }
        if (descriptor.isStaticConstructor()) {
            try {
                Method m = clazz.getMethod("readExternal", ObjectInput.class);
                m.setAccessible(true);
                result = m.invoke(null, this);
                cache.put(key, result);
            }
            catch (NoSuchMethodException t) {
                this.getFeedbackChannel().error("Failed to find static readExternal() method in class " + clazz, t);
                throw (IOException)new IOException("Failed to find static readExternal() method in class " + clazz).initCause(t);
            }
            catch (InvocationTargetException t) {
                Throwable caught = t.getTargetException();
                if (caught instanceof IOException) {
                    throw (IOException)caught;
                }
                if (caught instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)caught;
                }
                this.getFeedbackChannel().error("Unexpected InvocationTargetException while deserializing class " + clazz, t);
                throw (IOException)new IOException("Unexpected exception caught while deserializing class " + clazz).initCause(t);
            }
            catch (Throwable t) {
                this.getFeedbackChannel().error("Unexpected exception caught while deserializing class " + clazz, t);
                throw (IOException)new IOException("Unexpected exception caught while deserializing class " + clazz).initCause(t);
            }
        }
        try {
            result = descriptor.getDeserializeConstructor().newInstance(null);
        }
        catch (IllegalAccessException t) {
            this.getFeedbackChannel().error("Illegal Access Exception trying to construct class " + clazz + ". The class is probably private.");
            throw (IOException)new IOException("Illegal Access Exception trying to construct class " + clazz + ". The class is probably private.").initCause(t);
        }
        catch (InvocationTargetException e) {
            this.getFeedbackChannel().error("Exception in constructor of " + clazz, e);
            throw (InvalidClassException)new InvalidClassException("Unable to create instance of " + clazz).initCause(e);
        }
        catch (Exception e) {
            throw (InvalidClassException)new InvalidClassException("Unable to create instance of " + clazz.getName() + ": " + e.toString()).initCause(e);
        }
        cache.put(key, result);
        if (this.fStreamState.fTopLevelObject == null) {
            this.fStreamState.fTopLevelObject = result;
        }
        try {
            ((Externalizable)result).readExternal(this);
        }
        catch (IOException e) {
            this.getFeedbackChannel().debug("Caught IO Exception while deserializing object. Stream probably corrupt. Last deserialized class: " + this.fStreamState.fLastClassDeserialized.getClass().getName(), e);
            throw e;
        }
        if (descriptor.isReadResolve()) {
            result = ((IIsengardReadResolve)result).readResolve();
            cache.put(key, result);
        }
        if (IsengardObjectStreamConstants.kDebugStream) {
            if (result != null) {
                this.getFeedbackChannel().warn(sModule, "  Object Value: " + result);
            } else {
                this.getFeedbackChannel().warn(sModule, "  Object Value: null");
            }
        }
        if (result != null) {
            this.fStreamState.fLastClassDeserialized = result;
        }
        return result;
    }

    private ArrayList readArrayList(int key, IntHashMap cache) throws ClassNotFoundException, IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        cache.put(key, result);
        int size = this.readInt();
        int i = 0;
        while (i < size) {
            Object obj = this.readObject();
            result.add(obj);
            ++i;
        }
        return result;
    }

    private LinkedList readLinkedList(int key, IntHashMap cache) throws ClassNotFoundException, IOException {
        LinkedList<Object> result = new LinkedList<Object>();
        cache.put(key, result);
        int size = this.readInt();
        int i = 0;
        while (i < size) {
            Object obj = this.readObject();
            result.add(obj);
            ++i;
        }
        return result;
    }

    private HashMap readHashMap(int key, IntHashMap cache) throws ClassNotFoundException, IOException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        cache.put(key, result);
        int size = this.readInt();
        int i = 0;
        while (i < size) {
            Object hashKey = this.readObject();
            Object hashValue = this.readObject();
            result.put(hashKey, hashValue);
            ++i;
        }
        return result;
    }

    private TreeMap readTreeMap(int key, IntHashMap cache) throws ClassNotFoundException, IOException {
        TreeMap result = new TreeMap(this.readHashMap(key, cache));
        cache.put(key, result);
        return result;
    }

    private Collection readCollection(Class clazz, int key, IntHashMap cache) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        int size = this.readInt();
        Collection list = (Collection)clazz.newInstance();
        int x = 0;
        while (x < size) {
            list.add(this.readObject());
            ++x;
        }
        cache.put(key, list);
        return list;
    }

    private HashSet readHashSet(int key, IntHashMap cache) throws ClassNotFoundException, IOException {
        HashSet<Object> result = new HashSet<Object>();
        cache.put(key, result);
        int size = this.readInt();
        int i = 0;
        while (i < size) {
            result.add(this.readObject());
            ++i;
        }
        return result;
    }

    private Object readSerializable(int key, IntHashMap cache) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object result;
        Class clazz = this.readClass().getUnderlyingClass();
        if (IsengardObjectStreamConstants.kDebugStream) {
            this.getFeedbackChannel().warn(sModule, "Read new Serializable object " + key + ": " + clazz);
        }
        if (clazz == Integer.class) {
            result = new Integer(this.readInt());
        } else if (clazz == Long.class) {
            result = new Long(this.readLong());
        } else if (clazz == Double.class) {
            result = new Double(this.readDouble());
        } else if (clazz == String.class) {
            result = this.fIn.readUTF();
        } else {
            if (clazz == ArrayList.class) {
                return this.readArrayList(key, cache);
            }
            if (clazz == LinkedList.class) {
                return this.readLinkedList(key, cache);
            }
            if (clazz == HashMap.class) {
                return this.readHashMap(key, cache);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return this.readCollection(clazz, key, cache);
            }
            if (clazz == HashSet.class) {
                return this.readHashSet(key, cache);
            }
            if (clazz == TreeMap.class) {
                return this.readTreeMap(key, cache);
            }
            if (clazz == Class.class) {
                result = this.readClass().getUnderlyingClass();
            } else if (clazz == Boolean.class) {
                result = this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            } else if (IsengardObjectInputStream.isArrayOfPrimitivesClass(clazz)) {
                result = this.readArrayOfPrimitives(key, cache);
            } else if (Serializable.class.isAssignableFrom(clazz)) {
                result = this.fSerializationHandler.deserialize(this, this.fKeyedClassLoader);
            } else {
                throw new ClassNotFoundException("Didn't know how to deserialize class " + clazz);
            }
        }
        if (IsengardObjectStreamConstants.kDebugStream) {
            this.getFeedbackChannel().warn(sModule, "  Object: " + result);
        }
        cache.put(key, result);
        return result;
    }

    public Object readArrayOfPrimitives(int key, IntHashMap cache) throws IOException {
        byte type = this.readByte();
        switch (type) {
            case 76: {
                return this.readBooleanArray(key);
            }
            case 79: {
                return this.readByteArray(key);
            }
            case 82: {
                return this.readCharArray(key);
            }
            case 78: {
                return this.readDoubleArray(key);
            }
            case 80: {
                return this.readFloatArray(key);
            }
            case 75: {
                return this.readIntegerArray(key);
            }
            case 77: {
                return this.readLongArray(key);
            }
            case 81: {
                return this.readShortArray(key);
            }
        }
        throw new IllegalArgumentException("Unknown primitive array type");
    }

    public int[] readIntegerArray(int key) throws IOException {
        int length = this.readInt();
        int[] ints = new int[length];
        int x = 0;
        while (x < length) {
            ints[x] = this.readInt();
            ++x;
        }
        return ints;
    }

    public byte[] readByteArray(int key) throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        int x = 0;
        while (x < length) {
            bytes[x] = this.readByte();
            ++x;
        }
        return bytes;
    }

    public char[] readCharArray(int key) throws IOException {
        if (this.fStreamVersion == 1) {
            int length = this.readInt();
            char[] prims = new char[length];
            int x = 0;
            while (x < length) {
                prims[x] = this.readChar();
                ++x;
            }
            return prims;
        }
        int byteArrayLen = this.readInt();
        byte[] input = new byte[byteArrayLen];
        this.readFully(input);
        char[] charArray = new char[byteArrayLen >> 1];
        int index = 0;
        int i = 0;
        while (i < charArray.length) {
            charArray[i] = (char)((input[index++] & 0xFF) << 8 | input[index++] & 0xFF);
            ++i;
        }
        return charArray;
    }

    public long[] readLongArray(int key) throws IOException {
        int length = this.readInt();
        long[] prims = new long[length];
        int x = 0;
        while (x < length) {
            prims[x] = this.readLong();
            ++x;
        }
        return prims;
    }

    public float[] readFloatArray(int key) throws IOException {
        int length = this.readInt();
        float[] prims = new float[length];
        int x = 0;
        while (x < length) {
            prims[x] = this.readFloat();
            ++x;
        }
        return prims;
    }

    public double[] readDoubleArray(int key) throws IOException {
        int length = this.readInt();
        double[] prims = new double[length];
        int x = 0;
        while (x < length) {
            prims[x] = this.readDouble();
            ++x;
        }
        return prims;
    }

    public short[] readShortArray(int key) throws IOException {
        int length = this.readInt();
        short[] prims = new short[length];
        int x = 0;
        while (x < length) {
            prims[x] = this.readShort();
            ++x;
        }
        return prims;
    }

    public boolean[] readBooleanArray(int key) throws IOException {
        int length = this.readInt();
        boolean[] prims = new boolean[length];
        int x = 0;
        while (x < length) {
            prims[x] = this.readBoolean();
            ++x;
        }
        return prims;
    }

    public static final boolean isArrayOfPrimitivesClass(Class clazz) {
        return IsengardObjectInputStream.getPrimitiveClassType(clazz) != 0;
    }

    public static int getPrimitiveClassType(Class clazz) {
        if (clazz == int[].class) {
            return 75;
        }
        if (clazz == boolean[].class) {
            return 76;
        }
        if (clazz == byte[].class) {
            return 79;
        }
        if (clazz == long[].class) {
            return 77;
        }
        if (clazz == double[].class) {
            return 78;
        }
        if (clazz == char[].class) {
            return 82;
        }
        if (clazz == float[].class) {
            return 80;
        }
        if (clazz == short[].class) {
            return 81;
        }
        return 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.fIn.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.fIn.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.fIn.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.fIn.readFloat();
    }

    @Override
    public int readInt() throws IOException {
        return this.fIn.readInt();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.fIn.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.fIn.readUnsignedShort();
    }

    @Override
    public long readLong() throws IOException {
        return this.fIn.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.fIn.readShort();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.fIn.readBoolean();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.fIn.skipBytes(n);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.fIn.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fIn.readFully(b, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.fIn.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        if (this.fStreamVersion == 1) {
            return this.fIn.readUTF();
        }
        return this.readReferencedString();
    }

    private String readReferencedString() throws IOException {
        byte code = this.readByte();
        int id = this.readInt();
        if (code == 89) {
            String s = (String)this.fStreamState.fCachedStrings.get(id);
            if (s == null) {
                s = "";
            }
            return s;
        }
        String s = this.fIn.readUTF();
        this.fStreamState.fCachedStrings.put(id, s);
        return s;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public ISerializationHandler getSerializationHandler() {
        return this.fSerializationHandler;
    }

    private void printObjectMap() {
        Iterator it = this.fStreamState.fObjectMap.entrySet().iterator();
        StringBuffer buf = new StringBuffer("Dumping contents of fObjectMap:\n");
        while (it.hasNext()) {
            IntHashMap.Entry entry = (IntHashMap.Entry)it.next();
            buf.append(entry.getKey());
            buf.append(" -> ");
            try {
                buf.append(entry.getValue());
            }
            catch (Exception exception) {
                buf.append("?");
            }
            buf.append("\n");
        }
        this.getFeedbackChannel().info(sModule, buf.toString());
    }

    public void setLastMessageSourceAddress(Address sourceAddress) {
        this.fLastMessageSourceAddress = sourceAddress;
    }

    public Address getLastMessageSourceAddress() {
        return this.fLastMessageSourceAddress;
    }

    public int getStreamVersion() {
        return this.fStreamVersion;
    }

    public final class ClassDescriptor {
        public boolean fIsConstructorExternalizable;
        public boolean fIsStaticConstructor;
        public boolean fReadResolve;
        public Class fClass;
        public Constructor fDeserializeConstructor;

        public ClassDescriptor(Class clazz) {
            this.fClass = clazz;
            this.fIsConstructorExternalizable = IConstructorExternalizable.class.isAssignableFrom(clazz);
            if (!this.fIsConstructorExternalizable) {
                this.fIsStaticConstructor = IIsengardStaticExternalizable.class.isAssignableFrom(clazz);
            }
            this.fReadResolve = IIsengardReadResolve.class.isAssignableFrom(clazz);
        }

        public boolean isStaticConstructor() {
            return this.fIsStaticConstructor;
        }

        public Constructor getDeserializeConstructor() throws SecurityException, NoSuchMethodException {
            if (this.fDeserializeConstructor == null) {
                this.fDeserializeConstructor = this.fIsConstructorExternalizable ? this.fClass.getConstructor(ObjectInput.class) : this.fClass.getConstructor(kZeroLengthClassArray);
                try {
                    this.fDeserializeConstructor.setAccessible(true);
                }
                catch (Throwable throwable) {}
            }
            return this.fDeserializeConstructor;
        }

        public boolean isConstructorExternalizable() {
            return this.fIsConstructorExternalizable;
        }

        public boolean isReadResolve() {
            return this.fReadResolve;
        }

        public Class getUnderlyingClass() {
            return this.fClass;
        }
    }

    private static class StreamState {
        public IntHashMap fObjectMap = new IntHashMap();
        public IntHashMap fCachedObjects = new IntHashMap();
        public IntHashMap fCachedStrings = new IntHashMap();
        public Object fLastClassDeserialized = new Object();
        public int fCurrentObjectGraphLength = -1;
        public int fNestedObjectCount;
        public Object fTopLevelObject;
    }
}

