/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Channel;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postofficehub.DeliveryItem;
import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.AMessageDeliveryTask;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectOutputStream;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.text.MessageFormat;

public class OutgoingMessageDeliveryTask
extends AMessageDeliveryTask {
    private static final long kCacheResetInterval = 14400000L;
    private static Module sModule = new Module("OutgoingMessageDeliveryTask");
    private final IsengardObjectOutputStream fObjectOutput;
    private final Channel fMessageChannel;
    private long fNextCacheResetTime;

    public OutgoingMessageDeliveryTask(IsengardObjectOutputStream objectOutput, ABaseTransport transport, boolean flushOnDelivery) {
        super(transport, sModule);
        this.fObjectOutput = objectOutput;
        this.fMessageChannel = transport.getTransmitChannel();
        this.setContinueDelivery();
        this.fNextCacheResetTime = MasterClock.currentTimeMillis() + 14400000L;
    }

    @Override
    public int deliverNextMessage(boolean waitForData) {
        int pollTime = waitForData ? 100 : 0;
        long startTime = 0L;
        int startAtQueueSize = 0;
        if (this.fIsTraceEnabled) {
            startAtQueueSize = ((BoundedLinkedQueue)this.fMessageChannel).size();
            startTime = System.currentTimeMillis();
        }
        int numHandled = this.deliverNextMessageInternal(pollTime);
        if (this.fIsTraceEnabled && numHandled >= ((BoundedLinkedQueue)this.fMessageChannel).capacity()) {
            long totalTime = System.currentTimeMillis() - startTime;
            String msg = MessageFormat.format("Processing the total queue element {0} average time {1} total time: {2} for client {3} start queue size {4}", Integer.toString(numHandled), Long.toString(numHandled != 0 ? totalTime / (long)numHandled : 0L), Long.toString(totalTime), this.getTransport().getRouteConnectionInfo(), Integer.toString(startAtQueueSize));
            this.getFeedbackChannel().trace(sModule, msg);
        }
        return numHandled;
    }

    private int deliverNextMessageInternal(int pollTime) {
        DeliveryItem item = null;
        IsengardObjectOutputStream objectOutput = this.fObjectOutput;
        int numHandled = 0;
        int interruptedExceptionCount = 0;
        boolean tryAgain = true;
        block5: while (tryAgain) {
            MessageUndeliverableMessage reportError;
            tryAgain = false;
            try {
                boolean wroteData = false;
                item = (DeliveryItem)this.fMessageChannel.poll(pollTime);
                while (true) {
                    if (item == null) {
                        if (!wroteData) continue block5;
                        objectOutput.flush();
                        continue block5;
                    }
                    if (item.fMessage.getShouldTrace()) {
                        this.getFeedbackChannel().info("Address " + this.getTransport().getRouteConnectionInfo() + " Serializing message: " + item.fMessage);
                    }
                    objectOutput.writeObject(item.fAddress);
                    objectOutput.writeObject(item.fMessage);
                    objectOutput.reset();
                    ++numHandled;
                    wroteData = true;
                    if (MasterClock.currentTimeMillis() > this.fNextCacheResetTime) {
                        objectOutput.resetCache();
                        this.fNextCacheResetTime = MasterClock.currentTimeMillis() + 14400000L;
                        this.getFeedbackChannel().debug("Clearing Isengard object cache");
                    }
                    if (this.fIsTraceEnabled) {
                        this.getFeedbackChannel().trace(sModule, "Socket Sent " + item.fMessage.toString(item.fAddress));
                    }
                    item = (DeliveryItem)this.fMessageChannel.poll(0L);
                }
            }
            catch (ObjectStreamException e) {
                this.getFeedbackChannel().error(sModule, "Caught an exception writing to connected hub.", e);
                if (item != null && item.fCallerStackTrace != null) {
                    this.getFeedbackChannel().error(sModule, "Message call trace:", item.fCallerStackTrace);
                }
                reportError = new MessageUndeliverableMessage(item.fMessage, item.fAddress, "Caught Exception", e);
                this.getTransport().routeMessage(reportError, item.fMessage.getSourceAddress());
                this.setStopDelivery();
            }
            catch (InterruptedException e) {
                if (this.isTransportClosed()) {
                    if (this.fIsTraceEnabled) {
                        this.getFeedbackChannel().trace(sModule, "Stopping Delivery of outgoing message to " + this.getTransport().getRouteConnectionInfo(), e);
                    }
                    this.setStopDelivery();
                }
                if (++interruptedExceptionCount == 100) {
                    this.getFeedbackChannel().error(String.valueOf(OutgoingMessageDeliveryTask.class.getName()) + " running in tight loop. Already caught " + interruptedExceptionCount + " exceptions while sending outgoing message to " + this.getTransport().getRouteConnectionInfo() + ". Further exceptions will not be logged.", e);
                }
                tryAgain = true;
            }
            catch (IOException e) {
                if (this.getFeedbackChannel().isDebugEnabled()) {
                    this.getFeedbackChannel().debug(sModule, "Caught an exception writing to connected hub.", e);
                    if (item != null && item.fCallerStackTrace != null) {
                        this.getFeedbackChannel().debug(sModule, "Message call trace:", item.fCallerStackTrace);
                    }
                }
                this.setStopDelivery();
            }
            catch (RuntimeException e) {
                this.getFeedbackChannel().error(sModule, "Caught a RuntimeException writing to connected hub.", e);
                if (item != null && item.fCallerStackTrace != null) {
                    this.getFeedbackChannel().error(sModule, "Message call trace:", item.fCallerStackTrace);
                }
                reportError = new MessageUndeliverableMessage(item.fMessage, item.fAddress, "Caught Exception", e);
                this.getTransport().routeMessage(reportError, item.fMessage.getSourceAddress());
                this.setStopDelivery();
            }
        }
        return numHandled;
    }
}

