/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.IMessageDeliveryStrategy;
import com.wily.isengard.postofficehub.link.v1.IncomingRouteConnector;
import com.wily.isengard.postofficehub.link.v1.OutgoingRouteConnector;
import java.io.IOException;

public class SessionBasedMessageDeliveryStrategy
implements IMessageDeliveryStrategy {
    private final ABaseTransport fTransport;
    private final PostOfficeHub fHub;
    private IncomingRouteConnector fIncomingConnector;
    private OutgoingRouteConnector fOutgoingConnector;

    public SessionBasedMessageDeliveryStrategy(ABaseTransport transport) {
        this.fTransport = transport;
        this.fHub = transport.getPostOfficeHub();
    }

    @Override
    public void setUp(String incomingThreadNameFragment, String outgoingNameFragment, boolean outgoingConnection) throws IOException {
        if (outgoingConnection) {
            this.fOutgoingConnector = new OutgoingRouteConnector(this.fTransport, 2, this.fHub.getKeyedClassLoader());
            this.fOutgoingConnector.start(this.fTransport.getThreadFactory(), outgoingNameFragment);
            this.fIncomingConnector = new IncomingRouteConnector(this.fTransport, this.fHub.getKeyedClassLoader());
            this.fIncomingConnector.start(this.fTransport.getThreadFactory(), incomingThreadNameFragment);
        } else {
            this.fIncomingConnector = new IncomingRouteConnector(this.fTransport, this.fHub.getKeyedClassLoader());
            this.fIncomingConnector.start(this.fTransport.getThreadFactory(), incomingThreadNameFragment);
            int version = this.fIncomingConnector.getInputStreamVersion();
            this.fOutgoingConnector = new OutgoingRouteConnector(this.fTransport, version, this.fHub.getKeyedClassLoader());
            this.fOutgoingConnector.start(this.fTransport.getThreadFactory(), outgoingNameFragment);
        }
        boolean errorOnIncoming = this.fIncomingConnector.blockUntilRouteEstablished();
        boolean errorOnOutgoing = this.fOutgoingConnector.blockUntilRouteEstablished();
        if (errorOnIncoming || errorOnOutgoing) {
            throw new IOException("An error occurred when establishing the route connectors.");
        }
    }

    @Override
    public void tearDown() {
        if (this.fOutgoingConnector != null) {
            this.fOutgoingConnector.stop(2000);
        }
    }
}

