/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.ref.WeakReference;

public final class WrappedObjectToWrapperMappingTracer
extends ASingleInstanceTracerFactory {
    private static Module module = new Module("StatementToSQLMappingTracer");
    private static IModuleFeedbackChannel fFeedback;
    private static final IWeakIdentityMap wrappedToWrapperMap;
    public static final String kParameterIndexKey = "parameterindex";
    private final int parameterIndex = this.getIntegerParameter("parameterindex", 0);

    public WrappedObjectToWrapperMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.getInvocationParameterCount() > 0) {
            Object wrapper = data.getInvocationObject();
            Object actual = data.getInvocationParameterAsObject(this.parameterIndex);
            wrappedToWrapperMap.putWeak(actual, new WeakReference<Object>(wrapper));
            if (actual != null && fFeedback.isDebugEnabled(module)) {
                String message = "saved mapping from original statement to wrapper statement: %s (type %s) --> %s (type %s)";
                fFeedback.debug(module, String.format(message, actual.toString(), actual.getClass().getName(), String.valueOf(wrapper), wrapper.getClass().getName()));
            }
        }
    }

    public static Object getWrapper(Object wrapped) {
        Object wrapper;
        WeakReference ref = (WeakReference)wrappedToWrapperMap.getWeak(wrapped);
        Object object = wrapper = ref != null ? (Object)ref.get() : null;
        if (fFeedback.isDebugEnabled(module)) {
            String message = wrapper == null ? String.format("could not find wrapper statement for original statement: %s (type %s)", wrapped.toString(), wrapped.getClass().getName()) : String.format("found mapping from original statement to wrapper statement: %s (type %s) --> %s (type %s)", wrapped.toString(), wrapped.getClass().getName(), String.valueOf(wrapper), wrapper.getClass().getName());
            fFeedback.debug(module, message);
        }
        return wrapper;
    }

    static {
        IConcurrentMapFactory factory = null;
        try {
            factory = AgentShim.getAgent().IAgent_getConcurrentMapFactory();
            fFeedback = AgentShim.getAgent().IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
        wrappedToWrapperMap = factory == null ? null : factory.getConcurrentWeakIdentityMap("SQLWrappedObjectToWrapperMap");
    }
}

