/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.acc.agent;

import com.wily.introscope.acc.agent.AccService;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.util.AgentJarPathFinder;
import com.wily.introscope.agent.util.AgentProcessId;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.IConfigurationListener;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

class RegisterAgentWithController
implements ITimestampedRunnable {
    public static final String kComWilyBuild = "com-wily-Build";
    public static final String kComWilyRelease = "com-wily-Release";
    public static final int kSocketTimeout = 4000;
    private static final int kHandkshakeSize = 40;
    private static final String kUnknown = "unknown";
    private static final String SYSTEM_KEYS_LIST_KEY = "introscope.agent.acc.system.properties.list";
    private static final String SYSTEM_KEYS_LIST_DEFAULT_VALUE = "java.home,java.vendor,java.version,java.class.path,file.separator,line.separator,path.separator,os.arch,os.name,os.version,user.dir,user.home,com.wily.introscope.agentProfile,introscope.agent.bootstrap.home,introscope.core.agent.jar.path,introscope.agent.bootstrap.release.version,introscope.agent.bootstrap.version.loaded,introscope.agent.bootstrap.versions.available";
    private final String[] systemPropKeys;
    private volatile boolean fRegistered = false;
    private IAgent fAgent;
    private IModuleFeedbackChannel logger;
    private Module kACCMonitor = new Module("AccMonitorRunnable");
    private int fPort;
    private String fLastName = "";
    private long fNextPing;
    private int fHeartBeat;
    private int fLastMetricCount = 0;
    private String fAgentVersion;
    private AgentType fAgentType;
    private String fAgentInstallPath;
    private String fPID;
    private boolean fListenersAdded = false;
    private AccService parent;
    private IRegisteredBehavior fPingerBehavior = null;
    private boolean fPingerStarted = false;
    private boolean logRegistrationFailure = true;
    final INameChangeListener listener1 = new INameChangeListener(){

        public void INameChangeListener_nameChanged(String newName) {
            if (!newName.equals(RegisterAgentWithController.this.fLastName)) {
                RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, String.format("Name change notification has occurred (%s), will re-register", newName));
                RegisterAgentWithController.this.requestReRegistration();
            }
        }
    };
    final IServerConnectionNotification notifier1 = new IServerConnectionNotification(){

        public void connectionDown() {
            RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Isengard connection down");
        }

        public void connectionUp() {
            RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Isengard connection up, will (re)register");
            RegisterAgentWithController.this.requestReRegistration();
        }
    };
    final IConfigurationListener configListener = new IConfigurationListener(){

        public void onChange(IndexedProperties arg0) {
            RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Agent properties have changed, will (re)register");
            RegisterAgentWithController.this.requestReRegistration();
        }
    };
    final ITimestampedRunnable pinger = new ITimestampedRunnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ITimestampedRunnable_execute(long arg0) {
            String[] names;
            boolean doDebug = RegisterAgentWithController.this.logger.isDebugEnabled(RegisterAgentWithController.this.kACCMonitor);
            if (doDebug) {
                RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Trying to ping ACC Controller");
            }
            if ((names = RegisterAgentWithController.this.fAgent.IAgent_getHostProcessAgentTriplet()) == null || names[0] == null || names[1] == null || names[2] == null) {
                if (doDebug) {
                    RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Agent name triplet not fully set (skipping communication with ACC Controller Agent)");
                }
                return;
            }
            Socket sock = null;
            BufferedWriter sockWriter = null;
            try {
                boolean pingSupported;
                sock = RegisterAgentWithController.this.createSocket(RegisterAgentWithController.this.fPort);
                InputStream sockInput = sock.getInputStream();
                OutputStream sockOutput = sock.getOutputStream();
                String version = RegisterAgentWithController.this.getServerVersion(sockInput, RegisterAgentWithController.this.fPort);
                boolean bl = pingSupported = version != null && !version.equals("1.0");
                if (!pingSupported && doDebug) {
                    RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "ACC Controller version does not support 'ping'");
                }
                sockWriter = new BufferedWriter(new OutputStreamWriter(sockOutput, Charset.forName("UTF-8")));
                if (version != null) {
                    StringBuilder json = new StringBuilder("{\"version\":\"2.0\",\"type\":\"" + RegisterAgentWithController.this.getAgentTypeAsString() + "\",\"" + "extType" + "\":\"" + RegisterAgentWithController.this.getAgentExtTypeAsString() + "\",\"" + "properties" + "\":{");
                    json.append(RegisterAgentWithController.this.encode("acc.agent.msgtype") + ":" + RegisterAgentWithController.this.encode("ping") + ",");
                    json.append(RegisterAgentWithController.this.encode("acc.agent.hostname") + ":" + RegisterAgentWithController.this.encode(names[0]) + ",");
                    json.append(RegisterAgentWithController.this.encode("acc.agent.processname") + ":" + RegisterAgentWithController.this.encode(names[1]) + ",");
                    json.append(RegisterAgentWithController.this.encode("acc.agent.name") + ":" + RegisterAgentWithController.this.encode(names[2]) + ",");
                    json.append(RegisterAgentWithController.this.encode("acc.agent.pid") + ":" + RegisterAgentWithController.this.encode(RegisterAgentWithController.this.fPID) + "}}");
                    sockWriter.write(json.toString());
                    sockWriter.flush();
                    sock.shutdownOutput();
                    if (pingSupported) {
                        boolean controllerKnowsMe = RegisterAgentWithController.this.getRegistrationResult(sockInput);
                        if (!controllerKnowsMe) {
                            RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "ACC Controller is not aware of the agent, re-registering");
                            RegisterAgentWithController.this.fRegistered = false;
                        } else if (doDebug) {
                            RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "ACC Controller is aware of the agent");
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (doDebug) {
                    RegisterAgentWithController.this.logger.debug(RegisterAgentWithController.this.kACCMonitor, "Unable to send ping message to ACC Controller - it has probably been stopped temporarily", (Throwable)ex);
                }
            }
            finally {
                try {
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (sockWriter != null) {
                        sockWriter.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    };

    public void startPinger() {
        if (this.fPingerBehavior == null) {
            this.logger.debug(this.kACCMonitor, "Starting 1 minute ACC ping");
            this.fPingerBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(this.pinger, "RegisterAgentWithController Bean2", true, 60000L, false);
            this.fPingerStarted = true;
        }
    }

    public IRegisteredBehavior getPingerBehaviour() {
        return this.fPingerBehavior;
    }

    public boolean checkAgentListenerState() {
        if (this.fListenersAdded) {
            return this.fListenersAdded;
        }
        IsengardServerConnectionManager m = this.fAgent.IAgent_getIsengardServerConnection();
        if (m != null && m.getConnectedServer() != null && m.getConnectedServer().isConnected()) {
            this.fAgent.IAgent_addNameChangeListener(this.listener1);
            this.fAgent.IAgent_addNegotiatedNameChangeListener(this.listener1);
            this.fAgent.IAgent_getIsengardServerConnection().addConnectionObserver(this.notifier1);
            this.fAgent.addConfigurationListener(this.configListener);
            this.fListenersAdded = true;
            this.logger.debug(this.kACCMonitor, "EM connection estabilished, reverting to normal poll interval");
            this.parent.resetRegistrationPoller();
            return true;
        }
        return this.fListenersAdded;
    }

    RegisterAgentWithController(IAgent agent, AccService caller, int port, int heartbeat) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
        this.fPort = port;
        this.fHeartBeat = heartbeat;
        this.fAgentType = this.calculateAgentType();
        this.fAgentInstallPath = this.calculateAgentPath();
        this.fAgentVersion = this.getAgentVersion();
        this.fPID = AgentProcessId.get();
        this.parent = caller;
        this.systemPropKeys = this.fAgent.IAgent_getIndexedProperties().getProperty(SYSTEM_KEYS_LIST_KEY, SYSTEM_KEYS_LIST_DEFAULT_VALUE).split(",");
    }

    public void close() {
        if (this.fListenersAdded) {
            this.fAgent.IAgent_removeNameChangeListener(this.listener1);
            this.fAgent.IAgent_removeNegotiatedNameChangeListener(this.listener1);
            this.fAgent.IAgent_getIsengardServerConnection().removeConnectionObserver(this.notifier1);
            this.fAgent.removeConfigurationListener(this.configListener);
            this.fListenersAdded = false;
        }
        if (this.fPingerStarted) {
            this.fPingerBehavior.close();
            this.fPingerStarted = false;
            this.fPingerBehavior = null;
        }
    }

    public boolean getListenersAdded() {
        return this.fListenersAdded;
    }

    public int getPort() {
        return this.fPort;
    }

    public void setPort(int p) {
        this.fPort = p;
    }

    public long getHeartBeat() {
        return this.fHeartBeat;
    }

    public long getLastMetricCount() {
        return this.fLastMetricCount;
    }

    public boolean getRegistered() {
        return this.fRegistered;
    }

    public boolean getPingerStarted() {
        return this.fPingerStarted;
    }

    protected void calculateNextPing() {
        this.fNextPing = System.currentTimeMillis() + (long)(this.fHeartBeat * 60 * 1000) - 15000L;
    }

    public void setHeartBeat(int hb) {
        this.fHeartBeat = hb;
        this.calculateNextPing();
    }

    public long getNextPing() {
        return this.fNextPing;
    }

    public AgentType calculateAgentType() {
        AgentType at = AgentType.JAVA_AGENT;
        String cmd = System.getProperty("sun.java.command");
        String epaProps = System.getProperty("com.wily.introscope.epagent.properties");
        String javaAgentProps = System.getProperty("com.wily.introscope.agentProfile");
        if (cmd != null && cmd.contains("UnifiedMonitoringAgent")) {
            at = AgentType.UM_AGENT;
        } else if (epaProps != null) {
            at = AgentType.EP_AGENT;
        }
        this.logger.debug("Setting ACC agent type as '" + (Object)((Object)at) + "' EPA:[" + epaProps + "] JAVA:[" + javaAgentProps + "] CMD:[" + cmd + "]");
        return at;
    }

    public String getAgentTypeAsString() {
        switch (this.fAgentType) {
            case EP_AGENT: {
                return "ep-agent";
            }
            case UM_AGENT: {
                return "apmia";
            }
        }
        return "JavaAgent";
    }

    public String getAgentExtTypeAsString() {
        switch (this.fAgentType) {
            case EP_AGENT: {
                return "ep-agent";
            }
            case UM_AGENT: {
                return "apmia";
            }
        }
        return "java-agent";
    }

    public String calculateAgentPath() {
        String path = AgentJarPathFinder.calculateAgentHomePath();
        if (path == null) {
            return "";
        }
        return path;
    }

    public String getAgentVersion() {
        IntroscopeVersion version = new IntroscopeVersion(this.fAgent.IAgent_getStringLocalizer());
        return version.IVersion_getReleaseString() + " " + version.IVersion_getBuildNumberString();
    }

    protected Socket createSocket(int port) throws UnknownHostException, IOException {
        Socket sock = new Socket("localhost", port);
        sock.setSoTimeout(4000);
        return sock;
    }

    public int getMetricCount() {
        int count = 0;
        try {
            this.fLastMetricCount = count = this.fAgent.IAgent_getMetricRecordingAdministrator().getMetricCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return count;
    }

    public String getConnectorName() {
        try {
            return this.fAgent.IAgent_getIsengardServerConnection().getConnectedServer().getServerLocator().getHostName();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public int getConnectorPort() {
        try {
            return this.fAgent.IAgent_getIsengardServerConnection().getConnectedServer().getServerLocator().getPort();
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    protected String encode(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    protected boolean writeInformation(BufferedWriter out, String version, String type, String[] names) throws IOException {
        Properties local = new Properties();
        local.setProperty("acc.agent.msgtype", type);
        local.setProperty("acc.agent.installpath", this.fAgentInstallPath);
        local.setProperty("acc.agent.version", this.fAgentVersion);
        local.setProperty("acc.agent.hostname", names[0]);
        local.setProperty("acc.agent.processname", names[1]);
        local.setProperty("acc.agent.name", names[2]);
        local.setProperty("acc.agent.pid", this.fPID);
        if (this.fLastName.length() != 0) {
            local.setProperty("acc.agent.last.name", this.fLastName);
        }
        this.fLastName = names[2];
        local.setProperty("acc.agent.collector", this.getConnectorName());
        local.setProperty("acc.agent.collector.port", Integer.toString(this.getConnectorPort()));
        local.setProperty("acc.agent.metriccount", Integer.toString(this.getMetricCount()));
        if (!type.equals("metriccount")) {
            String manifestTxt;
            Properties pp;
            IndexedProperties p = this.fAgent.IAgent_getIndexedProperties();
            if (p != null) {
                local.putAll((Map<?, ?>)p);
            }
            if ((pp = System.getProperties()) != null && !pp.isEmpty()) {
                this.logger.trace(this.kACCMonitor, "System Properties: " + pp);
                local.putAll((Map<?, ?>)pp);
            } else {
                this.logger.trace(this.kACCMonitor, "System Properties are empty");
            }
            this.getAndAddSelectiveSystemProperties(this.systemPropKeys, local);
            Properties ppp = this.readBootstrapPolicy();
            if (ppp != null) {
                local.putAll((Map<?, ?>)ppp);
            }
            if ((manifestTxt = this.readManifestTxt()) != null) {
                local.setProperty("acc.manifest.txt", manifestTxt);
            }
        }
        StringBuilder json = new StringBuilder("{\"version\":\"" + version + "\",\"" + "type" + "\":\"" + this.getAgentTypeAsString() + "\",\"" + "extType" + "\":\"" + this.getAgentExtTypeAsString() + "\",\"" + "properties" + "\":{");
        Enumeration<?> e = local.propertyNames();
        int n = 0;
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (n != 0) {
                json.append(",");
            }
            json.append(this.encode(key) + ":" + this.encode(local.getProperty(key)));
            ++n;
        }
        json.append("}");
        if (!type.equals("metriccount")) {
            json.append(",\"environment\":{");
            n = 0;
            Map<String, String> env = System.getenv();
            for (String envName : env.keySet()) {
                if (n++ != 0) {
                    json.append(",");
                }
                json.append(this.encode(envName) + ":" + this.encode(env.get(envName)));
            }
            json.append("}");
        }
        json.append("}");
        out.write(json.toString());
        out.flush();
        this.logger.trace(this.kACCMonitor, "Sent json message to a ACC Controller Agent: " + json);
        return true;
    }

    private String readManifestTxt() {
        if (this.fAgentInstallPath != null) {
            File file = new File(this.fAgentInstallPath, "manifest.txt");
            try {
                return this.readFileToString(file, Charset.forName("UTF-8"));
            }
            catch (Exception e) {
                this.logger.trace(this.kACCMonitor, String.format("Exception while reading %s %s", "manifest.txt", file.getAbsolutePath()), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileToString(File file, Charset cs) throws IOException {
        BufferedReader reader = null;
        try {
            int n;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
            StringBuilder stringBuilder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((n = reader.read(buffer)) != -1) {
                stringBuilder.append(buffer, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.trace(this.kACCMonitor, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected boolean metricCountChanged() {
        int last = this.fLastMetricCount;
        return last != this.getMetricCount();
    }

    protected boolean getRegistrationResult(InputStream sockInput) throws IOException {
        byte[] result = new byte[1];
        int read = sockInput.read(result, 0, 1);
        return read == 1 && result[0] == 0;
    }

    protected String getServerVersion(InputStream sockInput, int port) {
        int read = 0;
        byte[] buffer = new byte[40];
        try {
            int c;
            for (read = 0; read < buffer.length && (c = sockInput.read()) != -1 && c != 10; ++read) {
                buffer[read] = (byte)c;
            }
        }
        catch (IOException e) {
            this.logger.trace(this.kACCMonitor, "Exception reading ACC Controller Agent version", (Throwable)e);
            return null;
        }
        String ack = new String(buffer, 0, read);
        String[] parts = ack.split(":");
        if (parts != null && parts.length == 2 && parts[0].equals("APMACC-Controller")) {
            return parts[1];
        }
        this.logger.warn(this.kACCMonitor, "Port " + port + " responding but is not the ACC Controller Agent");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readBootstrapPolicy() {
        String bsaHome = System.getProperty("introscope.agent.bootstrap.home");
        if (bsaHome != null) {
            Properties p = new Properties();
            File file = new File(bsaHome, "agent.policy");
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                p.load(is);
            }
            catch (Exception e) {
                this.logger.trace(this.kACCMonitor, "Exception while reading bootstrap agent policy " + file.getAbsolutePath(), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        this.logger.trace(this.kACCMonitor, e.getMessage(), (Throwable)e);
                    }
                }
            }
            return p;
        }
        return null;
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        boolean doDebug = this.logger.isDebugEnabled(this.kACCMonitor);
        boolean doTrace = this.logger.isTraceEnabled(this.kACCMonitor);
        if (doTrace) {
            this.logger.trace(this.kACCMonitor, "heartbeat");
        }
        if (!this.checkAgentListenerState()) {
            if (doDebug) {
                this.logger.debug(this.kACCMonitor, "Could not set agent state listeners, will not attempt to connect to ACC Controller Agent yet");
            }
            return;
        }
        long now = System.currentTimeMillis();
        if (!this.fRegistered) {
            this.registerWithController("registration");
        } else if (now > this.fNextPing) {
            this.registerWithController("heartbeat");
        } else if (this.metricCountChanged() && this.parent.hasPollingRateResetToNormal()) {
            this.logger.debug(this.kACCMonitor, "Sending metric count change notification");
            this.registerWithController("metriccount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWithController(String msgType) {
        boolean doDebug = this.logger.isDebugEnabled(this.kACCMonitor);
        boolean doTrace = this.logger.isTraceEnabled(this.kACCMonitor);
        String[] agentNames = this.fAgent.IAgent_getHostProcessAgentTriplet();
        if (agentNames == null || agentNames[0] == null || agentNames[1] == null || agentNames[2] == null) {
            if (doDebug) {
                this.logger.debug(this.kACCMonitor, "Agent name triplet not fully set (skipping communication with ACC Controller Agent)");
            }
            return;
        }
        Socket sock = null;
        InputStream sockInput = null;
        OutputStream sockOutput = null;
        BufferedWriter sockWriter = null;
        boolean registered = false;
        try {
            if (doDebug) {
                this.logger.debug(this.kACCMonitor, "Trying to contact ACC Controller Agent on port " + this.fPort);
            }
            sock = this.createSocket(this.fPort);
            sockInput = sock.getInputStream();
            sockOutput = sock.getOutputStream();
            String version = this.getServerVersion(sockInput, this.fPort);
            sockWriter = new BufferedWriter(new OutputStreamWriter(sockOutput, Charset.forName("UTF-8")));
            if (version != null && this.writeInformation(sockWriter, version, msgType, agentNames)) {
                sock.shutdownOutput();
                registered = this.getRegistrationResult(sockInput);
                if (doDebug) {
                    this.logger.debug(this.kACCMonitor, "Reply from ACC Controller Agent has been received: " + registered);
                }
                if (!msgType.equals("metriccount")) {
                    this.calculateNextPing();
                }
            }
        }
        catch (IOException ex) {
            if (doTrace) {
                this.logger.trace(this.kACCMonitor, "Exception thrown while contacting ACC Controller Agent - probably not running or not installed", (Throwable)ex);
            }
        }
        finally {
            block26: {
                try {
                    if (sockWriter != null) {
                        sockWriter.close();
                    }
                    if (sock != null) {
                        sock.close();
                    }
                }
                catch (IOException exC) {
                    if (!doTrace) break block26;
                    this.logger.trace(this.kACCMonitor, "Failed to close buffered writer or socket", (Throwable)exC);
                }
            }
        }
        if (registered) {
            this.fRegistered = true;
            this.logger.info(this.kACCMonitor, "Registered with ACC Controller Agent");
            this.logRegistrationFailure = true;
            this.startPinger();
        } else {
            this.fRegistered = false;
            if (this.logRegistrationFailure) {
                this.logger.warn(this.kACCMonitor, "Registration with ACC Controller Agent failed");
                this.logRegistrationFailure = false;
            } else if (doDebug) {
                this.logger.debug(this.kACCMonitor, "Could not register with ACC Controller Agent");
            }
        }
    }

    void requestReRegistration() {
        if (this.parent.hasPollingRateResetToNormal()) {
            this.logger.trace(this.kACCMonitor, "Registering agent in async mode");
            this.registerAsync();
        } else {
            this.logger.trace(this.kACCMonitor, "Requesting agent registration in next poll interval");
            this.fRegistered = false;
        }
    }

    void registerAsync() {
        this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long nowInMillis) {
                RegisterAgentWithController.this.registerWithController("registration");
            }
        }, "RegisterAgentWithControllerOnDemand Bean", true, 1000L, true, 1);
    }

    private void getAndAddSelectiveSystemProperties(String[] keys, Properties props) {
        for (String key : keys) {
            String value = System.getProperty(key);
            if (value == null) continue;
            props.put(key, value);
        }
    }

    public static enum AgentType {
        JAVA_AGENT,
        EP_AGENT,
        UM_AGENT;

    }
}

