/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.AbstractRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class CustomRulesFactory {
    private static volatile Set<Pattern> patternsOfPackagesToSkip = null;

    public static Rule createRuleToSelectChildOfCall() {
        return new AbstractRule(){
            private Set<Pattern> skipPkgPatterns = new HashSet<Pattern>(CustomRulesFactory.access$000());
            private Set<String> callerMethods = new HashSet<String>(CustomRulesFactory.access$100());

            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                IndexAwareTraceElement traceElement = trace[currentElementIndex];
                if (!CommonUtils.doesElementPackageMatch((IndexAwareTraceElement)traceElement, this.skipPkgPatterns) && !this.callerMethods.contains(traceElement.getMethodName())) {
                    return this.isCallerSpecialMethod(currentElementIndex + 1, trace);
                }
                return false;
            }

            private boolean isCallerSpecialMethod(int callerIndex, IndexAwareTraceElement[] trace) {
                if (callerIndex < 0 || callerIndex >= trace.length) {
                    return false;
                }
                IndexAwareTraceElement callerElement = trace[callerIndex];
                if (CommonUtils.doesElementPackageMatch((IndexAwareTraceElement)callerElement, this.skipPkgPatterns)) {
                    return false;
                }
                return this.callerMethods.contains(callerElement.getMethodName());
            }

            public String toString() {
                return CommonUtils.formatStringRep((String)("SelectChildOfNonJavaCallOrRunMethodRule, callerMethods:" + this.callerMethods));
            }
        };
    }

    public static Rule createRuleToSelectFirstNonJavaElement() {
        return new AbstractRule(){
            private Set<Pattern> skipPkgPatterns = new HashSet<Pattern>(CustomRulesFactory.access$000());

            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                IndexAwareTraceElement traceElement = trace[currentElementIndex];
                if (!CommonUtils.doesElementPackageMatch((IndexAwareTraceElement)traceElement, this.skipPkgPatterns)) {
                    return this.areAncestorsNonJavaElements(currentElementIndex, trace);
                }
                return false;
            }

            private boolean areAncestorsNonJavaElements(int currentElementIndex, IndexAwareTraceElement[] trace) {
                int parentIndex = currentElementIndex + 1;
                if (parentIndex >= trace.length || parentIndex < 0) {
                    return true;
                }
                IndexAwareTraceElement parentElement = trace[parentIndex];
                if (CommonUtils.doesElementPackageMatch((IndexAwareTraceElement)parentElement, this.skipPkgPatterns)) {
                    return this.areAncestorsNonJavaElements(parentIndex, trace);
                }
                return false;
            }

            public String toString() {
                return CommonUtils.formatStringRep((String)("SelectFirstNonJavaElementRule, skipPkgPatterns:" + this.skipPkgPatterns));
            }
        };
    }

    public static Rule createRuleToSkipNativeMethod() {
        return new AbstractFailFastRule(){

            public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
                return !trace[currentElementIndex].isNativeMethod();
            }

            public String toString() {
                return CommonUtils.formatStringRep((String)"SkipNativeMethodRule");
            }
        };
    }

    private static Set<String> getSpecialCallerMethodNames() {
        HashSet<String> specialMethods = new HashSet<String>();
        for (String str : "call,run".split(",")) {
            specialMethods.add(str);
        }
        return specialMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<Pattern> getPatternsForEssentialPackagesToSkip() {
        Set<Pattern> patterns = patternsOfPackagesToSkip;
        if (patterns != null) return patterns;
        Class<CustomRulesFactory> clazz = CustomRulesFactory.class;
        synchronized (CustomRulesFactory.class) {
            patterns = patternsOfPackagesToSkip;
            if (patterns != null) return patterns;
            HashSet<Pattern> packagesPatterns = new HashSet<Pattern>();
            Set<String> packagesToSkip = EntryPointDetectionConfiguration.getEssentialPackagesToSkip();
            if (packagesToSkip == null) return patterns;
            Iterator<String> iterator = packagesToSkip.iterator();
            while (iterator.hasNext()) {
                String pkg = iterator.next();
                pkg = CommonUtils.convertToPackageRegex((String)pkg);
                packagesPatterns.add(Pattern.compile(pkg, 2));
            }
            patternsOfPackagesToSkip = packagesPatterns;
            return patternsOfPackagesToSkip;
        }
    }

    static /* synthetic */ Set access$000() {
        return CustomRulesFactory.getPatternsForEssentialPackagesToSkip();
    }

    static /* synthetic */ Set access$100() {
        return CustomRulesFactory.getSpecialCallerMethodNames();
    }
}

