/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class JNDIMBeanServerLocator
implements IMBeanServerLocator {
    private static final String JMX = "jmx";
    private final IAgent fAgent;
    private MBeanServer fMBeanServer;

    public JNDIMBeanServerLocator(IAgent agent) {
        this.fAgent = agent;
    }

    @Override
    public MBeanServer[] IMBeanServerLocator_locate() {
        if (this.fMBeanServer != null) {
            return new MBeanServer[]{this.fMBeanServer};
        }
        try {
            InitialContext initCtx = new InitialContext();
            this.fMBeanServer = (MBeanServer)initCtx.lookup(JMX);
            return new MBeanServer[]{this.fMBeanServer};
        }
        catch (NamingException ex) {
            this.fAgent.IAgent_getModuleFeedback().debug("Failed to lookup MBeanServer instance via JNDI.  Ensure \"jmx\" and \"tc~jmx\" components have been deployed: " + ex.toString());
            return new MBeanServer[0];
        }
    }
}

