/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import java.util.Map;
import java.util.regex.Pattern;

public class SkipClassRule
extends AbstractFailFastRule {
    private final Pattern classNamePattern;

    public SkipClassRule(String classNameRegex) {
        this.classNamePattern = Pattern.compile(classNameRegex, 2);
    }

    @Deprecated
    public boolean apply(StackTraceElement element, Map<String, String> parameters) {
        boolean noAnnoyInnerClass = true;
        String className = element.getClassName();
        if (className.contains("$")) {
            String innerClassName = className.substring(className.indexOf("$") + 1);
            noAnnoyInnerClass = !innerClassName.matches("\\d+");
        }
        return noAnnoyInnerClass;
    }

    @Override
    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = true;
        if (this.classNamePattern != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            passes = !this.classNamePattern.matcher(traceElement.getClassName()).matches();
        }
        return passes;
    }

    @Override
    public String toString() {
        return CommonUtils.formatStringRep(this.getClass().getSimpleName() + ", classNamePattern:" + this.classNamePattern);
    }
}

