/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.blame.IFactoryLevelParameterCallback;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.automatic.AutoTracingCollectStatus;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IParamsProviderElement;
import com.wily.introscope.agent.trace.cas.ISkipDeepTraceElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.ErrorElementsParameterContainer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentErrorFeature;
import com.wily.introscope.agent.trace.intelligent.IInstrumentationLevelChangeStatusManager;
import com.wily.introscope.agent.trace.intelligent.ITcdMap;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.NullInstrumentationLevelChangeStatusManager;
import com.wily.introscope.agent.trace.intelligent.TcdMap;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.adt.ObjectInternLRUCache;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IntelligentTransactionHarvesterHelper {
    private static IInstrumentationLevelChangeStatusManager sInstrumentationStatusManager = new NullInstrumentationLevelChangeStatusManager();

    public static void setInstrumentationLevelChangeStatusManager(IInstrumentationLevelChangeStatusManager manager) {
        sInstrumentationStatusManager = manager;
    }

    public static IInstrumentationLevelChangeStatusManager getInstrumentationLevelChangeStatusManager() {
        return sInstrumentationStatusManager;
    }

    public static ITcdMap harvestTcdFromNormalTracer(IStackElement stckElement, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, ObjectInternLRUCache<String> stringIntern, int maxNumberTcdElements) {
        IIntelligentInstrumentationStackElement ttTopOfStack;
        if (stringIntern == null) {
            stringIntern = ObjectInternLRUCache.identidy();
        }
        if ((ttTopOfStack = deepStack.sIntelligentThreadLocalObject.fTopOfStackForTT) == null) {
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(deepStack.sIntelligentThreadLocalObject);
            return null;
        }
        List<ITransactionInstance> trace = stckElement.getTransactionInstanceList();
        ArrayList socketParamsToTcdParams = new ArrayList();
        boolean isRoot = true;
        if (maxNumberTcdElements <= 0) {
            maxNumberTcdElements = Integer.MAX_VALUE;
        }
        ITcdMap normalTcdHash = TcdMap.create(Math.min(trace.size() / 2, maxNumberTcdElements));
        HashSet<SocketTransactionElement> socketTxnElementsWhichHaveMaskingBackends = new HashSet<SocketTransactionElement>();
        ArrayList<TransactionHarvestHelper.SocketRedundancyCheckPostProcessingTask> socketRedundancyCheckPostProcessingTasks = new ArrayList<TransactionHarvestHelper.SocketRedundancyCheckPostProcessingTask>();
        for (int position = trace.size() - 1; position >= 0; --position) {
            ProbeInformation fInfo;
            InvocationData theData;
            BlameTransactionElement last;
            ITransactionInstance tend = trace.get(position);
            if (tend == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(deepStack.sIntelligentThreadLocalObject);
                return null;
            }
            ITransactionElement te = tend.getTransactionElement();
            if (te == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(deepStack.sIntelligentThreadLocalObject);
                return null;
            }
            if (!(te instanceof BlameTransactionElement) || (last = (BlameTransactionElement)te).isStartTrace()) continue;
            ITransactionInstance tStart = tend.getStartInstance();
            if (tStart == null) {
                IntelligentTransactionHarvesterHelper.cleanupAfterTT(deepStack.sIntelligentThreadLocalObject);
                return null;
            }
            long startTrace = tStart.getData().getWallClockStartTime();
            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-tt-starttime", startTrace);
            long duration = tend.getDuration();
            if (duration < 0L) {
                Assertion.wilyAssert(duration >= 0L, "The duration should be bigger than zero");
                duration = 0L;
            }
            TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(stringIntern.intern(last.getComponentName()), startTrace, duration, new InternedParamsMap<String>(stringIntern));
            Map<String, String> parameters = component.getParameters();
            IStackElement sElem = tStart.getData();
            if (isRoot) {
                if (sElem instanceof InvocationData) {
                    theData = (InvocationData)sElem;
                    isRoot = false;
                    int invocationId = theData.getInvocationId();
                    if (invocationId != ttTopOfStack.getStackElementId()) {
                        IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
                        if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                            agent.IAgent_getModuleFeedback().debug("Unable to match Intelligent Instrumentation trace data with InvocationData");
                        }
                        IntelligentTransactionHarvesterHelper.cleanupAfterTT(deepStack.sIntelligentThreadLocalObject);
                        return null;
                    }
                    IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, invocationId, component);
                    TransactionHarvestHelper.includeRootParams(parameters, theData);
                } else {
                    IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
                    if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        agent.IAgent_getModuleFeedback().debug("Unable to merge 1st element of transaction trace ");
                    }
                }
            } else if (sElem instanceof InvocationData) {
                theData = (InvocationData)sElem;
                int invocationId = theData.getInvocationId();
                if (normalTcdHash.size() >= maxNumberTcdElements && normalTcdHash.get(invocationId) == null) break;
                IntelligentTransactionHarvesterHelper.addToNormalTcdMap(normalTcdHash, invocationId, component);
            }
            IStackElement dataElement = tend.getData();
            if (dataElement == null) continue;
            if (last instanceof WilyTransactionElement && dataElement instanceof InvocationData && (fInfo = ((InvocationData)dataElement).getProbeInformation()) != null) {
                parameters.put("Resource Name", component.getResource());
                IntelligentTransactionHarvesterHelper.decorateComponentWithProbeInfo(parameters, fInfo);
            }
            VirtualStack.addParameterCallbacks(parameters, dataElement);
            dataElement.addParameterCallbacks(parameters);
            String error = (String)dataElement.get("Exception");
            String errMsg = (String)dataElement.get("Error Message");
            if (error != null) {
                parameters.put("Exception", error);
            }
            if (errMsg != null) {
                parameters.put("Error Message", errMsg);
            }
            if (last.isBackend()) {
                TransactionHarvestHelper.includeSocketParams(parameters, dataElement, socketTxnElementsWhichHaveMaskingBackends, null);
                continue;
            }
            if (dataElement.getAppMapSocketCursors() == null) continue;
            socketRedundancyCheckPostProcessingTasks.add(new TransactionHarvestHelper.SocketRedundancyCheckPostProcessingTask(dataElement, parameters));
        }
        TransactionHarvestHelper.removeRedundantSocketDecorationByPostProcessing(socketTxnElementsWhichHaveMaskingBackends, socketRedundancyCheckPostProcessingTasks);
        return normalTcdHash;
    }

    private static void addToNormalTcdMap(ITcdMap normalTcdHash, int id, TransactionComponentData component) {
        TransactionComponentData d = normalTcdHash.get(id);
        if (d == null) {
            normalTcdHash.put(id, component);
        } else {
            d.getLeftmostLeafOrSelf().setSubNodes(new TransactionComponentData[]{component});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean harvestTransaction(final IStackElement stckElement, HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, final boolean isAutoTrace, int maxNumberTcdElementsFromNormalTracer) {
        boolean result = true;
        try {
            ITcdMap normalTcdHash = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(stckElement, deepStack, null, maxNumberTcdElementsFromNormalTracer);
            if (normalTcdHash == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = IntelligentTransactionHarvesterHelper.harvestFromHpTracerWithNormalTcdMap(deepStack, normalTcdHash, new TCDPreSendCallback(){

                @Override
                public TransactionComponentData beforeSending(TransactionComponentData tcd) {
                    IntelligentTransactionHarvesterHelper.decorateRootComponent(tcd, stckElement, isAutoTrace);
                    return tcd;
                }
            });
            return bl;
        }
        catch (Exception e) {
            IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            if (feedback.isWarningEnabled(HighPerformanceIntelligenceStackElement.kModule)) {
                feedback.warn(HighPerformanceIntelligenceStackElement.kModule, "An exception occurred during transaction harvesting: " + e.getMessage());
            }
            if (feedback.isTraceEnabled()) {
                feedback.trace(HighPerformanceIntelligenceStackElement.kModule, "An exception occurred during transaction harvesting", e);
            }
            result = false;
        }
        finally {
            deepStack.tearMeDown();
        }
        return result;
    }

    public static final boolean harvestFromHpTracerWithNormalTcdMap(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, ITcdMap normalTcdHash, TCDPreSendCallback beforeSendingCallback) {
        if (!deepStack.markSentToEM()) {
            return true;
        }
        TransactionComponentData root = IntelligentTransactionHarvesterHelper.harvestFromHpTracerIntoTcds(deepStack, normalTcdHash, 0, null, beforeSendingCallback);
        if (root == null) {
            return false;
        }
        IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
        agent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(root);
        return true;
    }

    public static TransactionComponentData harvestFromHpTracerIntoTcds(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, ITcdMap normalTcdHash, int limit, ObjectInternLRUCache<String> stringIntern, TCDPreSendCallback beforeSendingCallback) {
        TransactionComponentData bizDefComponent;
        if (stringIntern == null) {
            stringIntern = ObjectInternLRUCache.identidy();
        }
        IntelligentInstrumentationThreadLocalObject tlObj = deepStack.sIntelligentThreadLocalObject;
        if (normalTcdHash == null) {
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return null;
        }
        IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
        IIntelligentInstrumentationStackElement ttTopOfStack = tlObj.fTopOfStackForTT;
        if (ttTopOfStack == null) {
            if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                agent.IAgent_getModuleFeedback().debug("No method in stack, cannot report transaction trace.");
            }
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return null;
        }
        deepStack.prepareOnStartHarvestTransaction();
        deepStack.prepareTcdStorage();
        IntelligentTransactionHarvesterHelper.harvestTransactionFromIntelligentInstrumentationWithThrottle(deepStack, ttTopOfStack, normalTcdHash, stringIntern, limit);
        TransactionComponentData root = ttTopOfStack.getTransactionComponentData();
        if (root == null) {
            if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                agent.IAgent_getModuleFeedback().debug("No method in stack after harvest, cannot report transaction trace.");
            }
            IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
            return null;
        }
        if (!root.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(root)) != null) {
            root = bizDefComponent;
        }
        if (beforeSendingCallback != null) {
            root = beforeSendingCallback.beforeSending(root);
        }
        IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation(root, null);
        deepStack.doOnTraceSendEvent();
        IntelligentTransactionHarvesterHelper.cleanupAfterTT(tlObj);
        return root;
    }

    private static void decorateRootComponent(TransactionComponentData root, IStackElement stckElement, boolean isAutoTrace) {
        TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
        if (isAutoTrace) {
            if (stckElement instanceof InvocationData) {
                String compId;
                InvocationData rootInvData = (InvocationData)stckElement;
                AutoTracingCollectStatus atcs = rootInvData.getAutoTracingCollectStatus();
                String reason = atcs.getReason();
                if (AutoTracingController.useDetailedTriggerReasonInTrace() && (compId = atcs.getIdentifier()) != null) {
                    reason = reason + " [" + compId + "]";
                }
                root.setParameterValue("Trace Type", "Normal");
                root.setParameterValue("Autotrace Trigger Criteria", reason);
            }
            root.setParameterValue("Trace Reason", "Autotrace");
        } else {
            ISamplingResult.Answer samplingAnswer = tcs.getSampled().shouldStartSampling();
            if (samplingAnswer.choice == ISamplingResult.Choice.YES) {
                root.setParameterValue("Trace Type", "Sampled");
                if (samplingAnswer.byWho != null) {
                    root.setParameterValue("Trace Reason", samplingAnswer.byWho);
                }
            }
            if (tcs.isComponentClampAlreadyHitForTxn()) {
                root.setParameterValue("Components Not Shown", Integer.toString(tcs.getComponentClampAfterCount()));
            }
            if (tcs.getTraceCollectionReason() != null) {
                root.setParameterValue("Trace Reason", tcs.getTraceCollectionReason());
            }
        }
        root.setParameterValue("Instrumentation Level", sInstrumentationStatusManager.getCurrentStatus());
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                IntelligentTransactionHarvesterHelper.validateTransactionFromIntelligentInstrumentation((TransactionComponentData)root.getSubNode(i), root);
            }
        }
    }

    public static void cleanupAfterTT(IntelligentInstrumentationThreadLocalObject tlObj) {
        tlObj.reset();
    }

    private static void harvestTransactionFromIntelligentInstrumentationWithThrottle(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement rootElement, ITcdMap normalTcdMap, ObjectInternLRUCache<String> stringIntern, int limit) {
        ErrorElementsParameterContainer errorParamContainer = deepStack.fErrorSnapshotTriggered ? deepStack.fErrorElementsParameterContainer : null;
        IntelligentTransactionHarvesterHelper.createTcd(deepStack, rootElement, normalTcdMap, stringIntern, errorParamContainer);
        IntelligentTransactionHarvesterHelper.decorateRootComponentWithError(deepStack, rootElement, stringIntern);
        if (limit <= 0) {
            limit = Integer.MAX_VALUE;
        }
        int stackElements = Math.min(deepStack.getStackElementCount(), limit);
        for (int i = 2; i <= stackElements; ++i) {
            HighPerformanceIntelligenceStackElement stackElement = deepStack.getElementAt(i);
            IntelligentTransactionHarvesterHelper.createTcd(deepStack, stackElement, normalTcdMap, stringIntern, errorParamContainer);
        }
        IntelligentTransactionHarvesterHelper.joinTCDSubTrees(deepStack, stackElements);
    }

    private static void joinTCDSubTrees(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, int stackElements) {
        HighPerformanceIntelligenceStackElement rootElement = deepStack.getElementAt(1);
        TransactionComponentData tcdRoot = rootElement.getTransactionComponentData();
        if (tcdRoot == null) {
            return;
        }
        rootElement.reassignTcdCursor(null);
        for (int i = 2; i <= stackElements; ++i) {
            HighPerformanceIntelligenceStackElement stackElement = deepStack.getElementAt(i);
            stackElement.joinTCDSubTreeWithParent();
        }
        rootElement.reassignTcdCursor(tcdRoot);
    }

    private static void decorateRootComponentWithError(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement rootElement, ObjectInternLRUCache<String> stringIntern) {
        if (!deepStack.fErrorSnapshotTriggered) {
            return;
        }
        TransactionComponentData tcd = rootElement.getTransactionComponentData();
        HighPerformanceIntelligenceStackElement exElem = deepStack.IIntelligentInstrumentationMethodTracer_getExceptionElement();
        if (exElem == null) {
            return;
        }
        String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(exElem);
        tcd.setParameterValue("Error Message", stringIntern.intern(errorMessage));
        Throwable error = exElem.getInvocationThrownException();
        if (error == null) {
            return;
        }
        StackTraceElement[] stackTraceElements = error.getStackTrace();
        if (stackTraceElements.length > 0) {
            tcd.setParameterValue("Exception", stringIntern.intern(InvocationData.limitSize(stackTraceElements[0].toString())));
        } else {
            tcd.setParameterValue("Exception", stringIntern.intern(errorMessage));
        }
    }

    private static void createTcd(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement deepElement, ITcdMap normalTcdMap, ObjectInternLRUCache<String> stringInternMap, ErrorElementsParameterContainer errorParams) {
        int invocationId = deepElement.getInvocationId();
        if (invocationId < 0) {
            IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(deepStack, deepElement, stringInternMap);
            return;
        }
        TransactionComponentData normalTcd = normalTcdMap.get(invocationId);
        if (normalTcd != null) {
            deepElement.setTransactionComponentData(normalTcd);
        } else if (!IntelligentTransactionHarvesterHelper.createTcdWithWTS(deepStack, deepElement, stringInternMap)) {
            IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(deepStack, deepElement, stringInternMap);
        }
        IntelligentTransactionHarvesterHelper.addParamsFromErrorSnapshot(errorParams, deepElement, invocationId, stringInternMap);
    }

    private static boolean createTcdWithWTS(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement deepElement, ObjectInternLRUCache<String> stringInternMap) {
        ITransactionElement txElement = deepElement.getLastTransactionElement();
        if (txElement == null) {
            return false;
        }
        boolean hasNoticedBackendElement = false;
        ArrayList<ITransactionElement> elements = new ArrayList<ITransactionElement>();
        ITransactionElement firstTransactionElement = deepElement.getFirstTransactionElement();
        while (txElement != null && txElement != firstTransactionElement) {
            elements.add(txElement);
            txElement = txElement.getParent();
        }
        elements.add(firstTransactionElement);
        for (int i = elements.size(); i > 0; --i) {
            txElement = (ITransactionElement)elements.get(i - 1);
            if (txElement instanceof BlameTransactionElement) {
                BlameTransactionElement be = (BlameTransactionElement)txElement;
                if (!(be instanceof ISkipDeepTraceElement)) {
                    IntelligentTransactionHarvesterHelper.createTcd(deepStack, deepElement, be, stringInternMap);
                }
                hasNoticedBackendElement = hasNoticedBackendElement || be.isBackend();
                continue;
            }
            IntelligentTransactionHarvesterHelper.decorateComponentWithParameters(deepStack, deepElement, stringInternMap);
        }
        if (hasNoticedBackendElement) {
            IntelligentTransactionHarvesterHelper.addParamsFromSocket(deepElement, deepElement.getLastTransactionElement(), stringInternMap);
        }
        return true;
    }

    private static void addParamsFromErrorSnapshot(ErrorElementsParameterContainer errorParams, IIntelligentInstrumentationStackElement rootElement, int invocationId, ObjectInternLRUCache<String> stringInternMap) {
        if (errorParams == null || !errorParams.hasErrorElement(invocationId)) {
            return;
        }
        Map<String, String> params = errorParams.getParameters(invocationId);
        TransactionComponentData tcd = rootElement.getTransactionComponentData();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String param = entry.getKey();
            if (param.equals("Trace Type") || tcd.getParameterValue(param) != null) continue;
            tcd.setParameterValue(stringInternMap.intern(param), stringInternMap.intern(entry.getValue()));
        }
    }

    private static void createTcd(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement rootElement, BlameTransactionElement blameElement, ObjectInternLRUCache<String> stringInternMap) {
        String resourceName = blameElement.getResourceName();
        String componentName = stringInternMap.intern(resourceName != null ? resourceName : rootElement.getElementName());
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, rootElement.getStartTime(), rootElement.getDuration());
        rootElement.setTransactionComponentData(component);
        Map<String, String> parameters = component.getParameters();
        parameters.put("Method", stringInternMap.intern(rootElement.getProbeMethodName()));
        parameters.put("Method Descriptor", stringInternMap.intern(rootElement.getProbeMethodDescriptor()));
        parameters.put("Class", stringInternMap.intern(rootElement.getProbeClassName()));
        String lineInfo = stringInternMap.intern(rootElement.getProbeSourceLine());
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        if (rootElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", stringInternMap.intern(rootElement.getProbeMethodScoreLevel()));
        }
        if (blameElement instanceof IParamsProviderElement) {
            if (stringInternMap == null) {
                ((IParamsProviderElement)((Object)blameElement)).addParams(parameters);
            } else {
                HashMap<String, String> params2 = new HashMap<String, String>();
                ((IParamsProviderElement)((Object)blameElement)).addParams(params2);
                if (!params2.isEmpty()) {
                    for (Map.Entry e : params2.entrySet()) {
                        parameters.put(stringInternMap.intern((String)e.getKey()), stringInternMap.intern((String)e.getValue()));
                    }
                }
            }
        }
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isExceptionElement(deepStack, ((HighPerformanceIntelligenceStackElement)rootElement).fCurrentCursor)) {
            String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(rootElement);
            errorMessage = InvocationData.limitSize(errorMessage);
            parameters.put("Trace Type", "Normal");
            parameters.put("Error Message", stringInternMap.intern(errorMessage));
            Throwable error = ((HighPerformanceIntelligenceStackElement)rootElement).getInvocationThrownException();
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    parameters.put("Exception", stringInternMap.intern(InvocationData.limitSize(stackTraceElements[0].toString())));
                } else {
                    parameters.put("Exception", stringInternMap.intern(errorMessage));
                }
            }
        }
    }

    private static void decorateComponentWithParameters(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, IIntelligentInstrumentationStackElement rootElement, ObjectInternLRUCache<String> stringInternMap) {
        String componentName = stringInternMap.intern(rootElement.getElementName());
        TransactionComponentData component = TransactionComponentData.createMilliSecTransactionComponentData(componentName, rootElement.getStartTime(), rootElement.getDuration());
        rootElement.setTransactionComponentData(component);
        Map<String, String> parameters = component.getParameters();
        parameters.put("Method", stringInternMap.intern(rootElement.getProbeMethodName()));
        parameters.put("Method Descriptor", stringInternMap.intern(rootElement.getProbeMethodDescriptor()));
        parameters.put("Class", stringInternMap.intern(rootElement.getProbeClassName()));
        String lineInfo = stringInternMap.intern(rootElement.getProbeSourceLine());
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        if (rootElement.getInvocationId() == -1) {
            parameters.put("Method Score Level", stringInternMap.intern(rootElement.getProbeMethodScoreLevel()));
            parameters.put("Is Unmonitored", "True");
        }
        if (HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isExceptionElement(deepStack, ((HighPerformanceIntelligenceStackElement)rootElement).fCurrentCursor)) {
            String errorMessage = HighPerformanceIntelligentErrorFeature.constructErrorMessage(rootElement);
            errorMessage = InvocationData.limitSize(errorMessage);
            parameters.put("Error Message", stringInternMap.intern(errorMessage));
            Throwable error = ((HighPerformanceIntelligenceStackElement)rootElement).getInvocationThrownException();
            if (error != null) {
                StackTraceElement[] stackTraceElements = error.getStackTrace();
                if (stackTraceElements.length > 0) {
                    parameters.put("Exception", stringInternMap.intern(InvocationData.limitSize(stackTraceElements[0].toString())));
                } else {
                    parameters.put("Exception", stringInternMap.intern(errorMessage));
                }
            }
        }
    }

    public static void submitTransactionToCache(IStackElement stckElement) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
        deepStack.prepareOnStartHarvestTransaction();
        if (!IntelligentTransactionHarvesterHelper.isDownStreamAgentForTx(stckElement)) {
            deepStack.tearMeDown();
            return;
        }
        ITcdMap normalTcdMap = deepStack.sIntelligentThreadLocalObject.fTopTCDElements;
        if (normalTcdMap == null) {
            normalTcdMap = IntelligentTransactionHarvesterHelper.harvestTcdFromNormalTracer(stckElement, deepStack, null, 1);
        }
        if (normalTcdMap == null) {
            HighPerformanceIntelligenceStackElement.getAgent().IAgent_getModuleFeedback().warn("Transaction trace is corruped, will not cache it");
            deepStack.tearMeDown();
            return;
        }
        if (deepStack.markShouldCache()) {
            deepStack.sIntelligentThreadLocalObject.fTopTCDElements = normalTcdMap;
        } else {
            HighPerformanceIntelligenceStackElement.getAgent().IAgent_getModuleFeedback().warn("Somebody had requested caching already, this should not happen, transaction trace is discarded");
        }
        deepStack.tearMeDown();
    }

    public static boolean isDownStreamAgentForTx(IStackElement stckElement) {
        SharedCrossProcessData cpCache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCacheOrNull();
        if (cpCache == null) {
            return false;
        }
        if (cpCache.isCrossThreadId()) {
            if (!AsyncVirtualStack.doCacheDownstreamFragments()) {
                return false;
            }
            if (AsyncVirtualStack.doSupressTrivialFragments()) {
                if (stckElement == null) {
                    return false;
                }
                TransactionCollectStatus tcs = stckElement.getTransactionCollectionStatus();
                if (tcs.isTrivialAsynchFragment) {
                    return false;
                }
            }
        }
        return cpCache.hasRemotelyGeneratedCorrelationId();
    }

    private static void decorateComponentWithProbeInfo(Map<String, String> parameters, ProbeInformation probeInfo) {
        if (probeInfo == null) {
            return;
        }
        ProbeIdentification probeIdentification = probeInfo.getProbeIdentification();
        parameters.put("Method", probeIdentification.getProbeMethodName());
        parameters.put("Method Descriptor", probeIdentification.getProbeMethodDescriptor());
        parameters.put("Class", probeIdentification.getRuntimeFullClassName());
        String lineInfo = probeIdentification.getSourceFileLine();
        if (lineInfo != null) {
            parameters.put("Source Line", lineInfo);
        }
        IFactoryLevelParameterCallback[] staticCallbacks = probeInfo.getCallbacks();
        for (int i = 0; i < staticCallbacks.length; ++i) {
            if (staticCallbacks[i] == null) continue;
            staticCallbacks[i].IFactoryLevelParameterCallback_addParameters(parameters);
        }
    }

    private static void addParamsFromSocket(IIntelligentInstrumentationStackElement rootElement, ITransactionElement txnElement, ObjectInternLRUCache<String> stringInternMap) {
        Map<String, String> socketParams = IntelligentTransactionHarvesterHelper.fetchSocketParameters(txnElement);
        if (socketParams.isEmpty()) {
            return;
        }
        if (stringInternMap != null) {
            HashMap<String, String> socketParamsIntern = new HashMap<String, String>(socketParams.size());
            for (Map.Entry<String, String> e : socketParams.entrySet()) {
                socketParamsIntern.put(stringInternMap.intern(e.getKey()), stringInternMap.intern(e.getValue()));
            }
            socketParams = socketParamsIntern;
        }
        TransactionComponentData tcd = rootElement.getTransactionComponentData();
        while (tcd != null) {
            tcd.getParameters().putAll(socketParams);
            tcd = tcd.getSubNodeCount() > 0 ? tcd.getSubNode(0) : null;
        }
    }

    private static Map<String, String> fetchSocketParameters(ITransactionElement txnElement) {
        if (txnElement.hasChildren()) {
            HashMap<String, String> parameters = new HashMap<String, String>(5);
            Iterator it = txnElement.iterateChildren();
            int index = 1;
            while (it.hasNext()) {
                ITransactionElement el;
                ITransactionElement next = (ITransactionElement)it.next();
                if (next instanceof SocketTransactionElement) {
                    TransactionHarvestHelper.includeSocketParams(index++, (SocketTransactionElement)next, parameters);
                    continue;
                }
                if (!(next instanceof SetElement) || !((el = ((SetElement)next).getElement()) instanceof SocketTransactionElement)) continue;
                TransactionHarvestHelper.includeSocketParams(index++, (SocketTransactionElement)el, parameters);
            }
            return parameters;
        }
        return Collections.emptyMap();
    }

    private static class InternedParamsMap<T>
    extends HashMap<T, T> {
        private static final long serialVersionUID = 1L;
        final ObjectInternLRUCache<T> cache;

        public InternedParamsMap(ObjectInternLRUCache<T> cache) {
            this.cache = cache;
        }

        @Override
        public T put(T key, T value) {
            return super.put(this.cache.intern(key), this.cache.intern(value));
        }

        @Override
        public void putAll(Map<? extends T, ? extends T> map) {
            for (Map.Entry<T, T> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public static interface TCDPreSendCallback {
        public TransactionComponentData beforeSending(TransactionComponentData var1);
    }
}

