/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.ASocketCounter;
import com.wily.util.properties.AttributeListing;

public class OutputStreamRateTracer
extends ASocketCounter
implements ITracer {
    protected final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public OutputStreamRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final IIntegerRateDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName = this.quickFormat(data, this.getMetricPosition());
        if (formattedName != null) {
            return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketRequired() && data.hasSocketResource()) {
            return this;
        }
        return null;
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        IIntegerRateDataAccumulator rate;
        Object invocationObject = data.getInvocationObject();
        if (!data.hasInvocationThrownException() && (rate = this.createDataAccumulator(data)) != null && !rate.IDataAccumulator_isShutOff()) {
            int nBytes = 1;
            if (data.getInvocationParameterCount() == 3) {
                nBytes = (Integer)data.getInvocationParameterAsObject(2);
            } else {
                Object firstParam = data.getInvocationParameterAsObject(0);
                if (firstParam.getClass().isArray()) {
                    nBytes = ((byte[])firstParam).length;
                }
            }
            rate.IIntegerRateDataAccumulator_addBatchIncidents(nBytes);
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    protected final int getMetricPosition() {
        return 7;
    }
}

