/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.ongoingquery;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.callback.CallbackConnector;
import com.wily.isengard.messageprimitives.callback.ICallbackConnectorCloseNotification;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.ongoingquery.AQueryNotification;
import com.wily.isengard.ongoingquery.ClosableQueriable;
import com.wily.isengard.ongoingquery.FilteredStates;
import com.wily.isengard.ongoingquery.IQueriable;
import com.wily.isengard.ongoingquery.IQueryMatch;
import com.wily.isengard.ongoingquery.QueryExecutor;
import com.wily.isengard.ongoingquery.QueryFuture;
import com.wily.isengard.ongoingquery.QueryID;
import com.wily.isengard.ongoingquery.QueryNotificationConnector;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.exception.UnexpectedExceptionError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractQueryServiceManager {
    private final PostOffice po;
    private int id = 0;

    protected AbstractQueryServiceManager(PostOffice po) {
        this.po = po;
    }

    protected abstract void runNotification(Runnable var1);

    protected abstract Map getQueries();

    public abstract void acquireReadStateLock() throws InterruptedException;

    public abstract void releaseReadStateLock();

    public abstract void acquireWriteStateLock() throws InterruptedException;

    public abstract void releaseWriteStateLock();

    public QueryID addOngoingQuery(IQueriable query, AQueryNotification notification) throws EndpointNotFoundException {
        OngoingQuery ongoingQuery = new OngoingQuery(this.po, notification, query);
        Collection matches = query.matchState();
        this.runNotification(new NotifyAdded(ongoingQuery, matches, true));
        return ongoingQuery.getQueryID();
    }

    public Runnable addOngoingQueryAsync(final IQueriable query, AQueryNotification notification) throws EndpointNotFoundException {
        OngoingQuery ongoingQuery;
        try {
            this.acquireReadStateLock();
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
        try {
            ongoingQuery = new OngoingQuery(this.po, notification, query);
        }
        finally {
            this.releaseReadStateLock();
        }
        return new Runnable(){

            @Override
            public void run() {
                Collection matches = query.matchState();
                AbstractQueryServiceManager.this.runNotification(new NotifyAdded(ongoingQuery, matches, true));
            }
        };
    }

    public QueryID addOngoingQuery2(IQueriable query, AQueryNotification notification) throws EndpointNotFoundException {
        OngoingQuery ongoingQuery = null;
        try {
            this.acquireReadStateLock();
        }
        catch (InterruptedException e) {
            throw new UnexpectedExceptionError(e);
        }
        try {
            ongoingQuery = new OngoingQuery(this.po, notification, query);
        }
        finally {
            this.releaseReadStateLock();
        }
        Collection matches = query.matchState();
        this.runNotification(new NotifyAdded(ongoingQuery, matches, true));
        return ongoingQuery.getQueryID();
    }

    private synchronized QueryID getNewID() {
        return new QueryID(++this.id);
    }

    private void registerOngoingQuery(OngoingQuery ongoingQuery) {
        this.getQueries().put(ongoingQuery.getQueryID(), ongoingQuery);
    }

    public void removeOngoingQuery(QueryID queryID) {
        IQueriable queriable;
        try {
            this.acquireReadStateLock();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Object query = this.getQueries().get(queryID);
        try {
            this.getQueries().remove(queryID);
        }
        finally {
            this.releaseReadStateLock();
        }
        if (query instanceof OngoingQuery && (queriable = ((OngoingQuery)query).getQuery()) instanceof ClosableQueriable) {
            ((ClosableQueriable)queriable).close();
        }
    }

    public int getNumQueries() {
        return this.getQueries().size();
    }

    public void stateAdded(Object[] stateData) {
        this.stateAdded(stateData, null);
    }

    public void stateAdded(final Object[] stateData, QueryExecutor executor) {
        if (stateData.length == 0) {
            return;
        }
        ArrayList futures = executor == null ? null : new ArrayList();
        for (final OngoingQuery query : this.getQueries().values()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IQueriable queriable = query.getQuery();
                    if (queriable instanceof ClosableQueriable) {
                        FilteredStates states = ((ClosableQueriable)queriable).matchStates(stateData, null, null);
                        AbstractQueryServiceManager.this.runNotifications(query, states, false);
                    } else {
                        Collection matches = queriable.matchAddedState(stateData);
                        if (!matches.isEmpty()) {
                            AbstractQueryServiceManager.this.runNotification(new NotifyAdded(query, matches, false));
                        }
                    }
                }
            };
            this.runTask(executor, futures, runnable);
        }
        this.joinTasks(executor, futures);
    }

    protected void runNotifications(OngoingQuery query, FilteredStates states, boolean initialMatchesFinished) {
        if (states.getStateAdded() != null) {
            this.runNotification(new NotifyAdded(query, states.getStateAdded(), initialMatchesFinished));
        }
        if (states.getStateChanged() != null) {
            this.runNotification(new NotifyChanged(query, states.getStateChanged()));
        }
        if (states.getStateRemoved() != null) {
            this.runNotification(new NotifyRemoved(query, states.getStateRemoved()));
        }
    }

    public void runTask(QueryExecutor executor, List futures, Runnable runnable) {
        if (executor == null) {
            runnable.run();
        } else {
            futures.add(executor.submit(runnable));
        }
    }

    public void joinTasks(QueryExecutor executor, List futures) {
        if (executor != null) {
            for (QueryFuture f : futures) {
                f.get();
            }
        }
    }

    public void stateRemoved(Object[] stateData) {
        this.stateRemoved(stateData, null);
    }

    public void stateRemoved(final Object[] stateData, QueryExecutor executor) {
        if (stateData.length == 0) {
            return;
        }
        ArrayList futures = executor == null ? null : new ArrayList();
        for (final OngoingQuery query : this.getQueries().values()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IQueriable queriable = query.getQuery();
                    if (queriable instanceof ClosableQueriable) {
                        FilteredStates states = ((ClosableQueriable)queriable).matchStates(null, null, stateData);
                        AbstractQueryServiceManager.this.runNotifications(query, states, false);
                    } else {
                        Collection matches = queriable.matchRemovedState(stateData);
                        if (matches.isEmpty()) {
                            return;
                        }
                        AbstractQueryServiceManager.this.runNotification(new NotifyRemoved(query, matches));
                        Collection moreMatches = query.getQuery().matchState();
                        if (!moreMatches.isEmpty()) {
                            try {
                                query.getMatchInterface().dataAdded(moreMatches);
                            }
                            catch (ConnectionException connectionException) {}
                        }
                    }
                }
            };
            this.runTask(executor, futures, runnable);
        }
        this.joinTasks(executor, futures);
    }

    public void stateChanged(Object[] stateData) {
        this.stateChanged(stateData, null);
    }

    public void stateChanged(final Object[] stateData, QueryExecutor executor) {
        if (stateData.length == 0) {
            return;
        }
        ArrayList futures = executor == null ? null : new ArrayList();
        for (final OngoingQuery query : this.getQueries().values()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IQueriable queriable = query.getQuery();
                    if (queriable instanceof ClosableQueriable) {
                        FilteredStates states = ((ClosableQueriable)queriable).matchStates(null, stateData, null);
                        AbstractQueryServiceManager.this.runNotifications(query, states, false);
                    } else {
                        Collection matches = queriable.matchChangedState(stateData);
                        if (matches.isEmpty()) {
                            return;
                        }
                        AbstractQueryServiceManager.this.runNotification(new NotifyChanged(query, matches));
                    }
                }
            };
            this.runTask(executor, futures, runnable);
        }
        this.joinTasks(executor, futures);
    }

    private void closeQuery(OngoingQuery query) {
        this.removeOngoingQuery(query.getQueryID());
    }

    private class NotifyAdded
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;
        private final boolean initialMatchesFinished;

        public NotifyAdded(OngoingQuery notify, Collection state, boolean initialMatchesFinished) {
            this.notify = notify;
            this.state = state;
            this.initialMatchesFinished = initialMatchesFinished;
        }

        @Override
        public void run() {
            try {
                if (!this.state.isEmpty()) {
                    this.notify.getMatchInterface().dataAdded(this.state);
                }
                if (this.initialMatchesFinished) {
                    this.notify.getMatchInterface().initialMatchesFinished();
                }
            }
            catch (ConnectionException connectionException) {}
        }
    }

    private class NotifyChanged
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;

        public NotifyChanged(OngoingQuery notify, Collection state) {
            this.notify = notify;
            this.state = state;
        }

        @Override
        public void run() {
            try {
                this.notify.getMatchInterface().dataChanged(this.state);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    private class NotifyRemoved
    implements Runnable {
        private final OngoingQuery notify;
        private final Collection state;

        public NotifyRemoved(OngoingQuery notify, Collection state) {
            this.notify = notify;
            this.state = state;
        }

        @Override
        public void run() {
            try {
                this.notify.getMatchInterface().dataRemoved(this.state);
            }
            catch (ConnectionException connectionException) {}
        }
    }

    protected final class OngoingQuery
    implements ICallbackConnectorCloseNotification {
        private final QueryID queryID;
        private final IQueriable query;
        private final QueryNotificationConnector connector;

        public OngoingQuery(PostOffice po, AQueryNotification notification, IQueriable query) throws EndpointNotFoundException {
            this.queryID = AbstractQueryServiceManager.this.getNewID();
            this.query = query;
            AbstractQueryServiceManager.this.registerOngoingQuery(this);
            try {
                this.connector = new QueryNotificationConnector(po, notification, this);
            }
            catch (EndpointNotFoundException t) {
                AbstractQueryServiceManager.this.removeOngoingQuery(this.queryID);
                throw t;
            }
        }

        public void close() {
            this.connector.close();
        }

        public IQueriable getQuery() {
            return this.query;
        }

        public QueryID getQueryID() {
            return this.queryID;
        }

        @Override
        public void closing(CallbackConnector which) {
            AbstractQueryServiceManager.this.closeQuery(this);
        }

        public IQueryMatch getMatchInterface() {
            return (IQueryMatch)this.connector.getInterface();
        }
    }
}

