/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.MethodDescriptorUtilities;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.LocalizedMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClassFileMethodDescriptor
implements IMethodSignature {
    private static final String kInitialTypeList = "(";
    private String fMethodDescriptor;
    private ClassFileFieldDescriptor[] fArguments;
    private ClassFileFieldDescriptor fReturnValue;

    public ClassFileMethodDescriptor() {
        this.fArguments = null;
        this.fReturnValue = ClassFileFieldDescriptor.getVoidDescriptor();
    }

    public ClassFileMethodDescriptor(Method method) throws InvalidMethodDescriptorException {
        Class<?>[] arguments = method.getParameterTypes();
        Class<?> returnValue = method.getReturnType();
        int argNum = arguments.length;
        try {
            StringBuilder descriptor = new StringBuilder();
            descriptor.append('(');
            this.fArguments = new ClassFileFieldDescriptor[argNum];
            int i = 0;
            while (i < argNum) {
                String argDescriptor = MethodDescriptorUtilities.getParamDescriptor(arguments[i]);
                this.fArguments[i] = new ClassFileFieldDescriptor(argDescriptor);
                descriptor.append(argDescriptor);
                ++i;
            }
            descriptor.append(')');
            String retDescriptor = MethodDescriptorUtilities.getReturnDescriptor(returnValue);
            this.fReturnValue = new ClassFileFieldDescriptor(retDescriptor);
            descriptor.append(retDescriptor);
            this.fMethodDescriptor = descriptor.toString();
        }
        catch (InvalidFieldDescriptorException e) {
            throw new InvalidMethodDescriptorException(new LocalizedMessage(e.getLocalizedMessage()), method.getName());
        }
    }

    public ClassFileMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this(methodDescriptor, true);
    }

    public ClassFileMethodDescriptor(String methodDescriptor, boolean doValidate) throws InvalidMethodDescriptorException {
        this.setMethodDescriptor(methodDescriptor, doValidate);
    }

    protected void setMethodDescriptor(String methodDescriptor) throws InvalidMethodDescriptorException {
        this.setMethodDescriptor(methodDescriptor, true);
    }

    protected void setMethodDescriptor(String methodDescriptor, boolean doValidate) throws InvalidMethodDescriptorException {
        this.fMethodDescriptor = methodDescriptor;
        this.parseDescriptor(doValidate);
    }

    private void parseDescriptor(boolean doValidate) throws InvalidMethodDescriptorException {
        ArrayList<ClassFileFieldDescriptor> argList = new ArrayList<ClassFileFieldDescriptor>();
        this.fReturnValue = null;
        if (this.fMethodDescriptor == null) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), "");
        }
        StringTokenizer tokenizer = new StringTokenizer(this.fMethodDescriptor, kInitialTypeList, true);
        if (!tokenizer.hasMoreTokens()) {
            throw new InvalidMethodDescriptorException(new SimpleLocalizableMessage("Class_File_Method_Descriptor_Empty"), this.fMethodDescriptor);
        }
        if (!tokenizer.nextToken().equals(kInitialTypeList)) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Start_Parameter_List", this.fMethodDescriptor), this.fMethodDescriptor);
        }
        try {
            try {
                ClassFileFieldDescriptor field;
                while ((field = new ClassFileFieldDescriptor(tokenizer, false, doValidate)).isValid()) {
                    argList.add(field);
                }
                if (argList.size() > 0) {
                    this.fArguments = argList.toArray(new ClassFileFieldDescriptor[argList.size()]);
                }
            }
            catch (InvalidFieldDescriptorException invalidFieldDescriptorException) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Parameter", this.fMethodDescriptor), this.fMethodDescriptor);
            }
            this.fReturnValue = new ClassFileFieldDescriptor(tokenizer, true);
            if (!this.fReturnValue.isValid()) {
                throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Missing_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
            }
        }
        catch (InvalidFieldDescriptorException invalidFieldDescriptorException) {
            throw new InvalidMethodDescriptorException(new FormattedLocalizableMessage("Class_File_Method_Descriptor_Invalid_Return_Type", this.fMethodDescriptor), this.fMethodDescriptor);
        }
    }

    public int getArgumentCount() {
        if (this.fArguments == null) {
            return 0;
        }
        return this.fArguments.length;
    }

    public ClassFileFieldDescriptor getArgumentAt(int index) {
        return this.fArguments[index];
    }

    public ClassFileFieldDescriptor getReturnType() {
        return this.fReturnValue;
    }

    @Override
    public int getParameterCount() {
        return this.getArgumentCount();
    }

    @Override
    public ISlotSignature getParameterSignatureByIndex(int index) {
        return this.getArgumentAt(index);
    }

    @Override
    public ISlotSignature getReturnSlotSignature() {
        return this.getReturnType();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFileMethodDescriptor) {
            ClassFileMethodDescriptor desc = (ClassFileMethodDescriptor)obj;
            if (this.getArgumentCount() != desc.getArgumentCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getArgumentCount()) {
                if (!this.getArgumentAt(i).equals(desc.getArgumentAt(i))) {
                    return false;
                }
                ++i;
            }
            return this.getReturnType().equals(desc.getReturnType());
        }
        return false;
    }

    public int hashCode() {
        return this.fMethodDescriptor.hashCode();
    }

    public String toString() {
        return this.fMethodDescriptor;
    }

    @Override
    public String getSignatureString() {
        int argumentCount = this.getArgumentCount();
        StringBuilder formatted = new StringBuilder(argumentCount * 30);
        formatted.append(kInitialTypeList);
        int i = 0;
        while (i < argumentCount) {
            ClassFileFieldDescriptor field = this.getArgumentAt(i);
            formatted.append(field.getSignatureString());
            if (i + 1 < argumentCount) {
                formatted.append(", ");
            }
            ++i;
        }
        formatted.append(")");
        return formatted.toString();
    }
}

