/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation.helper;

import com.ca.apm.parent.instrumentation.helper.FilePersistenceServiceStatusHelper;
import com.ca.apm.parent.instrumentation.helper.JMSInstrumentationConstants;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationConfig;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationHelper;
import com.wily.diagnos.cmp.directives.apply.ParentPersistenceFileLockHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.util.AgentFileUtil;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.introscope.probebuilder.intelligent.util.ClassMethodInfo;
import com.wily.introscope.probebuilder.intelligent.util.MethodInfo;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ParentCandidateFilePersistenceHelper
implements ITimestampedRunnable {
    private IAgent agent;
    private IModuleFeedbackChannel feedback;
    private static final Module module = new Module("ParentCandidateFilePersistenceHelper");
    private boolean logPermissionMessageFlag;
    private boolean logInvalidPathMessageFlag;
    private HashMap<String, ClassMethodInfo> finalMethodListToWrite;
    private HashMap<String, ClassMethodInfo> filteredMethods;
    private static AtomicInteger instrumentedMethodsCountInPbd = new AtomicInteger(0);
    private int logBitMask = 0;
    int lockFileBitMask = 1;
    int traceClampBitMask = 2;
    int queueSizeClampBitMask = 8;
    int notPersistedBitMask = 16;

    public ParentCandidateFilePersistenceHelper(IAgent agent) {
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        this.logPermissionMessageFlag = false;
        this.logInvalidPathMessageFlag = false;
        this.finalMethodListToWrite = new HashMap();
        this.filteredMethods = new HashMap();
    }

    public void ITimestampedRunnable_execute(long milliseconds) {
        try {
            this.checkClampBitMasks();
            if (!ParentPersistenceFileLockHelper.initializeSuccessful) {
                return;
            }
            this.persistToFile();
        }
        catch (Exception e) {
            this.feedback.error(module, "Unexpected exception in persistancy service ", (Throwable)e);
        }
    }

    private void checkClampBitMasks() {
        this.fileLockCheck(this.lockFileBitMask);
        this.instrumentedMethodCountCheck(this.traceClampBitMask);
        this.queueClampCheck(this.queueSizeClampBitMask);
        this.filePersistenceCheck(this.notPersistedBitMask);
    }

    private void fileLockCheck(int lockFileBitMask) {
        if (!ParentPersistenceFileLockHelper.initializeSuccessful) {
            ParentPersistenceFileLockHelper.initialize((IAgent)this.agent);
            FilePersistenceServiceStatusHelper.setEntryPointBitMask(lockFileBitMask);
            return;
        }
        FilePersistenceServiceStatusHelper.clearEntryPointBitMask(lockFileBitMask);
    }

    private void instrumentedMethodCountCheck(int traceClampBitMask) {
        if (ParentInstrumentationHelper.getTraceClampStatus()) {
            FilePersistenceServiceStatusHelper.setEntryPointBitMask(traceClampBitMask);
            if ((this.logBitMask & traceClampBitMask) == 0) {
                this.feedback.warn(module, "No new JMS Receive Parent candidates will be discovered, because number of entries in the PBD has reached a clamp value of " + ParentInstrumentationConfig.getPersistenceTraceDirectivesClampSize() + ",  as defined in " + "jms.receive.parent.methods.count.max");
                this.setLogBitMask(traceClampBitMask);
            }
        } else {
            FilePersistenceServiceStatusHelper.clearEntryPointBitMask(traceClampBitMask);
            this.clearLogBitMask(traceClampBitMask);
        }
    }

    private void queueClampCheck(int queueSizeClampBitMask) {
        if (ParentInstrumentationHelper.getQueueClampStatus()) {
            FilePersistenceServiceStatusHelper.setEntryPointBitMask(queueSizeClampBitMask);
            if ((this.logBitMask & queueSizeClampBitMask) == 0) {
                this.feedback.warn(module, "No new JMS Receive Parent candidates will be discovered, because persistence queue clamp jms.receive.parent.identification.persistent.queue.size reached max value of " + ParentInstrumentationConfig.getPersistenceQueueClampSize());
                this.setLogBitMask(queueSizeClampBitMask);
            }
        } else {
            FilePersistenceServiceStatusHelper.clearEntryPointBitMask(queueSizeClampBitMask);
            this.clearLogBitMask(queueSizeClampBitMask);
        }
    }

    private void filePersistenceCheck(int notPersistedBitMask) {
        if (!this.filteredMethods.isEmpty()) {
            FilePersistenceServiceStatusHelper.setEntryPointBitMask(notPersistedBitMask);
            if ((this.logBitMask & notPersistedBitMask) == 0) {
                this.feedback.warn(module, "No new JMS Receive Parent candidates will be discovered, because entry point persistence has failed");
                this.setLogBitMask(notPersistedBitMask);
            }
        } else {
            FilePersistenceServiceStatusHelper.clearEntryPointBitMask(notPersistedBitMask);
            this.clearLogBitMask(notPersistedBitMask);
        }
    }

    private void populateToPersistMethodsMap() {
        Set<String> keys = ParentInstrumentationHelper.getParentInstAllKeys();
        Iterator<String> it = keys.iterator();
        ClassName iclass = null;
        ArrayList<String> keysReadAlready = new ArrayList<String>();
        while (it.hasNext()) {
            String tempKey = it.next();
            String[] tempValue = ParentInstrumentationHelper.getParentInstValue(tempKey);
            keysReadAlready.add(tempKey);
            try {
                iclass = ClassName.getClassName((String)tempValue[0]);
                String className = iclass.getReflectionFriendlyQualifiedNameString();
                ClassMethodInfo cMInfo = this.filteredMethods.get(className);
                if (cMInfo == null) {
                    cMInfo = new ClassMethodInfo(className);
                    this.filteredMethods.put(className, cMInfo);
                }
                cMInfo.addMethodWithDirectiveType(tempValue[1], tempValue[2], tempValue[3]);
            }
            catch (InvalidClassNameException e) {
                this.feedback.error(module, "Could not get the class name.", (Throwable)e);
            }
        }
        ParentInstrumentationHelper.clearParentInstEntries(keysReadAlready);
    }

    private void mergeLists(HashMap<String, ClassMethodInfo> finalList, HashMap<String, ClassMethodInfo> pbdList) {
        Set<String> keyset = pbdList.keySet();
        for (String className : keyset) {
            ClassMethodInfo cmvg = pbdList.get(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo meth = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                ClassMethodInfo filtered = finalList.get(className);
                if (filtered == null) {
                    filtered = new ClassMethodInfo(className);
                    finalList.put(className, filtered);
                }
                filtered.addMethodWithDirectiveType(meth.methodName, meth.methodDesciptor, meth.directiveType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap readPbdAndCopy(String fullPath, File file) {
        HashMap<String, ClassMethodInfo> pbdList = new HashMap<String, ClassMethodInfo>();
        BufferedReader bufferedReader = null;
        try {
            if (fullPath != null) {
                int tempCount = 0;
                String encoding = System.getProperty("com.wily.introscope.default.encoding");
                FileInputStream in = new FileInputStream(file);
                bufferedReader = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)in, encoding)) : new BufferedReader(new InputStreamReader(in));
                String line = null;
                String methName = null;
                String methDesc = null;
                while ((line = bufferedReader.readLine()) != null) {
                    ClassMethodInfo clMethInfo;
                    String[] args = line.split(" ");
                    String directiveType = null;
                    if (!args[0].equalsIgnoreCase("TraceOneMethodOfClass:")) continue;
                    directiveType = "instrument";
                    ++tempCount;
                    String className = args[1];
                    String methSignature = args[2];
                    int separator = methSignature.indexOf(40);
                    if (separator != -1) {
                        methName = methSignature.substring(0, separator);
                        methDesc = methSignature.substring(separator);
                    }
                    if ((clMethInfo = (ClassMethodInfo)pbdList.get(className)) == null) {
                        clMethInfo = new ClassMethodInfo(className);
                        pbdList.put(className, clMethInfo);
                    }
                    clMethInfo.addMethodWithDirectiveType(methName, methDesc, directiveType);
                }
                instrumentedMethodsCountInPbd.set(tempCount);
            }
        }
        catch (Exception e) {
            this.feedback.error(module, "Error reading from pbd JMSParentMethodPersist.pbd", (Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (ParentInstrumentationHelper.getTraceClampStatus()) {
            this.instrumentedMethodCountCheck(this.traceClampBitMask);
            this.feedback.warn("JMSParentMethodPersist.pbd : Tracer entries clamp hit , discarding the current data.");
            ParentInstrumentationHelper.clearAllParentInstEntries();
            return null;
        }
        return pbdList;
    }

    private boolean isNew(HashMap pbdList, String MethodSignature, String className, boolean isSkipped) {
        ClassMethodInfo cmvg = (ClassMethodInfo)pbdList.get(className);
        return cmvg == null || !cmvg.contains(MethodSignature);
    }

    private void addMethodToList(String className, MethodInfo mInfo) {
        ClassMethodInfo clMethInfo = this.finalMethodListToWrite.get(className);
        if (clMethInfo == null) {
            clMethInfo = new ClassMethodInfo(className);
            this.finalMethodListToWrite.put(className, clMethInfo);
        }
        clMethInfo.addMethodWithDirectiveType(mInfo.methodName, mInfo.methodDesciptor, mInfo.directiveType);
    }

    private int mergeAllLists(HashMap filteredList, HashMap pbdList) {
        Set keyset = filteredList.keySet();
        Iterator filteredListIterator = keyset.iterator();
        int traceDirectivesClamp = ParentInstrumentationConfig.getPersistenceTraceDirectivesClampSize();
        int newEntriesCount = 0;
        while (filteredListIterator.hasNext()) {
            String className = (String)filteredListIterator.next();
            ClassMethodInfo cmvg = (ClassMethodInfo)filteredList.get(className);
            boolean classExists = pbdList.containsKey(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo mInfo = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                if (!mInfo.directiveType.equalsIgnoreCase("instrument") || instrumentedMethodsCountInPbd.get() >= traceDirectivesClamp || classExists && !this.isNew(pbdList, MethodSignature, className, false)) continue;
                this.addMethodToList(className, mInfo);
                instrumentedMethodsCountInPbd.getAndIncrement();
                ++newEntriesCount;
            }
        }
        if (newEntriesCount > 0) {
            this.mergeLists(this.finalMethodListToWrite, pbdList);
        }
        return newEntriesCount;
    }

    private void writeToBuffer(StringBuilder fileContentsToWrite, String type) throws Exception {
        boolean count = false;
        Set<String> keyset = this.finalMethodListToWrite.keySet();
        for (String className : keyset) {
            ClassMethodInfo cmvg = this.finalMethodListToWrite.get(className);
            Set k2 = cmvg.methodsWithGap.keySet();
            for (String MethodSignature : k2) {
                MethodInfo meth = (MethodInfo)cmvg.methodsWithGap.get(MethodSignature);
                if (!type.equalsIgnoreCase("instrument") || !type.equalsIgnoreCase(meth.directiveType)) continue;
                fileContentsToWrite.append(String.format("TraceOneMethodOfClass: " + className + " " + MethodSignature + " " + "JMSReceiveParentTracer" + " \"" + "JMSParentInstrumentation" + "\"%n", new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToFile() {
        if (ParentInstrumentationHelper.getDataCount() == 0) {
            return;
        }
        boolean lockAcquired = true;
        BufferedWriter bufferedWriter = null;
        String fullPath = null;
        try {
            FileOutputStream out = null;
            String fileName = "JMSParentMethodPersist.pbd";
            IDynamicInstrumentationTransformer dit = this.agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
            String path = this.getHotdeployInstallationPath();
            String encoding = System.getProperty("com.wily.introscope.default.encoding");
            if (path != null) {
                int count;
                fullPath = path + "/" + fileName;
                File f = new File(fullPath);
                int retryTimeout = 500;
                int retryAttempts = 3;
                for (count = 0; (ParentPersistenceFileLockHelper.hasLock() && ParentPersistenceFileLockHelper.isLockValid() || ParentPersistenceFileLockHelper.tryExclusiveLock() == null) && count < retryAttempts; ++count) {
                    Thread.sleep(retryTimeout);
                }
                if (count == retryAttempts) {
                    lockAcquired = false;
                    this.feedback.debug(module, "Skipping the write to " + fullPath + " since the filelock is acquired by another thread/process");
                    return;
                }
                if (f.exists() && f.lastModified() > dit.getMostRecentLoadTimeStamp()) {
                    this.feedback.debug(module, "Skipping the write to " + fullPath + " because the file has been modified since it was last read");
                    return;
                }
                if (!f.exists()) {
                    f.createNewFile();
                    AgentFileUtil.fixGroupPermissionsAndOwner((File)f);
                    out = new FileOutputStream(fullPath, false);
                    bufferedWriter = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding)) : new BufferedWriter(new OutputStreamWriter(out));
                }
                if (f.canWrite()) {
                    HashMap pbdList = this.readPbdAndCopy(fullPath, f);
                    if (pbdList != null) {
                        this.populateToPersistMethodsMap();
                        int newEntriesCount = this.mergeAllLists(this.filteredMethods, pbdList);
                        if (newEntriesCount > 0) {
                            if (out == null || bufferedWriter == null) {
                                out = new FileOutputStream(fullPath, false);
                                bufferedWriter = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoding)) : new BufferedWriter(new OutputStreamWriter(out));
                            }
                            StringBuilder fileContentsToWrite = new StringBuilder();
                            fileContentsToWrite.append(JMSInstrumentationConstants.FILE_HEADER_STRING);
                            fileContentsToWrite.append(JMSInstrumentationConstants.SET_TRACER_CLASS_MAPPING);
                            this.writeToBuffer(fileContentsToWrite, "instrument");
                            bufferedWriter.write(fileContentsToWrite.toString());
                            this.feedback.info(module, newEntriesCount + " new entries were persisted in " + fullPath);
                        }
                        this.finalMethodListToWrite.clear();
                        this.filteredMethods.clear();
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                } else if (!this.logPermissionMessageFlag) {
                    this.feedback.error(module, "Cannot write to the persistence file " + fullPath + ". Please enable write permissions");
                    this.logPermissionMessageFlag = true;
                }
            } else if (!this.logInvalidPathMessageFlag) {
                this.feedback.error(module, "Cannot write to the persistence file JMSParentMethodPersist.pbd since the path to hotdeploy is invalid");
                this.logInvalidPathMessageFlag = true;
            }
        }
        catch (FileNotFoundException e) {
            this.feedback.error(module, "Error writing to pbd " + fullPath + ". Please enable write permissions.");
        }
        catch (Exception e) {
            this.feedback.error(module, "Error writing to pbd " + fullPath + " " + e.getMessage());
        }
        finally {
            try {
                if (lockAcquired) {
                    ParentPersistenceFileLockHelper.releaseLock();
                    lockAcquired = false;
                }
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                this.feedback.error(module, "Error releasing lock after writing to JMSParentMethodPersist.pbd", (Throwable)e);
            }
        }
    }

    private void setLogBitMask(int mask) {
        this.logBitMask |= mask;
    }

    private void clearLogBitMask(int mask) {
        this.logBitMask &= ~mask;
    }

    public static int getInstrumentedMethodsCountInPbd() {
        return instrumentedMethodsCountInPbd.get();
    }

    private String getHotdeployInstallationPath() {
        String[] directivesList = AutoProbeTransformer.getDirectivesFileList();
        for (int i = 0; i < directivesList.length; ++i) {
            if (!directivesList[i].endsWith("hotdeploy")) continue;
            return directivesList[i];
        }
        return null;
    }
}

